/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.model.tasks.CaretAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionViewUtils;
import org.openide.filesystems.FileObject;

public class MacroExpansionCaretAwareFactory
extends CaretAwareCsmFileTaskFactory {
    protected CsmFileTaskFactory.PhaseRunner createTask(final FileObject fo) {
        return new CsmFileTaskFactory.PhaseRunner(){

            public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
                Document doc2;
                boolean changed = false;
                Document doc = CsmUtilities.getDocument((FileObject)fo);
                if (doc == null) {
                    return;
                }
                Object obj = doc.getProperty("use-own-caret-position");
                if (obj != null && !((Boolean)obj).booleanValue()) {
                    return;
                }
                if (!MacroExpansionCaretAwareFactory.isMacroExpansionDoc(doc) && (doc2 = (Document)doc.getProperty(Document.class)) != null && MacroExpansionCaretAwareFactory.isContextSuncEnabled(doc2)) {
                    changed = MacroExpansionViewUtils.updateView(CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fo));
                }
                if (!changed) {
                    MacroExpansionCaretAwareFactory.syncRelatedDocumentCaretPosition(fo);
                }
            }

            public boolean isValid() {
                return true;
            }

            public void cancel() {
            }

            public boolean isHighPriority() {
                return false;
            }
        };
    }

    private static boolean isMacroExpansionDoc(Document doc) {
        return doc.getProperty("macro-expansion-view-document") != null;
    }

    private static boolean isCaretSuncEnabledOnCurrentDoc(Document doc) {
        Object obj;
        Object o;
        boolean enable = true;
        if (doc.getProperty("macro-expansion-view-document") != null && (o = doc.getProperty("macro-expansion-sync-caret")) instanceof Boolean) {
            enable &= ((Boolean)o).booleanValue();
        }
        if ((obj = doc.getProperty("use-own-caret-position")) != null) {
            enable &= ((Boolean)obj).booleanValue();
        }
        return enable;
    }

    private static boolean isCaretSuncEnabledOnRelatedDoc(Document doc) {
        Object o;
        boolean enable = true;
        if (doc.getProperty("macro-expansion-view-document") != null && (o = doc.getProperty("macro-expansion-sync-caret")) instanceof Boolean) {
            enable &= ((Boolean)o).booleanValue();
        }
        return enable;
    }

    private static boolean isContextSuncEnabled(Document doc) {
        Object o;
        if (doc.getProperty("macro-expansion-view-document") != null && (o = doc.getProperty("macro-expansion-sync-context")) instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    private static void syncRelatedDocumentCaretPosition(FileObject fo) {
        FileObject file2;
        Document doc2;
        Document doc = CsmUtilities.getDocument((FileObject)fo);
        if (doc != null && MacroExpansionCaretAwareFactory.isCaretSuncEnabledOnCurrentDoc(doc) && (doc2 = (Document)doc.getProperty(Document.class)) != null && MacroExpansionCaretAwareFactory.isCaretSuncEnabledOnRelatedDoc(doc2) && (file2 = CsmUtilities.getFileObject((Document)doc2)) != null) {
            int doc2CarretPosition = CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)file2);
            int docCarretPosition = CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fo);
            int doc2CarretPositionFromDoc = MacroExpansionViewUtils.getDocumentOffset(doc2, MacroExpansionViewUtils.getFileOffset(doc, docCarretPosition));
            int docCarretPositionFromDoc2 = MacroExpansionViewUtils.getDocumentOffset(doc, MacroExpansionViewUtils.getFileOffset(doc2, doc2CarretPosition));
            if (doc2CarretPositionFromDoc >= 0 && doc2CarretPositionFromDoc < doc2.getLength()) {
                JEditorPane ep = MacroExpansionViewUtils.getEditor(doc);
                JEditorPane ep2 = MacroExpansionViewUtils.getEditor(doc2);
                if (ep != null && ep2 != null && doc2CarretPosition != doc2CarretPositionFromDoc && docCarretPosition != docCarretPositionFromDoc2 && ep.hasFocus() && !ep2.hasFocus()) {
                    MacroExpansionCaretAwareFactory.setCaretPosition(ep2, doc2CarretPositionFromDoc);
                }
            }
        }
    }

    private static void setCaretPosition(final JEditorPane pane, final int position) {
        Runnable setCaret = new Runnable(){

            @Override
            public void run() {
                if (pane.getDocument() != null && position <= pane.getDocument().getLength()) {
                    pane.setCaretPosition(position);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            setCaret.run();
        } else {
            SwingUtilities.invokeLater(setCaret);
        }
    }

    protected int taskDelay() {
        return 0;
    }

    protected int rescheduleDelay() {
        return 0;
    }
}

