/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.wssx.elements;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.BinarySecretType;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.wssx.bindings.RequestedProofTokenType;
import com.sun.xml.ws.security.trust.impl.wssx.elements.BinarySecretImpl;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestedProofTokenImpl
extends RequestedProofTokenType
implements RequestedProofToken {
    private String tokenType;
    private URI computedKey;
    private BinarySecret secret;
    private SecurityTokenReference str;

    public RequestedProofTokenImpl() {
    }

    public RequestedProofTokenImpl(String proofTokenType) {
        this.setProofTokenType(proofTokenType);
    }

    public RequestedProofTokenImpl(RequestedProofTokenType rptType) {
        JAXBElement obj = (JAXBElement)rptType.getAny();
        String local = obj.getName().getLocalPart();
        if (local.equalsIgnoreCase("ComputedKey")) {
            try {
                this.setComputedKey(new URI((String)obj.getValue()));
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        } else if (local.equalsIgnoreCase("BinarySecret")) {
            BinarySecretType bsType = (BinarySecretType)obj.getValue();
            this.setBinarySecret(new BinarySecretImpl(bsType));
        } else {
            throw new UnsupportedOperationException("Unsupported requested proof token: " + local);
        }
    }

    public String getProofTokenType() {
        return this.tokenType;
    }

    public void setProofTokenType(String proofTokenType) {
        if (!(proofTokenType.equalsIgnoreCase("BinarySecret") || proofTokenType.equalsIgnoreCase("ComputedKey") || proofTokenType.equalsIgnoreCase("EncryptedKey") || proofTokenType.equalsIgnoreCase("Custom") || proofTokenType.equalsIgnoreCase("SecurityTokenReference"))) {
            throw new RuntimeException("Invalid tokenType");
        }
        this.tokenType = proofTokenType;
    }

    public void setSecurityTokenReference(SecurityTokenReference reference) {
        if (reference != null) {
            this.str = reference;
            JAXBElement<SecurityTokenReferenceType> strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)((Object)reference));
            this.setAny(strElement);
        }
        this.setProofTokenType("SecurityTokenReference");
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.str;
    }

    public void setComputedKey(URI computedKey) {
        if (computedKey != null) {
            String ckString = computedKey.toString();
            if (!ckString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_13.getCKHASHalgorithmURI()) && !ckString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_13.getCKPSHA1algorithmURI())) {
                throw new RuntimeException("Invalid computedKeyURI");
            }
            this.computedKey = computedKey;
            JAXBElement<String> ckElement = new ObjectFactory().createComputedKey(computedKey.toString());
            this.setAny(ckElement);
        }
        this.setProofTokenType("ComputedKey");
    }

    public URI getComputedKey() {
        return this.computedKey;
    }

    public void setBinarySecret(BinarySecret secret) {
        if (secret != null) {
            this.secret = secret;
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)((Object)secret));
            this.setAny(bsElement);
        }
        this.setProofTokenType("BinarySecret");
    }

    public BinarySecret getBinarySecret() {
        return this.secret;
    }

    public static RequestedProofTokenType fromElement(Element element) throws WSTrustException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.sun.xml.ws.security.trust.impl.wssx.elements");
            Unmarshaller u = jc.createUnmarshaller();
            return (RequestedProofTokenType)u.unmarshal((Node)element);
        }
        catch (Exception ex) {
            throw new WSTrustException(ex.getMessage(), ex);
        }
    }
}

