/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;

public class TransformXSLT
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    static final String XSLTSpecNS = "http://www.w3.org/1999/XSL/Transform";
    static final String defaultXSLTSpecNSprefix = "xslt";
    static final String XSLTSTYLESHEET = "stylesheet";
    private static Class xClass = null;
    static Logger log;

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, Transform transform) throws IOException, TransformationException {
        return this.enginePerformTransform(xMLSignatureInput, null, transform);
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, Transform transform) throws IOException, TransformationException {
        if (xClass == null) {
            Object[] objectArray = new Object[]{"SECURE_PROCESSING_FEATURE not supported"};
            throw new TransformationException("generic.EmptyMessage", objectArray);
        }
        try {
            Element element = transform.getElement();
            Element element2 = XMLUtils.selectNode(element.getFirstChild(), XSLTSpecNS, XSLTSTYLESHEET, 0);
            if (element2 == null) {
                Object[] objectArray = new Object[]{"xslt:stylesheet", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Class<?> clazz = transformerFactory.getClass();
            Method method = clazz.getMethod("setFeature", String.class, Boolean.TYPE);
            method.invoke((Object)transformerFactory, "http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(xMLSignatureInput.getBytes()));
            Object object = new ByteArrayOutputStream();
            Object object2 = transformerFactory.newTransformer();
            Object object3 = new DOMSource(element2);
            StreamResult streamResult = new StreamResult((OutputStream)object);
            ((Transformer)object2).transform((Source)object3, streamResult);
            StreamSource streamSource2 = new StreamSource(new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray()));
            object = transformerFactory.newTransformer(streamSource2);
            try {
                ((Transformer)object).setOutputProperty("{http://xml.apache.org/xalan}line-separator", "\n");
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Unable to set Xalan line-separator property: " + exception.getMessage());
            }
            if (outputStream == null) {
                object2 = new ByteArrayOutputStream();
                object3 = new StreamResult((OutputStream)object2);
                ((Transformer)object).transform(streamSource, (Result)object3);
                return new XMLSignatureInput(((ByteArrayOutputStream)object2).toByteArray());
            }
            object2 = new StreamResult(outputStream);
            ((Transformer)object).transform(streamSource, (Result)object2);
            object3 = new XMLSignatureInput((byte[])null);
            ((XMLSignatureInput)object3).setOutputStream(outputStream);
            return object3;
        }
        catch (XMLSecurityException xMLSecurityException) {
            Object[] objectArray = new Object[]{xMLSecurityException.getMessage()};
            throw new TransformationException("generic.EmptyMessage", objectArray, xMLSecurityException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Object[] objectArray = new Object[]{transformerConfigurationException.getMessage()};
            throw new TransformationException("generic.EmptyMessage", objectArray, transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            Object[] objectArray = new Object[]{transformerException.getMessage()};
            throw new TransformationException("generic.EmptyMessage", objectArray, transformerException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object[] objectArray = new Object[]{noSuchMethodException.getMessage()};
            throw new TransformationException("generic.EmptyMessage", objectArray, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{illegalAccessException.getMessage()};
            throw new TransformationException("generic.EmptyMessage", objectArray, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Object[] objectArray = new Object[]{invocationTargetException.getMessage()};
            throw new TransformationException("generic.EmptyMessage", objectArray, invocationTargetException);
        }
    }

    static {
        try {
            xClass = Class.forName("javax.xml.XMLConstants");
        }
        catch (Exception exception) {
            // empty catch block
        }
        log = Logger.getLogger(TransformXSLT.class.getName());
    }
}

