/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class WsdlSaas
extends Saas
implements PropertyChangeListener {
    private WsdlData wsData;
    private List<WsdlSaasPort> ports;

    public WsdlSaas(SaasGroup parentGroup, SaasServices services) {
        super(parentGroup, services);
    }

    public WsdlSaas(SaasGroup parentGroup, String url, String displayName, String packageName) {
        super(parentGroup, url, displayName, packageName);
        this.getDelegate().setType("http://schemas.xmlsoap.org/wsdl/");
    }

    protected void setWsdlData(WsdlData data) {
        this.wsData = data;
        if (this.wsData.isReady()) {
            this.setState(Saas.State.READY);
        } else {
            this.setState(Saas.State.UNINITIALIZED);
        }
    }

    public WsdlData getWsdlData() {
        Saas.State state = this.getState();
        if (state == Saas.State.RETRIEVED || state == Saas.State.READY) {
            return this.wsData;
        }
        throw new IllegalStateException("Current state: " + (Object)((Object)state));
    }

    @Override
    protected void refresh() {
        if (this.getState() == Saas.State.INITIALIZING) {
            throw new IllegalStateException(NbBundle.getMessage(WsdlSaas.class, (String)"MSG_CantRefreshWhileInitializing"));
        }
        super.refresh();
        this.ports = null;
        if (this.wsData == null) {
            this.wsData = WsdlUtil.findWsdlData(this.getUrl(), null);
            if (this.wsData == null) {
                this.toStateReady(false);
                return;
            }
            this.wsData = null;
            this.toStateReady(true);
        }
        WsdlUtil.refreshWsdlData(this.wsData);
    }

    public String getDefaultServiceName() {
        if (this.getMethods().size() > 0) {
            return this.getMethods().get(0).getMethod().getServiceName();
        }
        return "";
    }

    @Override
    public String getPackageName() {
        String pname = this.getDelegate().getSaasMetadata().getCodeGen().getPackageName();
        if (pname == null) {
            pname = "";
        }
        return pname;
    }

    @Override
    public void toStateReady(boolean synchronous) {
        if (this.getState() == Saas.State.REMOVED) {
            return;
        }
        if (this.wsData == null) {
            String serviceName = this.getDefaultServiceName();
            this.wsData = WsdlUtil.getWsdlData(this.getUrl(), serviceName, synchronous);
            if (this.wsData == null) {
                this.wsData = WsdlUtil.addWsdlData(this.getUrl(), this.getPackageName());
                if (this.wsData != null && synchronous) {
                    int count = 0;
                    while (!this.wsData.isReady() && count < 100) {
                        try {
                            Thread.sleep(100L);
                            ++count;
                        }
                        catch (InterruptedException ex) {}
                    }
                }
            }
            if (this.wsData != null) {
                this.wsData.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.wsData));
                if (this.wsData.isReady()) {
                    this.setState(Saas.State.READY);
                } else {
                    this.setState(Saas.State.INITIALIZING);
                }
            } else {
                this.setState(Saas.State.UNINITIALIZED);
            }
        }
    }

    private List<WSPort> filterNonSoapPorts(List<? extends WSPort> ports) {
        ArrayList<WSPort> filterPorts = new ArrayList<WSPort>(ports.size());
        for (WSPort wSPort : ports) {
            if (wSPort.getAddress() == null) continue;
            filterPorts.add(wSPort);
        }
        return filterPorts;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if (property.equals("resolved") && this.getState() == Saas.State.INITIALIZING) {
            if (Boolean.FALSE.equals(newValue)) {
                this.setState(Saas.State.RETRIEVED);
            } else if (this.wsData.isReady()) {
                this.setState(Saas.State.READY);
            }
        } else if (WsdlData.Status.WSDL_SERVICE_COMPILED.equals(newValue)) {
            this.setState(Saas.State.READY);
        } else if (WsdlData.Status.WSDL_SERVICE_COMPILE_FAILED.equals(newValue)) {
            this.setState(Saas.State.RETRIEVED);
        } else if (WsdlData.Status.WSDL_UNRETRIEVED.equals(newValue)) {
            this.setState(Saas.State.UNINITIALIZED);
        }
    }

    public WSService getWsdlModel() {
        return this.getWsdlData().getWsdlService();
    }

    public FileObject getLocalWsdlFile() {
        return FileUtil.toFileObject((File)new File(this.getWsdlData().getWsdlFile()));
    }

    public List<WsdlSaasPort> getPorts() {
        if (this.ports == null) {
            this.ports = new ArrayList<WsdlSaasPort>();
            for (WSPort p : this.filterNonSoapPorts(this.getWsdlModel().getPorts())) {
                this.ports.add(new WsdlSaasPort(this, p));
            }
        }
        return new ArrayList<WsdlSaasPort>(this.ports);
    }

    @Override
    protected WsdlSaasMethod createSaasMethod(Method method) {
        return new WsdlSaasMethod(this, method);
    }

    @Override
    public FileObject getSaasFolder() {
        if (this.saasFolder == null) {
            String folderName = WsdlUtil.getServiceDirName(this.getUrl());
            FileObject websvcHome = SaasServicesModel.getWebServiceHome();
            this.saasFolder = websvcHome.getFileObject(folderName);
            if (this.saasFolder == null) {
                try {
                    this.saasFolder = websvcHome.createFolder(folderName);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return this.saasFolder;
    }
}

