/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.diff.ExportAsFilePanel;
import org.netbeans.modules.mercurial.ui.diff.ExportBundleAction;
import org.netbeans.modules.mercurial.ui.diff.ExportBundlePanel;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPickerPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.versioning.util.ExportDiffSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ExportBundle
extends ExportDiffSupport
implements ActionListener {
    private ExportBundlePanel panel;
    private JButton okButton;
    private JButton cancelButton;
    private final File repository;
    private ExportAsFilePanel targetPanel;
    private DialogDescriptor dialogDescriptor;
    private final String HG_TIP = "tip";
    private final String HG_NULL_BASE = "null";
    private final ChangesetPickerSimplePanel changesetPickerPanel;
    private static final HashMap<String, String> resourceNames = new HashMap();
    private static final String SEP = " ";

    public ExportBundle(File repository) {
        super(new File[]{repository}, HgModuleConfig.getDefault().getPreferences());
        this.repository = repository;
        this.panel = new ExportBundlePanel(repository);
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundleDialog_Action_Export"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportBundle.class, (String)"ACSD_ExportBundleDialog_Action_Export"));
        this.okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportBundle.class, (String)"ACSN_ExportBundleDialog_Action_Export"));
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundleDialog_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportBundle.class, (String)"ACSD_ExportBundleDialog_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportBundle.class, (String)"ACSN_ExportBundleDialog_Action_Cancel"));
        this.panel.baseRevision.setModel(new DefaultComboBoxModel<String>(new String[]{"tip", "null"}));
        this.panel.baseRevision.setSelectedIndex(0);
        this.panel.txtTopRevision.setText("tip");
        this.panel.addActionListener(this);
        this.changesetPickerPanel = new ChangesetPickerSimplePanel(repository);
    }

    protected ExportDiffSupport.AbstractExportDiffPanel createSimpleDialog(String currentFilePath) {
        this.dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundleDialog_Title"), true, new Object[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, new HelpCtx(this.getClass()), null);
        this.targetPanel = new ExportAsFilePanel();
        this.targetPanel.addOutputFileTextDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportBundle.this.nameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportBundle.this.nameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportBundle.this.nameChange();
            }
        });
        this.panel.setInsidePanel(this.targetPanel);
        return this.targetPanel;
    }

    protected void createComplexDialog(ExportDiffSupport.AbstractExportDiffPanel insidePanel) {
        this.panel.setInsidePanel(insidePanel);
        this.dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundleDialog_Title"));
    }

    protected File createTempFile() throws IOException {
        return File.createTempFile("hg-bundle", ".hg");
    }

    protected String getMessage(String resourceName) {
        String translatedResourceName = resourceNames.get(resourceName);
        if (translatedResourceName == null) {
            return super.getMessage(resourceName);
        }
        return NbBundle.getMessage(ExportBundle.class, (String)translatedResourceName);
    }

    protected FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("hg") || f.getName().endsWith("bundle") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundle_FileMask");
            }
        };
    }

    protected File getTargetFile(File target) {
        String name = target.getName();
        boolean requiredExt = false;
        requiredExt |= name.endsWith(".hg");
        if (!(requiredExt |= name.endsWith(".bundle"))) {
            File parent = target.getParentFile();
            target = new File(parent, name + ".hg");
        }
        return target;
    }

    private void nameChange() {
        if (!this.targetPanel.getOutputFileText().trim().isEmpty()) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private String getBaseRevision() {
        String rev = this.panel.getSelectedBaseRevision();
        if (rev == null) {
            rev = "null";
        }
        return ExportBundle.parseRevision(rev);
    }

    private String getTopRevision() {
        String rev = this.panel.getSelectedRevision();
        if (rev == null) {
            rev = "tip";
        }
        return ExportBundle.parseRevision(rev);
    }

    private static String parseRevision(String revision) {
        int pos = revision.indexOf(SEP);
        if (pos > 0) {
            revision = revision.substring(0, pos);
        }
        return revision;
    }

    public void writeDiffFile(final File toFile) {
        HgProgressSupport supp = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                String revBase = ExportBundle.this.getBaseRevision();
                String revTo = ExportBundle.this.getTopRevision();
                OutputLogger logger = this.getLogger();
                if (toFile.getParent() != null) {
                    HgModuleConfig.getDefault().getPreferences().put("ExportDiff.saveFolder", toFile.getParent());
                }
                try {
                    logger.outputInRed(NbBundle.getMessage(ExportBundleAction.class, (String)"MSG_EXPORT_BUNDLE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(ExportBundleAction.class, (String)"MSG_EXPORT_BUNDLE_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(ExportBundleAction.class, (String)"MSG_EXPORT_BUNDLE_PROGRESS", (Object[])new String[]{revTo, revBase, toFile.getAbsolutePath()}));
                    List<String> list = HgCommand.doBundle(ExportBundle.this.repository, revBase, revTo, toFile, logger);
                    logger.output(list);
                }
                catch (HgException ex) {
                    NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
                }
                finally {
                    logger.outputInRed(NbBundle.getMessage(ExportBundleAction.class, (String)"MSG_EXPORT_BUNDLE_DONE"));
                    logger.output("");
                }
            }
        };
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(this.repository);
        supp.start(rp, this.repository, NbBundle.getMessage(ExportBundleAction.class, (String)"LBL_ExportBundle_Progress")).waitFinished();
    }

    protected DialogDescriptor getDialogDescriptor() {
        return this.dialogDescriptor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        JButton selectButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)selectButton, (String)NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundle.ChangesetPicker_SelectButton"));
        DialogDescriptor dd = new DialogDescriptor((Object)this.changesetPickerPanel, NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundle.ChangesetPicker_Title"), true, new Object[]{selectButton, DialogDescriptor.CANCEL_OPTION}, (Object)selectButton, 0, new HelpCtx(this.getClass()), null);
        this.changesetPickerPanel.initRevisions();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        if (dd.getValue() == selectButton) {
            String revision;
            String[] revisionWithChangeset = this.changesetPickerPanel.getSelectedRevision();
            String string = revision = revisionWithChangeset[1].isEmpty() ? revisionWithChangeset[0] : revisionWithChangeset[0] + SEP + "(" + revisionWithChangeset[1] + ")";
            if ("command.selectBaseRevision".equals(command)) {
                this.panel.baseRevision.setModel(new DefaultComboBoxModel<String>(new String[]{"null", revision}));
                this.panel.baseRevision.setSelectedItem(revision);
            } else if ("command.selectRevision".equals(command)) {
                this.panel.txtTopRevision.setText(revision);
            }
        }
    }

    static {
        resourceNames.put("CTL_Attaching", "CTL_Attaching");
        resourceNames.put("CTL_Export_Title", "CTL_ExportBundleDialog_Title");
    }

    private static class ChangesetPickerSimplePanel
    extends ChangesetPickerPanel {
        private boolean initialized;

        public ChangesetPickerSimplePanel(File repository) {
            super(repository, new File[]{repository});
            this.initComponents();
        }

        @Override
        protected String getRefreshLabel() {
            return NbBundle.getMessage(ExportBundle.class, (String)"MSG_Fetching_Revisions");
        }

        private void initRevisions() {
            if (!this.initialized) {
                this.initialized = true;
                this.loadRevisions();
            }
        }

        private void initComponents() {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ExportBundle.class, (String)"ExportBundle.ChangesetPicker.jLabel1.text"));
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ExportBundle.class, (String)"LBL_EXPORT_INFO"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportBundle.class, (String)"ExportBundle.ChangesetPicker.AccessibleContext.accessibleDescription"));
        }
    }
}

