/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

class DiffNode
extends AbstractNode {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PROPERTY = "property";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_LOCATION = "location";
    private final Setup setup;
    private String htmlDisplayName;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    public DiffNode(Setup setup, HgFileNode node) {
        super(Children.LEAF, DiffNode.getLookupFor(setup, node.getLookupObjects()));
        this.setup = setup;
        this.setName(setup.getBaseFile().getName());
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    private void refreshHtmlDisplayName() {
        FileInformation info = this.setup.getInfo();
        int status = info.getStatus();
        if (status == 128) {
            status = 64;
        }
        this.htmlDisplayName = Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(this.setup.getBaseFile().getName(), info, null);
        this.fireDisplayNameChange(this.htmlDisplayName, this.htmlDisplayName);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return null;
        }
        return new Action[0];
    }

    public Node.Cookie getCookie(Class klass) {
        FileObject fo = FileUtil.toFileObject((File)this.getSetup().getBaseFile());
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (fo.equals(dobj.getPrimaryFile())) {
                    return dobj.getCookie(klass);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return super.getCookie(klass);
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new NameProperty());
        ps.put((Node.Property)new LocationProperty());
        ps.put((Node.Property)new StatusProperty());
        if (this.setup.getPropertyName() != null) {
            ps.put((Node.Property)new PropertyNameProperty());
        }
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private static Lookup getLookupFor(Setup setup, Object[] lookupObjects) {
        Object[] allLookupObjects = new Object[lookupObjects.length + 1];
        allLookupObjects[0] = setup;
        System.arraycopy(lookupObjects, 0, allLookupObjects, 1, lookupObjects.length);
        return Lookups.fixed((Object[])allLookupObjects);
    }

    private class StatusProperty
    extends DiffNodeProperty {
        public StatusProperty() {
            super(DiffNode.COLUMN_NAME_STATUS, String.class, DiffNode.COLUMN_NAME_STATUS, DiffNode.COLUMN_NAME_STATUS);
            String shortPath = HgUtils.getRelativePath(DiffNode.this.setup.getBaseFile());
            String sortable = Integer.toString(HgUtils.getComparableStatus(DiffNode.this.setup.getInfo().getStatus()));
            this.setValue("sortkey", zeros[sortable.length()] + sortable + "\t" + shortPath + "\t" + DiffNode.this.getName().toUpperCase());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.setup.getInfo().getStatusText();
        }
    }

    private class LocationProperty
    extends DiffNodeProperty {
        private String location;

        public LocationProperty() {
            super(DiffNode.COLUMN_NAME_LOCATION, String.class, DiffNode.COLUMN_NAME_LOCATION, DiffNode.COLUMN_NAME_LOCATION);
            this.location = HgUtils.getRelativePath(DiffNode.this.setup.getBaseFile());
            this.setValue("sortkey", this.location + "\t" + DiffNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.location;
        }
    }

    private class PropertyNameProperty
    extends DiffNodeProperty {
        public PropertyNameProperty() {
            super(DiffNode.COLUMN_NAME_PROPERTY, String.class, DiffNode.COLUMN_NAME_PROPERTY, DiffNode.COLUMN_NAME_PROPERTY);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.setup.getPropertyName();
        }
    }

    private class NameProperty
    extends DiffNodeProperty {
        public NameProperty() {
            super(DiffNode.COLUMN_NAME_NAME, String.class, DiffNode.COLUMN_NAME_NAME, DiffNode.COLUMN_NAME_NAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.getName();
        }
    }

    private abstract class DiffNodeProperty
    extends PropertySupport.ReadOnly {
        protected DiffNodeProperty(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }
    }
}

