/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class J2EEProjectProperties {
    public static final String J2EE_PLATFORM_CLASSPATH = "j2ee.platform.classpath";
    public static final String J2EE_SERVER_HOME = "j2ee.server.home";
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String J2EE_PLATFORM_EMBEDDABLE_EJB_CLASSPATH = "j2ee.platform.embeddableejb.classpath";
    public static final String ANT_DEPLOY_BUILD_SCRIPT = "nbproject/ant-deploy.xml";
    public static final String DEPLOY_ANT_PROPS_FILE = "deploy.ant.properties.file";
    public static final String J2EE_PLATFORM_WSCOMPILE_CLASSPATH = "j2ee.platform.wscompile.classpath";
    public static final String J2EE_PLATFORM_JWSDP_CLASSPATH = "j2ee.platform.jwsdp.classpath";
    public static final String J2EE_PLATFORM_WSIT_CLASSPATH = "j2ee.platform.wsit.classpath";
    public static final String J2EE_PLATFORM_WSGEN_CLASSPATH = "j2ee.platform.wsgen.classpath";
    public static final String J2EE_PLATFORM_WSIMPORT_CLASSPATH = "j2ee.platform.wsimport.classpath";
    public static final String J2EE_PLATFORM_JSR109_SUPPORT = "j2ee.platform.is.jsr109";

    public static void removeObsoleteLibraryLocations(EditableProperties editableProperties) {
        Iterator iterator = editableProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.endsWith(".libdirs") && !string.endsWith(".libfiles") && string.indexOf(".libdir.") <= 0 && string.indexOf(".libfile.") <= 0) continue;
            iterator.remove();
        }
    }

    public static boolean isUsingServerLibrary(EditableProperties editableProperties, String string) {
        String string2 = editableProperties.getProperty(string);
        return string2 != null && !"".equals(string2.trim()) && string2.indexOf(J2EE_SERVER_HOME) == -1;
    }

    public static boolean isUsingServerLibrary(EditableProperties editableProperties, String string, Iterable<ClassPathSupport.Item> iterable) {
        return J2EEProjectProperties.isUsingServerLibrary(editableProperties, string) || iterable != null && !J2EEProjectProperties.getServerLibraries(iterable).isEmpty();
    }

    public static void setServerProperties(EditableProperties editableProperties, EditableProperties editableProperties2, String string, ClassPathSupport classPathSupport, Iterable<ClassPathSupport.Item> iterable, String string2, Profile profile, J2eeModule.Type type) {
        Deployment deployment = Deployment.getDefault();
        String string3 = deployment.getServerID(string2);
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string2);
        if (!j2eePlatform.getSupportedProfiles(type).contains(profile)) {
            Logger.getLogger("global").log(Level.WARNING, "J2EE level:" + profile.getDisplayName() + " not supported by server " + Deployment.getDefault().getServerInstanceDisplayName(string2) + " for module type WAR");
        }
        editableProperties.setProperty(J2EE_SERVER_TYPE, string3);
        editableProperties2.setProperty(J2EE_SERVER_INSTANCE, string2);
        if (string != null || J2EEProjectProperties.isUsingServerLibrary(editableProperties, J2EE_PLATFORM_CLASSPATH, iterable)) {
            if (classPathSupport != null) {
                J2EEProjectProperties.setSharableServerPropertiesFromModel(editableProperties, editableProperties2, classPathSupport, iterable);
            } else if (string != null) {
                J2EEProjectProperties.setSharableServerProperties(editableProperties, editableProperties2, string);
            }
        } else {
            String string4 = J2EEProjectProperties.extractPlatformLibrariesRoot(j2eePlatform);
            if (string4 != null) {
                J2EEProjectProperties.setLocalServerProperties(editableProperties2, editableProperties, j2eePlatform, string4);
            } else {
                J2EEProjectProperties.setLocalServerProperties(editableProperties, editableProperties2, j2eePlatform, null);
            }
        }
        if (j2eePlatform.isToolSupported("jsr109")) {
            editableProperties2.setProperty(J2EE_PLATFORM_JSR109_SUPPORT, "true");
        }
    }

    public static void createDeploymentScript(FileObject fileObject, EditableProperties editableProperties, EditableProperties editableProperties2, String string, J2eeModule.Type type) {
        File file = FileUtil.toFile((FileObject)fileObject);
        try {
            AntDeploymentHelper.writeDeploymentScript((File)new File(file, ANT_DEPLOY_BUILD_SCRIPT), (Object)type, (String)string);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        File file2 = AntDeploymentHelper.getDeploymentPropertiesFile((String)string);
        if (file2 != null) {
            editableProperties2.setProperty(DEPLOY_ANT_PROPS_FILE, file2.getAbsolutePath());
        }
    }

    public static void updateServerProperties(EditableProperties editableProperties, EditableProperties editableProperties2, String string, ClassPathSupport classPathSupport, Iterable<ClassPathSupport.Item> iterable, Callback callback, Project project, Profile profile, J2eeModule.Type type) {
        J2eePlatform j2eePlatform;
        assert (string != null) : "Server isntance id to set can't be null";
        String string2 = editableProperties2.getProperty(J2EE_SERVER_INSTANCE);
        if (string2 != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(string2)) != null) {
            callback.unregisterJ2eePlatformListener(j2eePlatform);
        }
        if ((j2eePlatform = Deployment.getDefault().getJ2eePlatform(string)) == null) {
            Logger.getLogger("global").log(Level.INFO, "J2EE platform is null.");
            editableProperties2.setProperty(J2EE_SERVER_INSTANCE, string);
            J2EEProjectProperties.removeServerClasspathProperties(editableProperties2);
            editableProperties2.remove((Object)J2EE_PLATFORM_JSR109_SUPPORT);
            editableProperties2.remove((Object)DEPLOY_ANT_PROPS_FILE);
            return;
        }
        callback.registerJ2eePlatformListener(j2eePlatform);
        J2EEProjectProperties.setServerProperties(editableProperties, editableProperties2, null, classPathSupport, iterable, string, profile, type);
        J2EEProjectProperties.createDeploymentScript(project.getProjectDirectory(), editableProperties, editableProperties2, string, type);
    }

    public static void setSharableServerProperties(EditableProperties editableProperties, EditableProperties editableProperties2, String string) {
        Parameters.notNull((CharSequence)"serverLibraryName", (Object)string);
        editableProperties.setProperty(J2EE_PLATFORM_CLASSPATH, "${libs." + string + "." + "classpath" + "}");
        editableProperties.setProperty(J2EE_PLATFORM_EMBEDDABLE_EJB_CLASSPATH, "${libs." + string + "." + "embeddableejb" + "}");
        editableProperties.setProperty(J2EE_PLATFORM_WSCOMPILE_CLASSPATH, "${libs." + string + "." + "wscompile" + "}");
        editableProperties.setProperty(J2EE_PLATFORM_WSIMPORT_CLASSPATH, "${libs." + string + "." + "wsimport" + "}");
        editableProperties.setProperty(J2EE_PLATFORM_WSGEN_CLASSPATH, "${libs." + string + "." + "wsgenerate" + "}");
        editableProperties.setProperty(J2EE_PLATFORM_WSIT_CLASSPATH, "${libs." + string + "." + "wsinterop" + "}");
        editableProperties.setProperty(J2EE_PLATFORM_JWSDP_CLASSPATH, "${libs." + string + "." + "wsjwsdp" + "}");
        J2EEProjectProperties.removeServerClasspathProperties(editableProperties2);
    }

    private static List<ClassPathSupport.Item> getServerLibraries(Iterable<ClassPathSupport.Item> iterable) {
        ArrayList<ClassPathSupport.Item> arrayList = new ArrayList<ClassPathSupport.Item>();
        for (ClassPathSupport.Item item : iterable) {
            if (item.getType() != 1 || item.isBroken() || !item.getLibrary().getType().equals("serverlibrary")) continue;
            arrayList.add(ClassPathSupport.Item.create((Library)item.getLibrary(), null));
        }
        return arrayList;
    }

    private static void setSharableServerPropertiesFromModel(EditableProperties editableProperties, EditableProperties editableProperties2, ClassPathSupport classPathSupport, Iterable<ClassPathSupport.Item> iterable) {
        Parameters.notNull((CharSequence)"cs", (Object)classPathSupport);
        Parameters.notNull((CharSequence)"items", iterable);
        List<ClassPathSupport.Item> list = J2EEProjectProperties.getServerLibraries(iterable);
        if (list.isEmpty()) {
            return;
        }
        editableProperties.setProperty(J2EE_PLATFORM_CLASSPATH, classPathSupport.encodeToStrings(list, null, "classpath"));
        J2EEProjectProperties.removeReferences(list);
        editableProperties.setProperty(J2EE_PLATFORM_WSCOMPILE_CLASSPATH, classPathSupport.encodeToStrings(list, null, "wscompile"));
        J2EEProjectProperties.removeReferences(list);
        editableProperties.setProperty(J2EE_PLATFORM_WSGEN_CLASSPATH, classPathSupport.encodeToStrings(list, null, "wsgenerate"));
        J2EEProjectProperties.removeReferences(list);
        editableProperties.setProperty(J2EE_PLATFORM_WSIMPORT_CLASSPATH, classPathSupport.encodeToStrings(list, null, "wsimport"));
        J2EEProjectProperties.removeReferences(list);
        editableProperties.setProperty(J2EE_PLATFORM_WSIT_CLASSPATH, classPathSupport.encodeToStrings(list, null, "wsinterop"));
        J2EEProjectProperties.removeReferences(list);
        editableProperties.setProperty(J2EE_PLATFORM_JWSDP_CLASSPATH, classPathSupport.encodeToStrings(list, null, "wsjwsdp"));
        J2EEProjectProperties.removeServerClasspathProperties(editableProperties2);
    }

    private static void removeReferences(Iterable<ClassPathSupport.Item> iterable) {
        for (ClassPathSupport.Item item : iterable) {
            item.setReference(null);
        }
    }

    private static void removeServerClasspathProperties(EditableProperties editableProperties) {
        editableProperties.remove((Object)J2EE_PLATFORM_CLASSPATH);
        editableProperties.remove((Object)J2EE_PLATFORM_EMBEDDABLE_EJB_CLASSPATH);
        editableProperties.remove((Object)J2EE_PLATFORM_WSCOMPILE_CLASSPATH);
        editableProperties.remove((Object)J2EE_PLATFORM_WSIMPORT_CLASSPATH);
        editableProperties.remove((Object)J2EE_PLATFORM_WSGEN_CLASSPATH);
        editableProperties.remove((Object)J2EE_PLATFORM_WSIT_CLASSPATH);
        editableProperties.remove((Object)J2EE_PLATFORM_JWSDP_CLASSPATH);
        editableProperties.remove((Object)J2EE_SERVER_HOME);
    }

    private static void setLocalServerProperties(EditableProperties editableProperties, EditableProperties editableProperties2, J2eePlatform j2eePlatform, String string) {
        File[] fileArray;
        WSStack wSStack;
        J2EEProjectProperties.removeServerClasspathProperties(editableProperties2);
        String string2 = J2EEProjectProperties.toClasspathString(j2eePlatform.getClasspathEntries(), string);
        editableProperties2.setProperty(J2EE_PLATFORM_CLASSPATH, string2);
        if (j2eePlatform.isToolSupported("embeddableejb")) {
            wSStack = j2eePlatform.getToolClasspathEntries("embeddableejb");
            editableProperties2.setProperty(J2EE_PLATFORM_EMBEDDABLE_EJB_CLASSPATH, J2EEProjectProperties.toClasspathString((File[])wSStack, string));
        }
        if (j2eePlatform.isToolSupported("wscompile")) {
            wSStack = j2eePlatform.getToolClasspathEntries("wscompile");
            editableProperties2.setProperty(J2EE_PLATFORM_WSCOMPILE_CLASSPATH, J2EEProjectProperties.toClasspathString((File[])wSStack, string));
        }
        if ((wSStack = WSStack.findWSStack((Lookup)j2eePlatform.getLookup(), JaxWs.class)) != null && (fileArray = wSStack.getWSTool((WSStack.Tool)JaxWs.Tool.WSIMPORT)) != null && fileArray.getLibraries().length > 0) {
            String string3 = J2EEProjectProperties.toClasspathString(fileArray.getLibraries(), string);
            editableProperties2.setProperty(J2EE_PLATFORM_WSGEN_CLASSPATH, string3);
            editableProperties2.setProperty(J2EE_PLATFORM_WSIMPORT_CLASSPATH, string3);
        }
        if (j2eePlatform.isToolSupported("wsit")) {
            fileArray = j2eePlatform.getToolClasspathEntries("wsit");
            editableProperties2.setProperty(J2EE_PLATFORM_WSIT_CLASSPATH, J2EEProjectProperties.toClasspathString(fileArray, string));
        }
        if (j2eePlatform.isToolSupported("jwsdp")) {
            fileArray = j2eePlatform.getToolClasspathEntries("jwsdp");
            editableProperties2.setProperty(J2EE_PLATFORM_JWSDP_CLASSPATH, J2EEProjectProperties.toClasspathString(fileArray, string));
        }
        J2EEProjectProperties.removeServerClasspathProperties(editableProperties);
        if (string != null) {
            editableProperties.setProperty(J2EE_SERVER_HOME, string);
        }
    }

    public static String extractPlatformLibrariesRoot(J2eePlatform j2eePlatform) {
        if (j2eePlatform.getPlatformRoots() == null) {
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)j2eePlatform.getPlatformRoots()[0]);
        boolean bl = true;
        for (File file : j2eePlatform.getClasspathEntries()) {
            FileObject fileObject2 = FileUtil.toFileObject((File)file);
            if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) continue;
            bl = false;
            break;
        }
        if (!bl) {
            return null;
        }
        return j2eePlatform.getPlatformRoots()[0].getAbsolutePath();
    }

    public static String toClasspathString(File[] fileArray) {
        if (fileArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(fileArray[i].getAbsolutePath());
            if (i + 1 >= fileArray.length) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    public static String toClasspathString(File[] fileArray, String string) {
        if (fileArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getAbsolutePath();
            if (string != null && string2.startsWith(string)) {
                string2 = "${j2ee.server.home}" + string2.substring(string.length());
            }
            stringBuffer.append(string2);
            if (i + 1 >= fileArray.length) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    public static String toClasspathString(URL[] uRLArray) {
        if (uRLArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                stringBuffer.append(new File(uRLArray[i].toURI()).getAbsolutePath());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (i + 1 >= uRLArray.length) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    public static String toClasspathString(URL[] uRLArray, String string) {
        if (uRLArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                String string2 = new File(uRLArray[i].toURI()).getAbsolutePath();
                if (string != null && string2.startsWith(string)) {
                    string2 = "${j2ee.server.home}" + string2.substring(string.length());
                }
                stringBuffer.append(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (i + 1 >= uRLArray.length) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    public static interface Callback {
        public void registerJ2eePlatformListener(J2eePlatform var1);

        public void unregisterJ2eePlatformListener(J2eePlatform var1);
    }
}

