/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class Util {
    public static Set<String> allMimeTypes;
    private static final Logger LOG;

    public static Set<String> getAllMimeTypes() {
        return allMimeTypes != null ? allMimeTypes : EditorSettings.getDefault().getAllMimeTypes();
    }

    public static boolean canBeParsed(String mimeType) {
        if (mimeType == null || "content/unknown".equals(mimeType) || !Util.getAllMimeTypes().contains(mimeType)) {
            return false;
        }
        int slashIdx = mimeType.indexOf(47);
        assert (slashIdx != -1) : "Invalid mimetype: '" + mimeType + "'";
        String type = mimeType.substring(0, slashIdx);
        return !(type.equals("application") ? !mimeType.equals("application/x-httpd-eruby") && !mimeType.equals("application/xml-dtd") : !type.equals("text"));
    }

    public static StackTraceElement findCaller(StackTraceElement[] elements, Object ... classesToFilterOut) {
        block0: for (StackTraceElement e : elements) {
            if (e.getClassName().equals(Util.class.getName()) || e.getClassName().startsWith("java.lang.")) continue;
            if (classesToFilterOut != null && classesToFilterOut.length > 0) {
                for (Object c : classesToFilterOut) {
                    if (c instanceof Class && e.getClassName().startsWith(((Class)c).getName()) || c instanceof String && e.getClassName().startsWith((String)c)) continue block0;
                }
            } else if (e.getClassName().startsWith("org.netbeans.modules.parsing.")) continue;
            return e;
        }
        return null;
    }

    public static URL resolveUrl(URL root, String relativePath) throws MalformedURLException {
        try {
            if ("file".equals(root.getProtocol())) {
                return new File(new File(root.toURI()), relativePath).toURI().toURL();
            }
            return new URL(root, relativePath);
        }
        catch (URISyntaxException use) {
            MalformedURLException mue = new MalformedURLException("Can't resolve URL: root=" + root + ", relativePath=" + relativePath);
            mue.initCause(use);
            throw mue;
        }
    }

    public static boolean containsAny(Collection<? extends String> searchIn, Collection<? extends String> searchFor) {
        if (searchIn != null && searchFor != null) {
            for (String string : searchFor) {
                if (!searchIn.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static FileObject getFileObject(Document doc) {
        Object sdp = doc.getProperty("stream");
        if (sdp instanceof FileObject) {
            return (FileObject)sdp;
        }
        if (sdp instanceof DataObject) {
            return ((DataObject)sdp).getPrimaryFile();
        }
        return null;
    }

    private Util() {
    }

    static {
        LOG = Logger.getLogger(Util.class.getName());
    }
}

