/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.web;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.projectimport.eclipse.core.spi.Facets;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectFactorySupport;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeFactory;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeUpdater;
import org.netbeans.modules.projectimport.eclipse.web.ServerSelectionWizardPanel;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebProjectFactory
implements ProjectTypeUpdater {
    private static final Logger LOG = Logger.getLogger(WebProjectFactory.class.getName());
    private static final String WEB_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private static final Icon WEB_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/project/ui/resources/webProjectIcon.gif", (boolean)false);
    private static final String MYECLIPSE_WEB_NATURE = "com.genuitec.eclipse.j2eedt.core.webnature";

    public boolean canHandle(ProjectTypeFactory.ProjectDescriptor projectDescriptor) {
        if (projectDescriptor.getFacets() != null) {
            return projectDescriptor.getFacets().hasInstalledFacet("jst.web");
        }
        if (projectDescriptor.getNatures().contains(WEB_NATURE)) {
            return true;
        }
        return projectDescriptor.getNatures().contains(MYECLIPSE_WEB_NATURE);
    }

    private ServerSelectionWizardPanel findWizardPanel(ProjectImportModel projectImportModel) {
        assert (projectImportModel.getExtraWizardPanels() != null);
        for (WizardDescriptor.Panel panel : projectImportModel.getExtraWizardPanels()) {
            if (!(panel instanceof ServerSelectionWizardPanel)) continue;
            return (ServerSelectionWizardPanel)panel;
        }
        return null;
    }

    public Project createProject(ProjectImportModel projectImportModel, List<String> list) throws IOException {
        String string;
        Facets.Facet facet;
        String string2;
        ServerSelectionWizardPanel serverSelectionWizardPanel;
        File file = projectImportModel.getNetBeansProjectLocation();
        if (ProjectFactorySupport.areSourceRootsOwned((ProjectImportModel)projectImportModel, (File)file, list)) {
            return null;
        }
        WebContentData webContentData = WebProjectFactory.parseWebContent(projectImportModel.getEclipseProjectFolder());
        if (webContentData == null || webContentData.webRoot == null) {
            list.add(NbBundle.getMessage(WebProjectFactory.class, (String)"MSG_MissingExtraWebFiles"));
            return null;
        }
        if (projectImportModel.getExtraWizardPanels() != null && this.findWizardPanel(projectImportModel) != null) {
            serverSelectionWizardPanel = this.findWizardPanel(projectImportModel);
            assert (serverSelectionWizardPanel != null);
            string2 = serverSelectionWizardPanel.getServerID();
        } else {
            if (Deployment.getDefault().getServerInstanceIDs().length == 0) {
                list.add(NbBundle.getMessage(WebProjectFactory.class, (String)"MSG_NoJ2EEServer"));
                return null;
            }
            string2 = Deployment.getDefault().getServerInstanceIDs()[0];
        }
        serverSelectionWizardPanel = new WebProjectCreateData();
        serverSelectionWizardPanel.setProjectDir(file);
        serverSelectionWizardPanel.setName(projectImportModel.getProjectName());
        serverSelectionWizardPanel.setServerInstanceID(string2);
        String string3 = null;
        if (projectImportModel.getFacets() != null && (facet = projectImportModel.getFacets().getFacet("jst.web")) != null) {
            string = facet.getVersion();
            if ("2.5".equals(string)) {
                string3 = "1.5";
            } else if ("2.4".equals(string)) {
                string3 = "1.4";
            } else if ("2.3".equals(string)) {
                string3 = "1.3";
            }
        }
        if (string3 == null && webContentData.j2eeSpecVersion != null) {
            string3 = webContentData.j2eeSpecVersion;
        }
        if (string3 == null) {
            string3 = "1.5";
        }
        serverSelectionWizardPanel.setJavaEEVersion(string3);
        serverSelectionWizardPanel.setSourceLevel(projectImportModel.getSourceLevel());
        if (projectImportModel.getJavaPlatform() != null) {
            serverSelectionWizardPanel.setJavaPlatformName(projectImportModel.getJavaPlatform().getDisplayName());
        }
        serverSelectionWizardPanel.setServerLibraryName(null);
        facet = FileUtil.toFileObject((File)projectImportModel.getEclipseProjectFolder());
        if (facet.getFileObject(webContentData.webRoot) == null) {
            list.add(NbBundle.getMessage(WebProjectFactory.class, (String)"MSG_MissingDocRoot", (Object)webContentData.webRoot));
            return null;
        }
        serverSelectionWizardPanel.setWebModuleFO((FileObject)facet);
        serverSelectionWizardPanel.setSourceFolders(projectImportModel.getEclipseSourceRootsAsFileArray());
        serverSelectionWizardPanel.setTestFolders(projectImportModel.getEclipseTestSourceRootsAsFileArray());
        serverSelectionWizardPanel.setContextPath(webContentData.contextRoot);
        serverSelectionWizardPanel.setDocBase(facet.getFileObject(webContentData.webRoot));
        serverSelectionWizardPanel.setLibFolder(facet.getFileObject(webContentData.webRoot + "/WEB-INF/lib"));
        serverSelectionWizardPanel.setWebInfFolder(facet.getFileObject(webContentData.webRoot + "/WEB-INF"));
        serverSelectionWizardPanel.setLibrariesDefinition(null);
        if (file.exists() && new File(file, "build.xml").exists()) {
            serverSelectionWizardPanel.setBuildfile("nb-build.xml");
        } else {
            serverSelectionWizardPanel.setBuildfile("build.xml");
        }
        string = WebProjectUtilities.importProject((WebProjectCreateData)serverSelectionWizardPanel);
        WebProject webProject = (WebProject)ProjectManager.getDefault().findProject(string.getProjectDirectory());
        EditableProperties editableProperties = string.getProperties("nbproject/project.properties");
        boolean bl = false;
        if (new File(file, "dist").exists()) {
            editableProperties.setProperty("dist.dir", "nbdist");
            bl = true;
        }
        if (new File(file, "build").exists()) {
            editableProperties.setProperty("build.dir", "nbbuild");
            bl = true;
        }
        if (bl) {
            string.putProperties("nbproject/project.properties", editableProperties);
        }
        ProjectFactorySupport.updateSourceRootLabels((List)projectImportModel.getEclipseSourceRoots(), (SourceRoots)webProject.getSourceRoots());
        ProjectFactorySupport.updateSourceRootLabels((List)projectImportModel.getEclipseTestSourceRoots(), (SourceRoots)webProject.getTestSourceRoots());
        ProjectFactorySupport.setupSourceExcludes((AntProjectHelper)string, (ProjectImportModel)projectImportModel, list);
        this.setupCompilerProperties((AntProjectHelper)string, projectImportModel);
        ProjectFactorySupport.updateProjectClassPath((AntProjectHelper)string, (ReferenceHelper)webProject.getReferenceHelper(), (ProjectImportModel)projectImportModel, list);
        ProjectManager.getDefault().saveProject((Project)webProject);
        return webProject;
    }

    private static WebContentData parseWebContent(File file) throws IOException {
        File file2 = new File(file, ".settings/org.eclipse.wst.common.component");
        if (!file2.exists()) {
            file2 = new File(file, ".settings/.component");
        }
        if (file2.exists()) {
            Document document;
            try {
                document = XMLUtil.parse((InputSource)new InputSource(file2.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
            }
            catch (SAXException sAXException) {
                IOException iOException = (IOException)new IOException(file2 + ": " + sAXException.toString()).initCause(sAXException);
                throw iOException;
            }
            Element element = document.getDocumentElement();
            if (!"project-modules".equals(element.getLocalName())) {
                return null;
            }
            WebContentData webContentData = new WebContentData();
            Element element2 = XMLUtil.findElement((Element)element, (String)"wb-module", null);
            if (element2 != null) {
                for (Element element3 : XMLUtil.findSubElements((Element)element2)) {
                    if ("wb-resource".equals(element3.getNodeName()) && "/".equals(element3.getAttribute("deploy-path"))) {
                        webContentData.webRoot = element3.getAttribute("source-path");
                    }
                    if (!"property".equals(element3.getNodeName()) || !"context-root".equals(element3.getAttribute("name"))) continue;
                    webContentData.contextRoot = element3.getAttribute("value");
                }
            }
            return webContentData;
        }
        file2 = new File(file, ".mymetadata");
        if (file2.exists()) {
            Element element;
            Document document;
            try {
                document = XMLUtil.parse((InputSource)new InputSource(file2.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
            }
            catch (SAXException sAXException) {
                IOException iOException = (IOException)new IOException(file2 + ": " + sAXException.toString()).initCause(sAXException);
                throw iOException;
            }
            Element element4 = document.getDocumentElement();
            if (!"project-module".equals(element4.getLocalName())) {
                return null;
            }
            WebContentData webContentData = new WebContentData();
            webContentData.contextRoot = element4.getAttribute("context-root");
            String string = element4.getAttribute("j2ee-spec");
            if ("5.0".equals(string)) {
                string = "1.5";
            }
            if ((element = XMLUtil.findElement((Element)element4, (String)"attributes", null)) != null) {
                for (Element element5 : XMLUtil.findSubElements((Element)element)) {
                    if (!"attribute".equals(element5.getNodeName()) || !"webrootdir".equals(element5.getAttribute("name"))) continue;
                    webContentData.webRoot = element5.getAttribute("value");
                    break;
                }
            }
            return webContentData;
        }
        return null;
    }

    public String calculateKey(ProjectImportModel projectImportModel) {
        WebContentData webContentData;
        try {
            webContentData = WebProjectFactory.parseWebContent(projectImportModel.getEclipseProjectFolder());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            webContentData = new WebContentData();
            webContentData.contextRoot = "??";
            webContentData.webRoot = "??";
        }
        return ProjectFactorySupport.calculateKey((ProjectImportModel)projectImportModel) + "web=" + webContentData.webRoot + ";" + "context=" + webContentData.contextRoot + ";";
    }

    public String update(Project project, ProjectImportModel projectImportModel, String string, List<String> list) throws IOException {
        if (!(project instanceof WebProject)) {
            throw new IOException("is not web project: " + project.getClass().getName());
        }
        String string2 = this.calculateKey(projectImportModel);
        String string3 = ProjectFactorySupport.synchronizeProjectClassPath((Project)project, (AntProjectHelper)((WebProject)project).getAntProjectHelper(), (ReferenceHelper)((WebProject)project).getReferenceHelper(), (ProjectImportModel)projectImportModel, (String)string, (String)string2, list);
        this.setupCompilerProperties(((WebProject)project).getAntProjectHelper(), projectImportModel);
        ProjectManager.getDefault().saveProject(project);
        return string3;
    }

    public Icon getProjectTypeIcon() {
        return WEB_PROJECT_ICON;
    }

    public String getProjectTypeName() {
        return NbBundle.getMessage(WebProjectFactory.class, (String)"LABEL_Web_Application");
    }

    public List<WizardDescriptor.Panel<WizardDescriptor>> getAdditionalImportWizardPanels() {
        return Collections.singletonList(new ServerSelectionWizardPanel());
    }

    private void setupCompilerProperties(AntProjectHelper antProjectHelper, ProjectImportModel projectImportModel) {
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("javac.source", projectImportModel.getSourceLevel());
        editableProperties.setProperty("javac.target", projectImportModel.getTargetLevel());
        editableProperties.setProperty("javac.deprecation", Boolean.toString(projectImportModel.isDeprecation()));
        editableProperties.setProperty("javac.compilerargs", projectImportModel.getCompilerArgs());
        editableProperties.setProperty("source.encoding", projectImportModel.getEncoding());
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        editableProperties = antProjectHelper.getProperties("nbproject/private/private.properties");
        editableProperties.setProperty("javac.debug", Boolean.toString(projectImportModel.isDebug()));
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties);
    }

    public File getProjectFileLocation(ProjectTypeFactory.ProjectDescriptor projectDescriptor, String string) {
        File file;
        WebContentData webContentData;
        if (!string.equals("webinf")) {
            return null;
        }
        try {
            webContentData = WebProjectFactory.parseWebContent(projectDescriptor.getEclipseProjectFolder());
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "cannot parse webmodule data", iOException);
            return null;
        }
        if (webContentData != null && (file = new File(projectDescriptor.getEclipseProjectFolder(), webContentData.webRoot + File.separatorChar + "WEB-INF" + File.separator)).exists()) {
            return file;
        }
        return null;
    }

    private static class WebContentData {
        private String contextRoot;
        private String webRoot;
        private String j2eeSpecVersion;

        private WebContentData() {
        }

        public String toString() {
            return "WebContentData[contextRoot=" + this.contextRoot + ", webRoot=" + this.webRoot + "]";
        }
    }
}

