/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxrs.glassfish.v3;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

public class GlassFishV3JaxRsStack
implements WSStackImplementation<JaxRs> {
    private static final String[] JAXRS_LIBRARIES = new String[]{"asm", "jersey-bundle", "jettison", "jsr311-api"};
    private static final String GFV3_MODULES_DIR_NAME = "modules";
    private String gfRootStr;
    private JaxRs jaxRs;

    public GlassFishV3JaxRsStack(String gfRootStr) {
        this.gfRootStr = gfRootStr;
        this.jaxRs = new JaxRs();
    }

    public JaxRs get() {
        return this.jaxRs;
    }

    public WSStackVersion getVersion() {
        return WSStackVersion.valueOf((int)2, (int)1, (int)4, (int)0);
    }

    public WSTool getWSTool(WSStack.Tool toolId) {
        if (toolId == JaxRs.Tool.JAXRS) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxRsTool(JaxRs.Tool.JAXRS));
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        WSTool wsTool;
        boolean isFeatureSupported = false;
        if (feature == JaxRs.Feature.JAXRS && (wsTool = this.getWSTool(JaxRs.Tool.JAXRS)) != null) {
            URL[] libs = wsTool.getLibraries();
            try {
                if (libs != null && libs.length == JAXRS_LIBRARIES.length) {
                    isFeatureSupported = true;
                }
                for (URL lib : libs) {
                    if (new File(lib.toURI()).exists()) continue;
                    isFeatureSupported = false;
                    break;
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        return isFeatureSupported;
    }

    private File getJarName(String glassfishInstallRoot, String jarNamePrefix) {
        File[] candidates;
        File modulesDir = new File(glassfishInstallRoot + File.separatorChar + GFV3_MODULES_DIR_NAME);
        int subindex = jarNamePrefix.lastIndexOf("/");
        if (subindex != -1) {
            String subdir = jarNamePrefix.substring(0, subindex);
            jarNamePrefix = jarNamePrefix.substring(subindex + 1);
            modulesDir = new File(modulesDir, subdir);
        }
        if ((candidates = modulesDir.listFiles(new VersionFilter(jarNamePrefix))) != null && candidates.length > 0) {
            return candidates[0];
        }
        return null;
    }

    private class JaxRsTool
    implements WSToolImplementation {
        JaxRs.Tool tool;

        JaxRsTool(JaxRs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            ArrayList<URL> cPath = new ArrayList<URL>();
            for (String entry : JAXRS_LIBRARIES) {
                File f = GlassFishV3JaxRsStack.this.getJarName(GlassFishV3JaxRsStack.this.gfRootStr, entry);
                if (f == null || !f.exists()) continue;
                try {
                    cPath.add(f.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            return cPath.toArray(new URL[cPath.size()]);
        }
    }

    private static class VersionFilter
    implements FileFilter {
        private String nameprefix;

        public VersionFilter(String nameprefix) {
            this.nameprefix = nameprefix;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith(this.nameprefix);
        }
    }
}

