/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.openide.util.NbBundle;

public class PListReader {
    protected StreamTokenizer tokenizer = null;

    public static Map read(String file) throws FileNotFoundException, ParseException, IOException {
        PListReader reader = new PListReader(file);
        return reader.getData();
    }

    public PListReader(String file) throws FileNotFoundException, ParseException, IOException {
        BufferedReader buffreader = new BufferedReader(new FileReader(file));
        this.tokenizer = this.createTokenizer(buffreader);
    }

    public PListReader(File file) throws FileNotFoundException, ParseException, IOException {
        BufferedReader buffreader = new BufferedReader(new FileReader(file));
        this.tokenizer = this.createTokenizer(buffreader);
    }

    public PListReader(InputStream stream) throws FileNotFoundException, ParseException, IOException {
        BufferedReader buffreader = new BufferedReader(new InputStreamReader(stream));
        this.tokenizer = this.createTokenizer(buffreader);
    }

    private StreamTokenizer createTokenizer(BufferedReader buffreader) {
        StreamTokenizer tok = new StreamTokenizer(buffreader);
        tok.slashStarComments(true);
        tok.slashSlashComments(true);
        tok.wordChars(95, 95);
        tok.wordChars(126, 126);
        tok.wordChars(33, 33);
        tok.wordChars(96, 96);
        tok.wordChars(39, 39);
        tok.wordChars(35, 35);
        tok.wordChars(36, 36);
        tok.wordChars(37, 37);
        tok.wordChars(94, 94);
        tok.wordChars(38, 38);
        tok.wordChars(42, 42);
        tok.wordChars(45, 45);
        tok.wordChars(43, 43);
        tok.wordChars(124, 124);
        tok.wordChars(63, 63);
        tok.wordChars(46, 46);
        tok.quoteChar(34);
        return tok;
    }

    private Object read(StreamTokenizer tokenizer) throws FileNotFoundException, ParseException, IOException {
        DictionaryNode node = new DictionaryNode(tokenizer);
        return node.getBindings();
    }

    public HashMap getData() throws FileNotFoundException, ParseException, IOException {
        return (HashMap)this.read(this.tokenizer);
    }

    public StreamTokenizer getTokenizer() {
        return this.tokenizer;
    }

    class ArrayNode
    extends Node {
        Vector bindings;

        public ArrayNode(StreamTokenizer tokenizer) throws ParseException, IOException {
            this.bindings = new Vector();
            this.parse(tokenizer);
        }

        public void parse(StreamTokenizer tokenizer) throws ParseException, IOException {
            Object object = null;
            try {
                this.parseChar(tokenizer, 40);
                block14: while (true) {
                    tokenizer.nextToken();
                    switch (tokenizer.ttype) {
                        case -3: {
                            object = tokenizer.sval;
                            break;
                        }
                        case 34: {
                            object = tokenizer.sval;
                            break;
                        }
                        case 41: {
                            throw new EOFException();
                        }
                        case 123: {
                            tokenizer.pushBack();
                            object = new DictionaryNode(tokenizer).getBindings();
                            break;
                        }
                        case 40: {
                            tokenizer.pushBack();
                            object = new ArrayNode(tokenizer).getBindings();
                            break;
                        }
                        case -2: {
                            object = this.parseNumber(tokenizer);
                            break;
                        }
                        default: {
                            throw new ParseException(MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_ExpectedObject"), tokenizer.toString()), tokenizer.lineno());
                        }
                    }
                    this.bindings.add(object);
                    tokenizer.nextToken();
                    switch (tokenizer.ttype) {
                        case 41: {
                            throw new EOFException();
                        }
                        case 44: {
                            continue block14;
                        }
                    }
                    break;
                }
                throw new ParseException(MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_Expected"), "','", tokenizer.toString()), tokenizer.lineno());
            }
            catch (EOFException eOFException) {
                return;
            }
        }

        public Vector getBindings() {
            return this.bindings;
        }
    }

    class DictionaryNode
    extends Node {
        HashMap bindings;

        public DictionaryNode(StreamTokenizer tokenizer) throws ParseException, IOException {
            this.bindings = new HashMap();
            this.parse(tokenizer);
        }

        public void parse(StreamTokenizer tokenizer) throws ParseException, IOException {
            String key = null;
            Object object = null;
            try {
                this.parseChar(tokenizer, 123);
                while (true) {
                    tokenizer.nextToken();
                    switch (tokenizer.ttype) {
                        case -3: {
                            key = tokenizer.sval;
                            break;
                        }
                        case 34: {
                            key = tokenizer.sval;
                            break;
                        }
                        case 125: {
                            throw new EOFException();
                        }
                        default: {
                            throw new ParseException(MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_UnexpectedKey"), tokenizer.toString()), tokenizer.lineno());
                        }
                    }
                    this.parseChar(tokenizer, 61);
                    tokenizer.nextToken();
                    switch (tokenizer.ttype) {
                        case -3: {
                            object = tokenizer.sval;
                            break;
                        }
                        case 34: {
                            object = tokenizer.sval;
                            break;
                        }
                        case 123: {
                            tokenizer.pushBack();
                            object = new DictionaryNode(tokenizer).getBindings();
                            break;
                        }
                        case 40: {
                            tokenizer.pushBack();
                            object = new ArrayNode(tokenizer).getBindings();
                            break;
                        }
                        case -2: {
                            object = this.parseNumber(tokenizer);
                            break;
                        }
                        default: {
                            throw new ParseException(MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_ExpectedObject"), tokenizer.toString()), tokenizer.lineno());
                        }
                    }
                    this.parseChar(tokenizer, 59);
                    this.bindings.put(key, object);
                }
            }
            catch (EOFException e) {
                return;
            }
        }

        public Object get(String s) {
            return this.bindings.get(s);
        }

        public Set getKeys() {
            return this.bindings.keySet();
        }

        public HashMap getBindings() {
            return this.bindings;
        }
    }

    abstract class Node {
        Node() {
        }

        public void parseChar(StreamTokenizer tokenizer, int charcode) throws IOException, ParseException {
            tokenizer.nextToken();
            if (tokenizer.ttype != charcode) {
                char[] charr = new char[]{(char)charcode};
                throw new ParseException(MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_Expected"), new String(charr), tokenizer.toString()), tokenizer.lineno());
            }
        }

        public Object parseNumber(StreamTokenizer tokenizer) throws IOException {
            String s5 = Double.toString(tokenizer.nval);
            tokenizer.nextToken();
            if (tokenizer.ttype == -2) {
                while (tokenizer.ttype == -2) {
                    s5 = s5 + Double.toString(tokenizer.nval);
                    tokenizer.nextToken();
                }
                tokenizer.pushBack();
                return s5;
            }
            tokenizer.pushBack();
            double d = Math.rint(tokenizer.nval);
            if (d == tokenizer.nval) {
                return new Integer((int)d);
            }
            return new Double(tokenizer.nval);
        }
    }
}

