/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.indicators.BarIndicatorConfiguration;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.openide.util.Lookup;

public class BarIndicator
extends Indicator<BarIndicatorConfiguration> {
    private final NumberFormat nf = NumberFormat.getNumberInstance();
    private BarIndicatorPanel panel;
    private Number[] barData;
    private int count = 0;
    private final BarIndicatorConfiguration configuration;

    public BarIndicator(BarIndicatorConfiguration config) {
        super((IndicatorConfiguration)config);
        this.configuration = config;
        for (DataTableMetadata.Column col : this.getMetadata().getColumns()) {
            if (col.getColumnClass().getSuperclass() == Number.class) continue;
            throw new IllegalArgumentException("BarIndicator could be based on Number data only!");
        }
        this.nf.setMinimumFractionDigits(2);
        this.nf.setMaximumFractionDigits(2);
        this.panel = new BarIndicatorPanel(this.getMetadata());
        this.barData = new Number[this.getMetadata().getColumnsCount()];
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updated(List<DataRow> data) {
        if (data.isEmpty()) {
            return;
        }
        int newCount = this.count + data.size();
        DataRow lastRow = data.get(data.size() - 1);
        int idx = 0;
        for (DataTableMetadata.Column col : this.getMetadataColumns()) {
            String value = lastRow.getStringValue(col.getColumnName());
            this.barData[idx] = this.count == 0 ? Double.valueOf(value) : Double.valueOf(value);
            ++idx;
        }
        this.count = newCount;
        this.panel.update();
    }

    protected void tick() {
    }

    protected void repairNeeded(boolean needed) {
    }

    public void reset() {
    }

    public void setIndicatorActionsProviderContext(Lookup context) {
    }

    private class BarIndicatorPanel
    extends JPanel {
        List<JLabel> barLabels = new ArrayList<JLabel>();

        public BarIndicatorPanel(IndicatorMetadata metadata) {
            this.setLayout(new GridBagLayout());
            int idx = 0;
            for (DataTableMetadata.Column c : metadata.getColumns()) {
                JLabel l = new JLabel(c.getColumnUName() + ": ");
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = idx;
                gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                this.add((Component)l, gridBagConstraints);
                JLabel v = new JLabel("--");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = idx++;
                gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                this.add((Component)v, gridBagConstraints);
                this.barLabels.add(v);
            }
        }

        private void update() {
            int idx = 0;
            for (JLabel l : this.barLabels) {
                l.setText(BarIndicator.this.nf.format(BarIndicator.this.barData[idx++]));
            }
        }
    }
}

