/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.plan;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.netbeans.modules.j2ee.sun.dd.api.DDException;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.j2ee.sun.share.plan.DeploymentPlan;
import org.netbeans.modules.j2ee.sun.share.plan.FileEntry;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.w3c.dom.Document;

public class Util {
    private Util() {
    }

    public static void convert(InputStream plan, JarOutputStream jar) throws IOException {
        DeploymentPlan dp = null;
        Schema2BeansException cause = null;
        Document doc = null;
        try {
            doc = GraphManager.createXmlDocument((InputStream)plan, (boolean)false);
        }
        catch (RuntimeException re) {
            Util.giveUp(re);
        }
        try {
            dp = DeploymentPlan.createGraph(doc);
        }
        catch (Schema2BeansException s2be) {
            cause = s2be;
        }
        if (null == dp) {
            SunWebApp swa = null;
            try {
                swa = DDProvider.getDefault().getWebDDRoot(doc);
                dp = DeploymentPlan.createGraph();
                FileEntry fe = new FileEntry();
                fe.setName("sun-web.xml");
                StringWriter strWriter = new StringWriter();
                swa.write((Writer)strWriter);
                fe.setContent(strWriter.toString());
                dp.addFileEntry(fe);
            }
            catch (DDException ex) {
                Util.giveUp(ex);
            }
            catch (Schema2BeansException s2bX) {
                Util.giveUp(s2bX);
            }
            catch (PropertyVetoException pv) {
                Util.giveUp(pv);
            }
        }
        int index = dp.sizeFileEntry();
        for (int i = 0; i < index; ++i) {
            FileEntry fe = dp.getFileEntry(i);
            String name = fe.getUri();
            name = null == name ? Util.hashify(fe.getName()) : name + "." + Util.hashify(fe.getName());
            JarEntry ent = new JarEntry(name);
            jar.putNextEntry(ent);
            String content = fe.getContent();
            jar.write(content.getBytes());
            jar.closeEntry();
        }
    }

    private static void giveUp(Throwable s2be) throws IOException {
        IOException ioe = new IOException("plan file issue");
        ioe.initCause(s2be);
        throw ioe;
    }

    private static String hashify(String path) {
        return path.replace('/', '#');
    }
}

