/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.glassfish.eecommon.api.HttpMonitorHelper;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.ResourceRegistrationHelper;
import org.netbeans.modules.glassfish.javaee.ide.Hk2Target;
import org.netbeans.modules.glassfish.javaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.glassfish.javaee.ide.MonitorProgressObject;
import org.netbeans.modules.glassfish.javaee.ide.UpdateContextRoot;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class FastDeploy
extends IncrementalDeployment {
    private Hk2DeploymentManager dm;

    public FastDeploy(Hk2DeploymentManager hk2DeploymentManager) {
        this.dm = hk2DeploymentManager;
    }

    public ProgressObject initialDeploy(Target target, J2eeModule j2eeModule, ModuleConfiguration moduleConfiguration, final File file) {
        final String string = Utils.sanitizeName((String)org.netbeans.modules.glassfish.eecommon.api.Utils.computeModuleID((J2eeModule)j2eeModule, (File)file, (String)Integer.toString(((Object)((Object)this)).hashCode())));
        String string2 = null;
        Hk2TargetModuleID hk2TargetModuleID = Hk2TargetModuleID.get((Hk2Target)target, string, string2, file.getAbsolutePath());
        final MonitorProgressObject monitorProgressObject = new MonitorProgressObject(this.dm, hk2TargetModuleID);
        MonitorProgressObject monitorProgressObject2 = new MonitorProgressObject(this.dm, hk2TargetModuleID);
        monitorProgressObject.addProgressListener(new UpdateContextRoot(monitorProgressObject2, hk2TargetModuleID, this.dm.getServerInstance(), J2eeModule.Type.WAR.equals(j2eeModule.getType())));
        MonitorProgressObject monitorProgressObject3 = new MonitorProgressObject(this.dm, hk2TargetModuleID);
        final GlassfishModule glassfishModule = this.dm.getCommonServerSupport();
        boolean bl = false;
        try {
            bl = HttpMonitorHelper.synchronizeMonitor((String)((String)glassfishModule.getInstanceProperties().get("domainsfolder")), (String)((String)glassfishModule.getInstanceProperties().get("domainname")), (boolean)Boolean.parseBoolean((String)glassfishModule.getInstanceProperties().get("httpMonitorOn")), (String[])new String[]{"modules/org-netbeans-modules-schema2beans.jar"});
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", iOException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", sAXException);
        }
        ResourceRegistrationHelper.deployResources(file, this.dm);
        if (bl) {
            monitorProgressObject3.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent progressEvent) {
                    if (progressEvent.getDeploymentStatus().isCompleted()) {
                        glassfishModule.deploy((OperationStateListener)monitorProgressObject, file, string);
                    } else {
                        monitorProgressObject.fireHandleProgressEvent(progressEvent.getDeploymentStatus());
                    }
                }
            });
            glassfishModule.restartServer((OperationStateListener)monitorProgressObject3);
            return monitorProgressObject2;
        }
        glassfishModule.deploy((OperationStateListener)monitorProgressObject, file, string);
        return monitorProgressObject2;
    }

    public ProgressObject incrementalDeploy(final TargetModuleID targetModuleID, AppChangeDescriptor appChangeDescriptor) {
        File file;
        DeploymentChangeDescriptor deploymentChangeDescriptor;
        boolean bl;
        final MonitorProgressObject monitorProgressObject = new MonitorProgressObject(this.dm, (Hk2TargetModuleID)targetModuleID, CommandType.REDEPLOY);
        MonitorProgressObject monitorProgressObject2 = new MonitorProgressObject(this.dm, (Hk2TargetModuleID)targetModuleID, CommandType.REDEPLOY);
        MonitorProgressObject monitorProgressObject3 = new MonitorProgressObject(this.dm, (Hk2TargetModuleID)targetModuleID, CommandType.REDEPLOY);
        monitorProgressObject.addProgressListener(new UpdateContextRoot(monitorProgressObject3, (Hk2TargetModuleID)targetModuleID, this.dm.getServerInstance(), null != targetModuleID.getWebURL()));
        final GlassfishModule glassfishModule = this.dm.getCommonServerSupport();
        boolean bl2 = false;
        try {
            bl2 = HttpMonitorHelper.synchronizeMonitor((String)((String)glassfishModule.getInstanceProperties().get("domainsfolder")), (String)((String)glassfishModule.getInstanceProperties().get("domainname")), (boolean)Boolean.parseBoolean((String)glassfishModule.getInstanceProperties().get("httpMonitorOn")), (String[])new String[]{"modules/org-netbeans-modules-schema2beans.jar"});
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", iOException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", sAXException);
        }
        boolean bl3 = bl = appChangeDescriptor.classesChanged() || appChangeDescriptor.descriptorChanged() || appChangeDescriptor.ejbsChanged() || appChangeDescriptor.manifestChanged() || appChangeDescriptor.serverDescriptorChanged();
        if (appChangeDescriptor instanceof DeploymentChangeDescriptor && (deploymentChangeDescriptor = (DeploymentChangeDescriptor)appChangeDescriptor).serverResourcesChanged() && null != (file = this.getDirectoryForModule(targetModuleID))) {
            ResourceRegistrationHelper.deployResources(file, this.dm);
        }
        if (bl2) {
            monitorProgressObject2.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent progressEvent) {
                    if (progressEvent.getDeploymentStatus().isCompleted()) {
                        if (bl) {
                            glassfishModule.redeploy((OperationStateListener)monitorProgressObject, targetModuleID.getModuleID());
                        } else {
                            monitorProgressObject.fireHandleProgressEvent(progressEvent.getDeploymentStatus());
                        }
                    } else {
                        monitorProgressObject.fireHandleProgressEvent(progressEvent.getDeploymentStatus());
                    }
                }
            });
            glassfishModule.restartServer((OperationStateListener)monitorProgressObject2);
            return monitorProgressObject3;
        }
        if (bl) {
            glassfishModule.redeploy((OperationStateListener)monitorProgressObject, targetModuleID.getModuleID());
        } else {
            monitorProgressObject.operationStateChanged(GlassfishModule.OperationState.COMPLETED, NbBundle.getMessage(FastDeploy.class, (String)"MSG_RedeployUnneeded"));
        }
        return monitorProgressObject3;
    }

    public boolean canFileDeploy(Target target, J2eeModule j2eeModule) {
        if (null == j2eeModule) {
            return false;
        }
        return j2eeModule.getType() != J2eeModule.Type.CAR;
    }

    public File getDirectoryForNewApplication(Target target, J2eeModule j2eeModule, ModuleConfiguration moduleConfiguration) {
        File file = null;
        if (j2eeModule.getType() == J2eeModule.Type.EAR) {
            File file2 = this.getProjectDir(j2eeModule);
            if (null == file2) {
                return file;
            }
            file = new File(file2, "target");
            if (!file.exists()) {
                file = new File(file2, "dist");
            }
            if (file.isFile() || file.isDirectory() && !file.canWrite()) {
                throw new IllegalStateException();
            }
            String string = Utils.sanitizeName((String)org.netbeans.modules.glassfish.eecommon.api.Utils.computeModuleID((J2eeModule)j2eeModule, null, null));
            String string2 = "gfdeploy";
            if (null != string) {
                string2 = string2 + "/" + string;
            }
            file = new File(file, string2);
            boolean bl = true;
            if (!file.exists()) {
                bl = file.mkdirs();
            }
            if (!bl || !file.isDirectory()) {
                file = null;
            }
        }
        return file;
    }

    public File getDirectoryForNewModule(File file, String string, J2eeModule j2eeModule, ModuleConfiguration moduleConfiguration) {
        return new File(file, FastDeploy.transform(this.removeLeadSlash(string)));
    }

    private String removeLeadSlash(String string) {
        if (null == string) {
            return string;
        }
        if (string.length() < 1) {
            return string;
        }
        if (!string.startsWith("/")) {
            return string;
        }
        return string.substring(1);
    }

    static String transform(String string) {
        StringBuffer stringBuffer;
        char c;
        int n = string.length();
        if (n > 4 && (c = (stringBuffer = new StringBuffer(string)).charAt(n - 4)) == '.') {
            stringBuffer.setCharAt(n - 4, '_');
            return stringBuffer.toString();
        }
        return string;
    }

    public File getDirectoryForModule(TargetModuleID targetModuleID) {
        return new File(((Hk2TargetModuleID)targetModuleID).getLocation());
    }

    public ProgressObject deployOnSave(TargetModuleID targetModuleID, DeploymentChangeDescriptor deploymentChangeDescriptor) {
        return this.incrementalDeploy(targetModuleID, (AppChangeDescriptor)deploymentChangeDescriptor);
    }

    public boolean isDeployOnSaveSupported() {
        return !"false".equals(System.getProperty("glassfish.javaee.deployonsave"));
    }

    private File getProjectDir(J2eeModule j2eeModule) {
        Object object;
        try {
            object = j2eeModule.getContentDirectory();
            Project project = FileOwnerQuery.getOwner((FileObject)object);
            if (null != project) {
                object = project.getProjectDirectory();
                return FileUtil.toFile((FileObject)object);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish-javaee").log(Level.FINER, null, iOException);
        }
        object = j2eeModule.getResourceDirectory();
        if (object != null) {
            return ((File)object).getParentFile();
        }
        return null;
    }

    public String getModuleUrl(TargetModuleID targetModuleID) {
        assert (null != targetModuleID);
        if (null == targetModuleID) {
            return "/bogusModule";
        }
        Hk2TargetModuleID hk2TargetModuleID = (Hk2TargetModuleID)targetModuleID;
        String string = hk2TargetModuleID.getModuleID();
        return string.startsWith("/") ? string : "/" + string;
    }
}

