/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.HostNameValidator;
import org.netbeans.validation.api.builtin.IpAddressValidator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValidHostNameOrIPValidator
implements Validator<String> {
    private final HostNameValidator hostVal;
    private final IpAddressValidator ipVal = new IpAddressValidator();

    ValidHostNameOrIPValidator(boolean allowPort) {
        this.hostVal = new HostNameValidator(allowPort);
    }

    ValidHostNameOrIPValidator() {
        this(true);
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        String[] parts = model.split("\\.");
        boolean hasIntParts = false;
        boolean hasNonIntParts = false;
        if (model.indexOf(" ") > 0 || model.indexOf("\t") > 0) {
            problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"HOST_MAY_NOT_CONTAIN_WHITESPACE", (Object)compName, (Object)model));
            return false;
        }
        if (parts.length == 0) {
            problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"INVALID_HOST_OR_IP", (Object)compName, (Object)model));
            return false;
        }
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (i == parts.length - 1 && s.contains(":")) {
                String[] partAndPort = s.split(":");
                if (partAndPort.length > 2) {
                    problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"TOO_MANY_COLONS", (Object)compName, (Object)model));
                    return false;
                }
                if (partAndPort.length == 0) {
                    problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"INVALID_HOST_OR_IP", (Object)compName, (Object)model));
                    return false;
                }
                s = partAndPort[0];
                if (partAndPort.length == 2) {
                    try {
                        Integer.parseInt(partAndPort[1]);
                    }
                    catch (NumberFormatException nfe) {
                        problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)partAndPort[1]));
                        return false;
                    }
                }
            }
            try {
                Integer.parseInt(s);
                hasIntParts = true;
            }
            catch (NumberFormatException nfe) {
                hasNonIntParts = true;
            }
            if (!hasIntParts || !hasNonIntParts) continue;
            problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"ADDRESS_CONTAINS_INT_AND_NON_INT_LABELS", (Object)compName, (Object)model));
            return false;
        }
        boolean validHost = hasNonIntParts && this.hostVal.validate(problems, compName, model);
        boolean validIp = hasIntParts && this.ipVal.validate(problems, compName, model);
        return validHost || validIp;
    }
}

