/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.modules.editor.options.ColoringBean;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.NbBundle;

public class ColoringEditorPanel
extends JPanel {
    public static final String PROP_COLORING = "Coloring";
    private ColoringBean value = new ColoringBean(SettingsDefaults.defaultColoring, "null", SettingsDefaults.defaultColoring, true);
    private PropWithDefaultPanel fontPanel;
    private PropWithDefaultPanel fgColorPanel;
    private PropWithDefaultPanel bgColorPanel;
    private ColoringPreview preview;

    public ColoringEditorPanel() {
        this.initComponents();
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        Class<?> fontEditorClass = PropertyEditorManager.findEditor(Font.class).getClass();
        Class<?> colorEditorClass = PropertyEditorManager.findEditor(Color.class).getClass();
        this.fontPanel = new PropWithDefaultPanel(Font.class, fontEditorClass, this.getBundleString("CEP_FontTitle"), this.getBundleString("ACSD_CEP_Font"), this.getBundleString("CEP_FontTrans"), this.getBundleString("ACSD_CEP_FontTrans"));
        this.fontPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("RealValue".equals(evt.getPropertyName())) {
                    Font newValue = (Font)ColoringEditorPanel.this.fontPanel.getValue();
                    ColoringEditorPanel.this.setValueImpl(Coloring.changeFont((Coloring)((ColoringEditorPanel)ColoringEditorPanel.this).value.coloring, (Font)newValue));
                }
            }
        });
        this.add((Component)this.fontPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        this.fgColorPanel = new PropWithDefaultPanel(Color.class, colorEditorClass, this.getBundleString("CEP_FgTitle"), this.getBundleString("ACSD_CEP_Fg"), this.getBundleString("CEP_FgTrans"), this.getBundleString("ACSD_CEP_FgTrans"));
        this.fgColorPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("RealValue".equals(evt.getPropertyName())) {
                    Color newValue = (Color)ColoringEditorPanel.this.fgColorPanel.getValue();
                    ColoringEditorPanel.this.setValueImpl(Coloring.changeForeColor((Coloring)((ColoringEditorPanel)ColoringEditorPanel.this).value.coloring, (Color)newValue));
                }
            }
        });
        this.add((Component)this.fgColorPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        this.bgColorPanel = new PropWithDefaultPanel(Color.class, colorEditorClass, this.getBundleString("CEP_BgTitle"), this.getBundleString("ACSD_CEP_Bg"), this.getBundleString("CEP_BgTrans"), this.getBundleString("ACSD_CEP_BgTrans"));
        this.bgColorPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("RealValue".equals(evt.getPropertyName())) {
                    Color newValue = (Color)ColoringEditorPanel.this.bgColorPanel.getValue();
                    ColoringEditorPanel.this.setValueImpl(Coloring.changeBackColor((Coloring)((ColoringEditorPanel)ColoringEditorPanel.this).value.coloring, (Color)newValue));
                }
            }
        });
        this.add((Component)this.bgColorPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.setBorder(new CompoundBorder(new TitledBorder(this.getBundleString("CEP_PreviewTitle")), new EmptyBorder(new Insets(9, 12, 11, 11))));
        this.preview = new ColoringPreview();
        this.preview.getAccessibleContext().setAccessibleName(this.getBundleString("ACSN_CEP_Preview"));
        this.preview.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_CEP_Preview"));
        previewPanel.add(this.preview);
        this.add((Component)previewPanel, gridBagConstraints1);
        this.updateEditors();
        Dimension small = this.getPreferredSize();
        small.width *= 2;
        small.height = (int)((double)small.height * 1.4);
        this.setPreferredSize(small);
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage(ColoringEditorPanel.class, (String)s);
    }

    public ColoringBean getValue() {
        return this.value;
    }

    public void setValue(ColoringBean value) {
        if (value == null || value.coloring == null) {
            return;
        }
        if (this.value != value) {
            this.value = value;
            this.updateEditors();
            this.preview.setValue(value);
            this.firePropertyChange("value", null, null);
        }
    }

    private void setValueImpl(Coloring newColoring) {
        this.value = this.value.changeColoring(newColoring);
        this.preview.setValue(this.value);
        this.firePropertyChange("value", null, null);
    }

    private void updateEditors() {
        if (this.value == null) {
            return;
        }
        this.fontPanel.setValue(this.value.coloring.getFont());
        this.fontPanel.setDefaultValue(this.value.defaultColoring.getFont());
        this.fontPanel.setDefault(this.value.isDefault);
        this.fgColorPanel.setValue(this.value.coloring.getForeColor());
        this.fgColorPanel.setDefaultValue(this.value.defaultColoring.getForeColor());
        this.fgColorPanel.setDefault(this.value.isDefault);
        this.bgColorPanel.setValue(this.value.coloring.getBackColor());
        this.bgColorPanel.setDefaultValue(this.value.defaultColoring.getBackColor());
        this.bgColorPanel.setDefault(this.value.isDefault);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private static class PropWithDefaultPanel
    extends JPanel {
        public static final String PROP_VALUE = "RealValue";
        Object value;
        Object defaultValue;
        boolean isDefault;
        PropertyModel model;
        JCheckBox defaultCheckBox;

        public PropWithDefaultPanel(Class propertyClass, Class propertyEditorClass, String title, String description, String checkBoxTitle, String checkBoxDescription) {
            this.setLayout(new BorderLayout());
            this.setBorder(new CompoundBorder(new TitledBorder(title), new EmptyBorder(new Insets(8, 12, 6, 11))));
            this.model = new PropertyModelSupport(propertyClass, propertyEditorClass, title);
            this.model.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("value".equals(evt.getPropertyName())) {
                        Object newValue;
                        block4: {
                            newValue = null;
                            try {
                                newValue = PropWithDefaultPanel.this.model.getValue();
                            }
                            catch (InvocationTargetException e) {
                                if (!Boolean.getBoolean("org.netbeans.exceptions")) break block4;
                                e.printStackTrace();
                            }
                        }
                        if (PropWithDefaultPanel.this.value == null && newValue.equals(PropWithDefaultPanel.this.defaultValue)) {
                            return;
                        }
                        PropWithDefaultPanel.this.value = newValue;
                        PropWithDefaultPanel.this.defaultCheckBox.setSelected(false);
                        PropWithDefaultPanel.this.firePropertyChange(PropWithDefaultPanel.PROP_VALUE, null, null);
                        PropWithDefaultPanel.this.repaint();
                    }
                }
            });
            PropertyPanel pp = new PropertyPanel(this.model, 0);
            pp.setMinimumSize(new Dimension(50, 22));
            pp.getAccessibleContext().setAccessibleName(title);
            pp.getAccessibleContext().setAccessibleDescription(description);
            this.add((Component)pp, "Center");
            this.defaultCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.defaultCheckBox, (String)checkBoxTitle);
            this.defaultCheckBox.getAccessibleContext().setAccessibleDescription(checkBoxDescription);
            this.defaultCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!PropWithDefaultPanel.this.defaultCheckBox.isSelected()) {
                        PropWithDefaultPanel.this.value = PropWithDefaultPanel.this.defaultValue;
                        PropWithDefaultPanel.this.modelSetValue(PropWithDefaultPanel.this.defaultValue);
                        PropWithDefaultPanel.this.firePropertyChange(PropWithDefaultPanel.PROP_VALUE, null, null);
                    } else {
                        PropWithDefaultPanel.this.value = null;
                        PropWithDefaultPanel.this.modelSetValue(PropWithDefaultPanel.this.defaultValue);
                        PropWithDefaultPanel.this.firePropertyChange(PropWithDefaultPanel.PROP_VALUE, null, null);
                    }
                }
            });
            this.add((Component)this.defaultCheckBox, "South");
        }

        @Override
        public void firePropertyChange(String s, Object old, Object newVal) {
            super.firePropertyChange(s, old, newVal);
        }

        public void setValue(Object value) {
            this.value = value;
            if (value == null) {
                this.modelSetValue(this.defaultValue);
                this.defaultCheckBox.setSelected(true);
            } else {
                this.modelSetValue(value);
                this.defaultCheckBox.setSelected(false);
            }
        }

        Object getValue() {
            return this.value;
        }

        public void setDefaultValue(Object def) {
            this.defaultValue = def;
            if (this.value == null) {
                this.modelSetValue(this.defaultValue);
            }
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.isDefault) {
                this.defaultCheckBox.setEnabled(false);
                this.defaultCheckBox.setSelected(false);
            }
        }

        private void modelSetValue(Object val) {
            block2: {
                try {
                    this.model.setValue(val);
                }
                catch (InvocationTargetException e) {
                    if (!Boolean.getBoolean("org.netbeans.exceptions")) break block2;
                    e.printStackTrace();
                }
            }
            this.repaint();
        }

        private class PropertyModelSupport
        implements ExPropertyModel {
            public static final String PROP_MOD_VALUE = "value";
            private PropertyChangeSupport support = new PropertyChangeSupport(this);
            Class type;
            Class editor;
            Object value;
            String displayName;

            public PropertyModelSupport(Class propertyType, Class propertyEditor, String displayName) {
                this.type = propertyType;
                this.editor = propertyEditor;
                this.displayName = displayName;
            }

            public Class getPropertyType() {
                return this.type;
            }

            public Class getPropertyEditorClass() {
                return this.editor;
            }

            public Object getValue() {
                return this.value;
            }

            public void setValue(Object v) {
                if (v != null && !v.equals(this.value)) {
                    this.value = v;
                    this.support.firePropertyChange(PROP_MOD_VALUE, null, null);
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
                this.support.addPropertyChangeListener(l);
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
                this.support.removePropertyChangeListener(l);
            }

            public Object[] getBeans() {
                return new Object[0];
            }

            public FeatureDescriptor getFeatureDescriptor() {
                FeatureDescriptor desc = new FeatureDescriptor();
                desc.setDisplayName(this.displayName);
                if (this.editor == PropertyEditorManager.findEditor(Font.class).getClass()) {
                    desc.setValue("canEditAsText", Boolean.FALSE);
                }
                return desc;
            }
        }
    }

    private class ColoringPreview
    extends JComponent
    implements Accessible {
        ColoringBean value;

        private ColoringPreview() {
        }

        void setValue(ColoringBean c) {
            this.value = c;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            if (this.value != null) {
                Coloring coloring = this.value.coloring.apply(this.value.defaultColoring);
                Rectangle box = this.getBounds();
                g.setColor(coloring.getBackColor());
                g.fillRect(0, 0, box.width - 1, box.height - 1);
                g.setColor(coloring.getForeColor());
                g.setFont(coloring.getFont());
                FontMetrics fm = g.getFontMetrics();
                int x = Math.max((box.width - fm.stringWidth(this.value.example)) / 2, 0);
                int y = Math.max((box.height - fm.getHeight()) / 2 + fm.getAscent(), 0);
                g.drawString(this.value.example, x, y);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JComponent.AccessibleJComponent(){

                    @Override
                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.PANEL;
                    }
                };
            }
            return this.accessibleContext;
        }
    }
}

