/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LoadGenPanel
extends JPanel {
    private static final String LASTFILE_PROPERTY = LoadGenPanel.class.getName() + "_lastfile";
    private static final String ENABLESELECTOR_PROPERTY = LoadGenPanel.class.getName() + "_enable";
    public static final String PATH = "org.netbeans.modules.profiler.j2ee.LoadGenPanel#path";
    private String lastSelectedPath = null;
    private FriendlyFileObject lastSelectedFile = null;
    private Boolean shouldEnableSelector = false;
    private Project attachedProject = null;
    private Set<String> supportedExtensions = null;
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private volatile boolean internalChanges = false;
    private JComboBox scriptsCombo;
    private JCheckBox scriptsEnabled;

    public LoadGenPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.scriptsCombo = new JComboBox();
        this.scriptsEnabled = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 5));
        this.scriptsCombo.setModel(this.getModel());
        this.scriptsCombo.setEnabled(false);
        this.scriptsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadGenPanel.this.pathChangeListener(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.scriptsEnabled, (String)NbBundle.getMessage(LoadGenPanel.class, (String)"LoadGenPanel.scriptsEnabled.text"));
        this.scriptsEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scriptsEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.scriptsEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadGenPanel.this.scriptsEnabledHandler(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.scriptsEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptsCombo, -2, 256, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scriptsEnabled).addComponent(this.scriptsCombo, -2, -1, -2)));
        this.scriptsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LoadGenPanel.class, (String)"LoadGenPanel.scriptsCombo.AccessibleContext.accessibleName"));
        this.scriptsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoadGenPanel.class, (String)"LoadGenPanel.scriptsCombo.AccessibleContext.accessibleDescription"));
    }

    private void scriptsEnabledHandler(ActionEvent actionEvent) {
        if (this.internalChanges) {
            return;
        }
        this.lastSelectedFile = (FriendlyFileObject)this.getModel().getSelectedItem();
        String string = this.getSelectedScript();
        this.firePropertyChange(PATH, this.lastSelectedPath, string);
        this.scriptsCombo.setEnabled(this.scriptsEnabled.isSelected());
        this.shouldEnableSelector = this.scriptsEnabled.isSelected();
        this.lastSelectedPath = string;
    }

    private void pathChangeListener(ActionEvent actionEvent) {
        if (this.internalChanges) {
            return;
        }
        this.lastSelectedFile = (FriendlyFileObject)this.getModel().getSelectedItem();
        String string = this.getSelectedScript();
        this.firePropertyChange(PATH, this.lastSelectedPath, string);
        this.lastSelectedPath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Project project) {
        this.internalChanges = true;
        try {
            this.attachedProject = project;
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            arrayList.addAll(this.findScripts(project));
            this.model.removeAllElements();
            for (FileObject fileObject : arrayList) {
                this.model.addElement(new FriendlyFileObject(fileObject));
            }
            this.adjustUI();
        }
        finally {
            this.internalChanges = false;
        }
    }

    public String getSelectedScript() {
        if (!this.scriptsEnabled.isSelected()) {
            return null;
        }
        if (this.scriptsCombo.getSelectedItem() == null) {
            return null;
        }
        try {
            Object object = this.scriptsCombo.getSelectedItem();
            if (object instanceof FriendlyFileObject) {
                FileObject fileObject = ((FriendlyFileObject)object).getFileObject();
                String string = FileUtil.toFile((FileObject)fileObject).getCanonicalPath();
                return string;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public void loadCustomSettings(Properties properties) {
        if (properties != null) {
            FileObject fileObject;
            Object object;
            this.lastSelectedFile = null;
            String string = properties.getProperty(LASTFILE_PROPERTY);
            if (string != null && ((File)(object = new File(string))).exists() && (fileObject = FileUtil.toFileObject((File)object)) != null) {
                this.lastSelectedFile = new FriendlyFileObject(fileObject);
            }
            this.shouldEnableSelector = false;
            object = properties.getProperty(ENABLESELECTOR_PROPERTY);
            if (object != null) {
                this.shouldEnableSelector = Boolean.parseBoolean((String)object);
            }
            this.adjustUI();
        }
    }

    public void storeCustomSettings(Properties properties) {
        if (properties != null) {
            if (this.lastSelectedFile != null) {
                String string = FileUtil.toFile((FileObject)this.lastSelectedFile.delegate).getAbsolutePath();
                properties.setProperty(LASTFILE_PROPERTY, string);
            }
            properties.setProperty(ENABLESELECTOR_PROPERTY, this.shouldEnableSelector.toString());
        }
    }

    private List<FileObject> findScripts(Project project) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        LoadGenPlugin loadGenPlugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
        if (loadGenPlugin != null) {
            arrayList.addAll(loadGenPlugin.listScripts(project));
        }
        return arrayList;
    }

    private ComboBoxModel getModel() {
        return this.model;
    }

    private void adjustUI() {
        if (this.isModelEmpty()) {
            this.scriptsEnabled.setSelected(false);
            this.scriptsEnabled.setEnabled(false);
            this.scriptsCombo.setEnabled(false);
            this.model.addElement(NbBundle.getMessage(this.getClass(), (String)"LoadGenPanel_NoScripts"));
            this.firePropertyChange(PATH, null, null);
        } else {
            this.scriptsEnabled.setSelected(this.shouldEnableSelector);
            this.scriptsEnabled.setEnabled(true);
            this.scriptsCombo.setEnabled(this.scriptsEnabled.isSelected());
            if (this.lastSelectedFile != null && this.model.getIndexOf(this.lastSelectedFile) > -1) {
                this.model.setSelectedItem(this.lastSelectedFile);
            }
            String string = this.getSelectedScript();
            this.firePropertyChange(PATH, this.lastSelectedPath, string);
            this.lastSelectedPath = string;
        }
    }

    private boolean isModelEmpty() {
        return this.model.getSize() == 0 || this.model.getElementAt(0).equals(NbBundle.getMessage(this.getClass(), (String)"LoadGenPanel_NoScripts"));
    }

    private class FriendlyFileObject {
        private FileObject delegate;

        public FriendlyFileObject(FileObject fileObject) {
            this.delegate = fileObject;
        }

        public FileObject getFileObject() {
            return this.delegate;
        }

        public String toString() {
            return this.delegate != null ? this.delegate.getNameExt() : "";
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }

        public boolean equals(Object object) {
            if (this.delegate == null) {
                return false;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof FriendlyFileObject)) {
                return false;
            }
            if (((FriendlyFileObject)object).delegate == null) {
                return false;
            }
            return this.delegate.equals(((FriendlyFileObject)object).delegate);
        }
    }
}

