/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.swing.outline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.netbeans.modules.websvc.manager.swing.outline.DefaultOutlineModel;
import org.netbeans.modules.websvc.manager.swing.outline.Outline;
import org.netbeans.modules.websvc.manager.swing.outline.OutlineModel;
import org.netbeans.modules.websvc.manager.swing.outline.RowModel;
import org.openide.util.Utilities;

public class TestOutlineDynamic
extends JFrame
implements ActionListener {
    private Outline outline;
    private TreeModel treeMdl;
    static int nodeCount = 0;

    public TestOutlineDynamic() {
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.treeMdl = TestOutlineDynamic.createModel();
        OutlineModel mdl = DefaultOutlineModel.createOutlineModel(this.treeMdl, new NodeRowModel(), true);
        this.outline = new Outline();
        this.outline.setRootVisible(true);
        this.outline.setModel(mdl);
        JPanel buttons = new JPanel();
        JLabel jl = new JLabel("Read the button tooltips");
        buttons.setLayout(new BoxLayout(buttons, 1));
        buttons.add(jl);
        final JButton add = new JButton("Add child");
        final JButton remove = new JButton("Delete child");
        final JButton clear = new JButton("Clear");
        final JButton addDis = new JButton("Add discontiguous");
        final JButton removeDis = new JButton("Delete discontiguous");
        addDis.setEnabled(false);
        removeDis.setEnabled(false);
        removeDis.setToolTipText("To enable, select more than one immediate child node of the same parent node");
        addDis.setToolTipText("To enable, select a node with more than one child");
        add.setToolTipText("Add a child to the selected node");
        remove.setToolTipText("Delete the selected node");
        clear.setToolTipText("Clear the model, leaving only the root node");
        clear.setEnabled(false);
        add.addActionListener(this);
        remove.addActionListener(this);
        clear.addActionListener(this);
        addDis.addActionListener(this);
        removeDis.addActionListener(this);
        add.setName("add");
        remove.setName("remove");
        clear.setName("clear");
        addDis.setName("addDis");
        removeDis.setName("removeDis");
        buttons.add(add);
        buttons.add(remove);
        buttons.add(clear);
        buttons.add(addDis);
        buttons.add(removeDis);
        add.setEnabled(false);
        remove.setEnabled(false);
        this.outline.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean en = TestOutlineDynamic.this.outline.getSelectedRow() != -1;
                add.setEnabled(en);
                remove.setEnabled(en && TestOutlineDynamic.this.outline.getSelectedRow() != 0);
                clear.setEnabled(TestOutlineDynamic.this.outline.getRowCount() > 1);
                ListSelectionModel m = TestOutlineDynamic.this.outline.getSelectionModel();
                boolean bl = en = TestOutlineDynamic.this.getSelectedNode() != null;
                if (en) {
                    DefaultMutableTreeNode nd = TestOutlineDynamic.this.getSelectedNode();
                    en = nd.getChildCount() > 1;
                }
                addDis.setEnabled(en);
                boolean bl2 = en = TestOutlineDynamic.this.getSelectedNode() != null;
                if (en) {
                    int[] sels = TestOutlineDynamic.this.getSelectedIndices();
                    boolean bl3 = en = sels.length > 1;
                    if (sels.length > TestOutlineDynamic.this.outline.getRowCount()) {
                        en = false;
                    }
                    if (en) {
                        DefaultMutableTreeNode lastParent = null;
                        for (int i = 0; i < sels.length; ++i) {
                            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)TestOutlineDynamic.this.outline.getValueAt(sels[i], 0);
                            if (nd == null) {
                                en = false;
                                break;
                            }
                            if (lastParent != null) {
                                if (en &= nd.getParent() == lastParent) continue;
                                break;
                            }
                            lastParent = (DefaultMutableTreeNode)nd.getParent();
                        }
                    }
                }
                removeDis.setEnabled(en);
            }
        });
        this.getContentPane().add((Component)new JScrollPane(this.outline), "Center");
        this.getContentPane().add((Component)buttons, "East");
        this.setBounds(20, 20, 700, 400);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton b = (JButton)e.getSource();
        DefaultMutableTreeNode n = this.getSelectedNode();
        DefaultTreeModel mdl = (DefaultTreeModel)this.treeMdl;
        if ("add".equals(b.getName())) {
            Node newNode = new Node();
            DefaultMutableTreeNode nd = new DefaultMutableTreeNode(newNode, true);
            n.add(nd);
            mdl.nodesWereInserted(n, new int[]{n.getChildCount() - 1});
        } else if ("remove".equals(b.getName())) {
            mdl.removeNodeFromParent(n);
        } else if ("clear".equals(b.getName())) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)mdl.getRoot();
            root.removeAllChildren();
            nodeCount = 1;
            mdl.reload(root);
        } else if ("addDis".equals(b.getName())) {
            DefaultMutableTreeNode nd = this.getSelectedNode();
            int ch = nd.getChildCount();
            DefaultMutableTreeNode atStart = new DefaultMutableTreeNode(new Node(), true);
            DefaultMutableTreeNode atEnd = new DefaultMutableTreeNode(new Node(), true);
            nd.insert(atEnd, ch);
            nd.insert(atStart, 0);
            mdl.nodesWereInserted(nd, new int[]{0, nd.getChildCount() - 1});
        } else if ("removeDis".equals(b.getName())) {
            int i;
            int[] sels = this.getSelectedIndices();
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.outline.getValueAt(sels[0], 0);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)aNode.getParent();
            int i2 = 0;
            while (i2 < sels.length) {
                int n2 = i2++;
                sels[n2] = sels[n2] * -1;
            }
            Arrays.sort(sels);
            i2 = 0;
            while (i2 < sels.length) {
                int n3 = i2++;
                sels[n3] = sels[n3] * -1;
            }
            System.err.println("Going to remove " + Arrays.asList(Utilities.toObjectArray((Object)sels)));
            ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
            int[] indices = new int[sels.length];
            for (i = 0; i < sels.length; ++i) {
                aNode = (DefaultMutableTreeNode)this.outline.getValueAt(sels[i], 0);
                System.err.println("To delete user object class " + aNode.getUserObject().getClass() + " = " + aNode.getUserObject());
                nodes.add(aNode);
                indices[i] = parent.getIndex(aNode);
            }
            System.err.println("Will really remove indices " + Arrays.asList(Utilities.toObjectArray((Object)indices)));
            for (i = 0; i < nodes.size(); ++i) {
                aNode = (DefaultMutableTreeNode)nodes.get(i);
                if (aNode.getParent() != parent) {
                    System.err.println(aNode + " not child of " + parent + " but of " + aNode.getParent());
                    continue;
                }
                System.err.println("REMOVING " + aNode + " from parent");
                parent.remove(aNode);
                nodes.add(aNode);
            }
            mdl.nodesWereRemoved(parent, indices, nodes.toArray());
        }
    }

    private int[] getSelectedIndices() {
        int max;
        ListSelectionModel lsm = this.outline.getSelectionModel();
        int min = lsm.getMinSelectionIndex();
        if (min == (max = lsm.getMaxSelectionIndex())) {
            return new int[]{min};
        }
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (int i = min; i <= max; ++i) {
            if (!lsm.isSelectedIndex(i)) continue;
            al.add(new Integer(i));
        }
        Object[] ints = al.toArray(new Integer[0]);
        return (int[])Utilities.toPrimitiveArray((Object[])ints);
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.outline.getValueAt(this.outline.getSelectedRow(), 0);
    }

    public static TreeModel createModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new Node());
        DefaultTreeModel treeMdl = new DefaultTreeModel(root, false);
        return treeMdl;
    }

    public static void main(String[] ignored) {
        new TestOutlineDynamic().show();
    }

    private static class Node {
        int idx = nodeCount++;
        private String comment = "no comment";

        public String getComment() {
            return this.comment;
        }

        public void setComment(String s) {
            this.comment = s;
        }

        public String toString() {
            return "Node " + this.idx;
        }
    }

    private class NodeRowModel
    implements RowModel {
        private NodeRowModel() {
        }

        @Override
        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Hash code" : "Comment";
        }

        @Override
        public Object getValueFor(Object node, int column) {
            Node n = (Node)((DefaultMutableTreeNode)node).getUserObject();
            switch (column) {
                case 0: {
                    return new Integer(node.hashCode());
                }
                case 1: {
                    return n.getComment();
                }
            }
            assert (false);
            return null;
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            return column == 1;
        }

        @Override
        public void setValueFor(Object node, int column, Object value) {
            if (column == 1) {
                ((Node)((DefaultMutableTreeNode)node).getUserObject()).setComment(value.toString());
            }
        }
    }
}

