/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.WindowWaiter;

public class DialogWaiter
extends WindowWaiter
implements Timeoutable,
Outputable {
    private static final long WAIT_TIME = 60000L;
    private static final long AFTER_WAIT_TIME = 0L;
    private Timeouts timeouts;
    private TestOut output;

    public DialogWaiter() {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public static Dialog getDialog(ComponentChooser cc) {
        return (Dialog)WindowWaiter.getWindow(new DialogSubChooser(cc));
    }

    public static Dialog getDialog(ComponentChooser cc, int index) {
        return (Dialog)WindowWaiter.getWindow(new DialogSubChooser(cc), index);
    }

    public static Dialog getDialog(String title, boolean ce, boolean cc) {
        return (Dialog)WindowWaiter.getWindow(new DialogByTitleChooser(title, ce, cc));
    }

    public static Dialog getDialog(String title, boolean ce, boolean cc, int index) {
        return DialogWaiter.getDialog(new DialogByTitleChooser(title, ce, cc), index);
    }

    public static Dialog getDialog(Window owner, ComponentChooser cc) {
        return (Dialog)WindowWaiter.getWindow(owner, new DialogSubChooser(cc));
    }

    public static Dialog getDialog(Window owner, ComponentChooser cc, int index) {
        return (Dialog)WindowWaiter.getWindow(owner, new DialogSubChooser(cc), index);
    }

    public static Dialog getDialog(Window owner, String title, boolean ce, boolean cc) {
        return (Dialog)WindowWaiter.getWindow(owner, new DialogByTitleChooser(title, ce, cc));
    }

    public static Dialog getDialog(Window owner, String title, boolean ce, boolean cc, int index) {
        return DialogWaiter.getDialog(owner, new DialogByTitleChooser(title, ce, cc), index);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts times = timeouts.cloneThis();
        times.setTimeout("WindowWaiter.WaitWindowTimeout", timeouts.getTimeout("DialogWaiter.WaitDialogTimeout"));
        times.setTimeout("WindowWaiter.AfterWindowTimeout", timeouts.getTimeout("DialogWaiter.AfterDialogTimeout"));
        super.setTimeouts(times);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut output) {
        this.output = output;
        super.setOutput(output);
    }

    public TestOut getOutput() {
        return this.output;
    }

    public Dialog waitDialog(ComponentChooser ch, int index) throws InterruptedException {
        this.setTimeouts(this.timeouts);
        return (Dialog)this.waitWindow(new DialogSubChooser(ch), index);
    }

    public Dialog waitDialog(ComponentChooser ch) throws InterruptedException {
        return this.waitDialog(ch, 0);
    }

    public Dialog waitDialog(String title, boolean compareExactly, boolean compareCaseSensitive, int index) throws InterruptedException {
        return this.waitDialog(new DialogByTitleChooser(title, compareExactly, compareCaseSensitive), index);
    }

    public Dialog waitDialog(String title, boolean compareExactly, boolean compareCaseSensitive) throws InterruptedException {
        return this.waitDialog(title, compareExactly, compareCaseSensitive, 0);
    }

    public Dialog waitDialog(Window owner, ComponentChooser ch, int index) throws InterruptedException {
        this.setTimeouts(this.timeouts);
        return (Dialog)this.waitWindow(owner, new DialogSubChooser(ch), index);
    }

    public Dialog waitDialog(Window owner, ComponentChooser ch) throws InterruptedException {
        return this.waitDialog(owner, ch, 0);
    }

    public Dialog waitDialog(Window owner, String title, boolean compareExactly, boolean compareCaseSensitive, int index) throws InterruptedException {
        return this.waitDialog(owner, new DialogByTitleChooser(title, compareExactly, compareCaseSensitive), index);
    }

    public Dialog waitDialog(Window owner, String title, boolean compareExactly, boolean compareCaseSensitive) throws InterruptedException {
        return this.waitDialog(owner, title, compareExactly, compareCaseSensitive, 0);
    }

    protected String getWaitingStartedMessage() {
        return "Start to wait dialog \"" + this.getComponentChooser().getDescription() + "\" opened";
    }

    protected String getTimeoutExpiredMessage(long spendedTime) {
        return "Dialog \"" + this.getComponentChooser().getDescription() + "\" has not been opened in " + new Long(spendedTime).toString() + " milliseconds";
    }

    protected String getActionProducedMessage(long spendedTime, final Object result) {
        String resultToString = result instanceof Component ? (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("result.toString()"){

            public Object launch() {
                return result.toString();
            }
        }) : result.toString();
        return "Dialog \"" + this.getComponentChooser().getDescription() + "\" has been opened in " + new Long(spendedTime).toString() + " milliseconds" + "\n    " + resultToString;
    }

    protected String getGoldenWaitingStartedMessage() {
        return "Start to wait dialog \"" + this.getComponentChooser().getDescription() + "\" opened";
    }

    protected String getGoldenTimeoutExpiredMessage() {
        return "Dialog \"" + this.getComponentChooser().getDescription() + "\" has not been opened";
    }

    protected String getGoldenActionProducedMessage() {
        return "Dialog \"" + this.getComponentChooser().getDescription() + "\" has been opened";
    }

    private Dialog waitDialog() throws InterruptedException {
        return (Dialog)this.waitAction("");
    }

    static {
        Timeouts.initDefault("DialogWaiter.WaitDialogTimeout", 60000L);
        Timeouts.initDefault("DialogWaiter.AfterDialogTimeout", 0L);
    }

    private static class DialogByTitleChooser
    implements ComponentChooser {
        String title;
        boolean compareExactly;
        boolean compareCaseSensitive;

        public DialogByTitleChooser(String t, boolean ce, boolean cc) {
            this.title = t;
            this.compareExactly = ce;
            this.compareCaseSensitive = cc;
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof Dialog && ((Dialog)comp).isShowing() && comp.isVisible() && ((Dialog)comp).getTitle() != null) {
                String titleToComp = ((Dialog)comp).getTitle();
                String contextToComp = this.title;
                if (this.compareCaseSensitive) {
                    titleToComp = titleToComp.toUpperCase();
                    contextToComp = contextToComp.toUpperCase();
                }
                if (this.compareExactly) {
                    return titleToComp.equals(contextToComp);
                }
                return titleToComp.indexOf(contextToComp) != -1;
            }
            return false;
        }

        public String getDescription() {
            return this.title;
        }
    }

    private static class DialogSubChooser
    implements ComponentChooser {
        private ComponentChooser chooser;

        public DialogSubChooser(ComponentChooser c) {
            this.chooser = c;
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof Dialog) {
                return comp.isShowing() && comp.isVisible() && this.chooser.checkComponent(comp);
            }
            return false;
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }
}

