/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.proxy;

import java.io.ByteArrayOutputStream;

public class Base64Encoder {
    private static final char[] characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private Base64Encoder() {
    }

    public static String encode(byte[] data) {
        return Base64Encoder.encode(data, false);
    }

    public static String encode(byte[] data, boolean useNewlines) {
        int d;
        int i;
        int length = data.length;
        StringBuffer sb = new StringBuffer(data.length * 3 / 2);
        int end = length - 3;
        int lineCount = 0;
        for (i = 0; i <= end; i += 3) {
            d = (data[i] & 0xFF) << 16 | (data[i + 1] & 0xFF) << 8 | data[i + 2] & 0xFF;
            sb.append(characters[d >> 18 & 0x3F]);
            sb.append(characters[d >> 12 & 0x3F]);
            sb.append(characters[d >> 6 & 0x3F]);
            sb.append(characters[d & 0x3F]);
            if (!useNewlines || lineCount++ < 14) continue;
            lineCount = 0;
            sb.append(System.getProperty("line.separator"));
        }
        if (i == length - 2) {
            d = (data[i] & 0xFF) << 16 | (data[i + 1] & 0xFF) << 8;
            sb.append(characters[d >> 18 & 0x3F]);
            sb.append(characters[d >> 12 & 0x3F]);
            sb.append(characters[d >> 6 & 0x3F]);
            sb.append("=");
        } else if (i == length - 1) {
            d = (data[i] & 0xFF) << 16;
            sb.append(characters[d >> 18 & 0x3F]);
            sb.append(characters[d >> 12 & 0x3F]);
            sb.append("==");
        }
        return sb.toString();
    }

    public static byte[] decode(String s) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64Encoder.decode(s, bos);
        return bos.toByteArray();
    }

    private static void decode(String s, ByteArrayOutputStream bos) {
        int i = 0;
        int len = s.length();
        while (true) {
            if (i < len && s.charAt(i) <= ' ') {
                ++i;
                continue;
            }
            if (i == len) break;
            int tri = (Base64Encoder.decode(s.charAt(i)) << 18) + (Base64Encoder.decode(s.charAt(i + 1)) << 12) + (Base64Encoder.decode(s.charAt(i + 2)) << 6) + Base64Encoder.decode(s.charAt(i + 3));
            bos.write(tri >> 16 & 0xFF);
            if (s.charAt(i + 2) == '=') break;
            bos.write(tri >> 8 & 0xFF);
            if (s.charAt(i + 3) == '=') break;
            bos.write(tri & 0xFF);
            i += 4;
        }
    }

    private static int decode(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 26 + 26;
        }
        switch (c) {
            case '+': {
                return 62;
            }
            case '/': {
                return 63;
            }
            case '=': {
                return 0;
            }
        }
        throw new RuntimeException("Base64: unexpected code: " + c);
    }
}

