/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbjar.EarAccessor;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation2;
import org.netbeans.modules.j2ee.spi.ejbjar.EarProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class Ear {
    private static final Lookup.Result<EarProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(EarProvider.class));
    private final EarImplementation impl;
    private final EarImplementation2 impl2;

    private Ear(EarImplementation impl, EarImplementation2 impl2) {
        assert (impl != null && impl2 == null || impl == null && impl2 != null);
        this.impl = impl;
        this.impl2 = impl2;
    }

    public static Ear getEar(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to Ear.getEar(FileObject)");
        }
        for (EarProvider earProvider : implementations.allInstances()) {
            Ear wm = earProvider.findEar(f);
            if (wm == null) continue;
            return wm;
        }
        return null;
    }

    public String getJ2eePlatformVersion() {
        if (this.impl2 != null) {
            Profile profile = this.impl2.getJ2eeProfile();
            if (profile != null) {
                return profile.toPropertiesString();
            }
            return null;
        }
        return this.impl.getJ2eePlatformVersion();
    }

    public Profile getJ2eeProfile() {
        if (this.impl2 != null) {
            return this.impl2.getJ2eeProfile();
        }
        return Profile.fromPropertiesString((String)this.impl.getJ2eePlatformVersion());
    }

    public FileObject getDeploymentDescriptor() {
        if (this.impl2 != null) {
            this.impl2.getDeploymentDescriptor();
        }
        return this.impl.getDeploymentDescriptor();
    }

    public void addWebModule(WebModule module) {
        if (this.impl2 != null) {
            this.impl2.addWebModule(module);
        } else {
            this.impl.addWebModule(module);
        }
    }

    public void addEjbJarModule(EjbJar module) {
        if (this.impl2 != null) {
            this.impl2.addEjbJarModule(module);
        } else {
            this.impl.addEjbJarModule(module);
        }
    }

    public void addCarModule(Car module) {
        if (this.impl2 != null) {
            this.impl2.addCarModule(module);
        } else {
            this.impl.addCarModule(module);
        }
    }

    static {
        EarAccessor.DEFAULT = new EarAccessor(){

            @Override
            public Ear createEar(EarImplementation spiEar) {
                return new Ear(spiEar, null);
            }

            @Override
            public Ear createEar(EarImplementation2 spiEar) {
                return new Ear(null, spiEar);
            }
        };
    }
}

