/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projecttemplates;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.netbeans.modules.projecttemplates.FileCreator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;

class TemplateBasedFileCreator
extends FileCreator {
    private final FileObject template;

    public TemplateBasedFileCreator(String destPath, String name, FileObject template, boolean openOnLoad) {
        super(destPath, name, openOnLoad);
        this.template = template;
    }

    @Override
    public DataObject create(FileObject project, Map<String, String> params) throws IOException {
        String folder = this.dest;
        String fileName = this.name;
        if (fileName == null) {
            int ix = folder.lastIndexOf(47);
            fileName = folder.substring(ix + 1);
            folder = folder.substring(0, ix);
        }
        DataObject ob = DataObject.find((FileObject)this.template);
        FileObject destFolder = FileUtil.createFolder((FileObject)project, (String)folder);
        DataFolder destFld = DataFolder.findFolder((FileObject)destFolder);
        boolean performManualSubstitutions = fileName.endsWith(".MF");
        int ix = fileName.lastIndexOf(46);
        if (ix > 0) {
            fileName = fileName.substring(0, ix);
        }
        DataObject result = ob.createFromTemplate(destFld, fileName, params);
        if (performManualSubstitutions) {
            this.substitute(result, params);
        }
        if (result.getPrimaryFile().isLocked()) {
            throw new IllegalStateException("Output file " + result.getPrimaryFile().getPath() + " should not be locked after create-from-template");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void substitute(DataObject result, Map<String, String> params) throws IOException {
        FileObject file = result.getPrimaryFile();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        InputStream in = file.getInputStream();
        try {
            FileUtil.copy((InputStream)in, (OutputStream)data);
        }
        finally {
            in.close();
            data.close();
        }
        String content = data.toString("UTF-8");
        MapFormat fmt = new MapFormat(params);
        fmt.setLeftBrace("${");
        fmt.setRightBrace("}");
        String output = fmt.format((Object)content);
        ByteArrayInputStream outData = new ByteArrayInputStream(output.getBytes("UTF-8"));
        FileLock lock = file.lock();
        BufferedOutputStream fileOut = new BufferedOutputStream(file.getOutputStream(lock));
        try {
            FileUtil.copy((InputStream)outData, (OutputStream)fileOut);
        }
        finally {
            outData.close();
            ((OutputStream)fileOut).close();
            lock.releaseLock();
        }
    }

    @Override
    public String toString() {
        return "Create " + this.dest + (this.name == null ? "" : this.name) + " from " + this.template.getPath();
    }
}

