/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.elements.FullyQualifiedElementImpl;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.openide.util.Parameters;

public class InterfaceElementImpl
extends TypeElementImpl
implements InterfaceElement {
    public static final String IDX_FIELD = "iface";

    private InterfaceElementImpl(QualifiedName qualifiedName, int offset, Set<QualifiedName> ifaceNames, String fileUrl, ElementQuery elementQuery) {
        super(qualifiedName, offset, ifaceNames, PhpModifiers.noModifiers().toFlags(), fileUrl, elementQuery);
    }

    public static Set<InterfaceElement> fromSignature(IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        return InterfaceElementImpl.fromSignature(NameKind.empty(), indexScopeQuery, indexResult);
    }

    public static Set<InterfaceElement> fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<InterfaceElement> retval = values.length > 0 ? new HashSet<InterfaceElement>() : Collections.emptySet();
        for (String val : values) {
            InterfaceElement iface = InterfaceElementImpl.fromSignature(query, indexScopeQuery, indexResult, Signature.get(val));
            if (iface == null) continue;
            retval.add(iface);
        }
        return retval;
    }

    private static InterfaceElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature signature) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        InterfaceSignatureParser signParser = new InterfaceSignatureParser(signature);
        InterfaceElementImpl retval = null;
        if (InterfaceElementImpl.matchesQuery(query, signParser)) {
            retval = new InterfaceElementImpl(signParser.getQualifiedName(), signParser.getOffset(), signParser.getSuperInterfaces(), indexResult.getUrl().toString(), (ElementQuery)indexScopeQuery);
        }
        return retval;
    }

    private static boolean matchesQuery(NameKind query, InterfaceSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(InterfaceElement.KIND, signParser.getQualifiedName());
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        StringBuilder ifaceSb = new StringBuilder();
        for (QualifiedName ifaceName : this.getSuperInterfaces()) {
            if (ifaceSb.length() > 0) {
                ifaceSb.append((Object)PhpElementImpl.SEPARATOR.COMMA);
            }
            ifaceSb.append(ifaceName.toString());
        }
        sb.append((CharSequence)ifaceSb);
        sb.append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        QualifiedName namespaceName = this.getNamespaceName();
        sb.append(namespaceName.toString()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        this.checkInterfaceSignature(sb);
        return sb.toString();
    }

    @Override
    public final PhpElementKind getPhpElementKind() {
        return InterfaceElement.KIND;
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        StringBuilder retval = new StringBuilder();
        switch (as) {
            case NameAndSuperTypes: {
                retval.append(this.getName());
            }
            case SuperTypes: {
                Set<QualifiedName> superIfaces = this.getSuperInterfaces();
                if (!superIfaces.isEmpty()) {
                    retval.append(" extends ");
                }
                StringBuilder ifacesBuffer = new StringBuilder();
                for (QualifiedName qualifiedName : superIfaces) {
                    if (ifacesBuffer.length() > 0) {
                        ifacesBuffer.append(", ");
                    }
                    ifacesBuffer.append(qualifiedName.getName());
                }
                retval.append((CharSequence)ifacesBuffer);
            }
        }
        return retval.toString();
    }

    private void checkInterfaceSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            InterfaceSignatureParser parser = new InterfaceSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getQualifiedName().toName().toString()));
            assert (this.getNamespaceName().equals(parser.getQualifiedName().toNamespaceName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getSuperInterfaces().size() == parser.getSuperInterfaces().size());
        }
    }

    private static class InterfaceSignatureParser {
        private final Signature signature;

        InterfaceSignatureParser(Signature signature) {
            this.signature = signature;
        }

        QualifiedName getQualifiedName() {
            return FullyQualifiedElementImpl.composeQualifiedName(this.signature.string(4), this.signature.string(1));
        }

        public Set<QualifiedName> getSuperInterfaces() {
            Set<QualifiedName> ifaces = Collections.emptySet();
            String separatedIfaces = this.signature.string(3);
            if (separatedIfaces != null && separatedIfaces.length() > 0) {
                String[] ifaceNames;
                ifaces = new HashSet<QualifiedName>();
                for (String ifName : ifaceNames = separatedIfaces.split(PhpElementImpl.SEPARATOR.COMMA.toString())) {
                    ifaces.add(QualifiedName.create(ifName));
                }
            }
            return ifaces;
        }

        int getOffset() {
            return this.signature.integer(2);
        }
    }
}

