/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.MutableTreeNode;
import org.netbeans.modules.php.editor.codegen.CGSGenerator;
import org.netbeans.modules.php.editor.codegen.CGSInfo;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.codegen.ui.CheckBoxTreeRenderer;
import org.netbeans.modules.php.editor.codegen.ui.CheckNode;
import org.netbeans.modules.php.editor.codegen.ui.NodeSelectionListener;
import org.openide.util.NbBundle;

public class ConstructorPanel
extends JPanel {
    protected final String className;
    protected final List<? extends Property> properties;
    protected final CGSInfo cgsInfo;
    private JCheckBox cbGenerateDoc;
    private JComboBox cbMethodGeneration;
    private JLabel jLabel1;
    private JLabel label;
    private JPanel pGSCustomize;
    private JScrollPane scrollPane;

    public ConstructorPanel(CGSGenerator.GenType genType, CGSInfo cgsInfo) {
        this.initComponents();
        this.className = cgsInfo.getClassName();
        switch (genType) {
            case CONSTRUCTOR: {
                this.properties = cgsInfo.getProperties();
                break;
            }
            case GETTER: {
                this.properties = cgsInfo.getPossibleGetters();
                break;
            }
            case SETTER: {
                this.properties = cgsInfo.getPossibleSetters();
                break;
            }
            case METHODS: {
                this.properties = cgsInfo.getPossibleMethods();
                break;
            }
            default: {
                this.properties = cgsInfo.getPossibleGettersSetters();
            }
        }
        this.cgsInfo = cgsInfo;
        this.initPanel(genType);
        this.initTree();
    }

    private void initPanel(CGSGenerator.GenType genType) {
        String panelTitle = "";
        boolean customizeMethodGeneration = true;
        String name = "";
        if (this.properties.size() > 0) {
            name = this.properties.get(0).getName();
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        switch (genType) {
            case CONSTRUCTOR: {
                panelTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_CONSTRUCTOR");
                customizeMethodGeneration = false;
                break;
            }
            case GETTER: {
                panelTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS");
                for (CGSGenerator.GenWay way : CGSGenerator.GenWay.values()) {
                    model.addElement(way.getGetterExample(name));
                }
                break;
            }
            case SETTER: {
                panelTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_SETTERS");
                for (CGSGenerator.GenWay way : CGSGenerator.GenWay.values()) {
                    model.addElement(way.getSetterExample(name));
                }
                break;
            }
            case GETTER_AND_SETTER: {
                panelTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS_AND_SETTERS");
                for (CGSGenerator.GenWay way : CGSGenerator.GenWay.values()) {
                    model.addElement(way.getGetterExample(name) + ", " + way.getSetterExample(name));
                }
                break;
            }
            case METHODS: {
                panelTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_METHODS");
                customizeMethodGeneration = false;
                Dimension preferredSize = this.getPreferredSize();
                this.setPreferredSize(new Dimension((int)(preferredSize.getWidth() * 1.3), (int)(preferredSize.getHeight() * 1.3)));
            }
        }
        this.label.setText(panelTitle);
        this.pGSCustomize.setVisible(customizeMethodGeneration);
        if (customizeMethodGeneration) {
            this.cbMethodGeneration.setModel(model);
            int index = 0;
            if (this.cgsInfo.getHowToGenerate() != null) {
                for (CGSGenerator.GenWay genWay : CGSGenerator.GenWay.values()) {
                    if (genWay.equals((Object)this.cgsInfo.getHowToGenerate())) break;
                    ++index;
                }
            }
            this.cbMethodGeneration.setSelectedIndex(index);
        }
        this.cbGenerateDoc.setSelected(this.cgsInfo.isGenerateDoc());
        this.cbGenerateDoc.setVisible(false);
    }

    private void initTree() {
        JTree tree = new JTree(this.getRootNode());
        tree.setCellRenderer(new CheckBoxTreeRenderer());
        tree.getSelectionModel().setSelectionMode(1);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        NodeSelectionListener listener = new NodeSelectionListener(tree);
        tree.addMouseListener(listener);
        tree.addKeyListener(listener);
        tree.expandRow(0);
        tree.setShowsRootHandles(true);
        tree.setSelectionRow(0);
        this.initTree(tree);
        this.scrollPane.add(tree);
        this.scrollPane.setViewportView(tree);
    }

    protected MutableTreeNode getRootNode() {
        CheckNode.CGSClassNode root = new CheckNode.CGSClassNode(this.className);
        for (Property property : this.properties) {
            root.add(new CheckNode.CGSPropertyNode(property));
        }
        return root;
    }

    protected void initTree(JTree tree) {
    }

    private void initComponents() {
        this.label = new JLabel();
        this.scrollPane = new JScrollPane();
        this.pGSCustomize = new JPanel();
        this.jLabel1 = new JLabel();
        this.cbMethodGeneration = new JComboBox();
        this.cbGenerateDoc = new JCheckBox();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return ConstructorPanel.this.cbGenerateDoc;
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return ConstructorPanel.this.cbGenerateDoc;
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return ConstructorPanel.this.cbGenerateDoc;
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                if (aComponent == ConstructorPanel.this.cbMethodGeneration) {
                    return ConstructorPanel.this.cbGenerateDoc;
                }
                return ConstructorPanel.this.cbGenerateDoc;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                if (aComponent == ConstructorPanel.this.cbGenerateDoc) {
                    return ConstructorPanel.this.cbMethodGeneration;
                }
                return ConstructorPanel.this.cbGenerateDoc;
            }
        });
        this.label.setDisplayedMnemonic('G');
        this.label.setLabelFor(this.scrollPane);
        this.label.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.label.text"));
        this.jLabel1.setDisplayedMnemonic('M');
        this.jLabel1.setLabelFor(this.cbMethodGeneration);
        this.jLabel1.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.jLabel1.text"));
        this.cbMethodGeneration.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbMethodGeneration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstructorPanel.this.cbMethodGenerationActionPerformed(evt);
            }
        });
        GroupLayout pGSCustomizeLayout = new GroupLayout(this.pGSCustomize);
        this.pGSCustomize.setLayout(pGSCustomizeLayout);
        pGSCustomizeLayout.setHorizontalGroup(pGSCustomizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGSCustomizeLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbMethodGeneration, 0, 247, Short.MAX_VALUE).addContainerGap()));
        pGSCustomizeLayout.setVerticalGroup(pGSCustomizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pGSCustomizeLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(pGSCustomizeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbMethodGeneration, -2, -1, -2)).addGap(65, 65, 65)));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.jLabel1.AccessibleContext.accessibleName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.jLabel1.AccessibleContext.accessibleDescription"));
        this.cbMethodGeneration.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbMethodGeneration.AccessibleContext.accessibleName"));
        this.cbMethodGeneration.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbMethodGeneration.AccessibleContext.accessibleDescription"));
        this.cbGenerateDoc.setMnemonic('e');
        this.cbGenerateDoc.setText(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbGenerateDoc.text"));
        this.cbGenerateDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstructorPanel.this.cbGenerateDocActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollPane, GroupLayout.Alignment.LEADING, -1, 376, Short.MAX_VALUE).addComponent(this.label, GroupLayout.Alignment.LEADING).addComponent(this.cbGenerateDoc, GroupLayout.Alignment.LEADING, -1, 376, Short.MAX_VALUE).addComponent(this.pGSCustomize, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 226, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pGSCustomize, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbGenerateDoc).addContainerGap()));
        this.label.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.label.AccessibleContext.accessibleName"));
        this.label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.label.AccessibleContext.accessibleDescription"));
        this.scrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.scrollPane.AccessibleContext.accessibleName"));
        this.scrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.scrollPane.AccessibleContext.accessibleDescription"));
        this.pGSCustomize.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.pGSCustomize.AccessibleContext.accessibleName"));
        this.pGSCustomize.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.pGSCustomize.AccessibleContext.accessibleDescription"));
        this.cbGenerateDoc.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbGenerateDoc.AccessibleContext.accessibleName"));
        this.cbGenerateDoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.cbGenerateDoc.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConstructorPanel.class, (String)"ConstructorPanel.AccessibleContext.accessibleDescription"));
    }

    private void cbMethodGenerationActionPerformed(ActionEvent evt) {
        int selectedIndex = this.cbMethodGeneration.getSelectedIndex();
        this.cgsInfo.setHowToGenerate(CGSGenerator.GenWay.values()[selectedIndex]);
    }

    private void cbGenerateDocActionPerformed(ActionEvent evt) {
        this.cgsInfo.setGenerateDoc(this.cbGenerateDoc.isSelected());
    }
}

