/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;

final class ButtonPopupSwitcher
implements MouseInputListener,
AWTEventListener {
    private static Popup popup;
    private Component invokingComponent = null;
    private long invocationTime = -1L;
    private static boolean shown;
    private static ButtonPopupSwitcher currentSwitcher;
    private SwitcherTable pTable;
    private int x;
    private int y;
    private boolean isDragging = true;

    public static void selectItem(JComponent owner, SwitcherTableItem[] items, int x, int y) {
        ButtonPopupSwitcher switcher = new ButtonPopupSwitcher(items, x, y);
        switcher.doSelect(owner);
        currentSwitcher = switcher;
    }

    private ButtonPopupSwitcher(SwitcherTableItem[] items, int x, int y) {
        this.pTable = new SwitcherTable(items, y);
        this.x = x - (int)this.pTable.getPreferredSize().getWidth();
        this.y = y + 1;
    }

    private void doSelect(JComponent owner) {
        this.invokingComponent = owner;
        this.invokingComponent.addMouseListener(this);
        this.invokingComponent.addMouseMotionListener(this);
        this.pTable.addMouseListener(this);
        this.pTable.addMouseMotionListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        popup = PopupFactory.getSharedInstance().getPopup(this.invokingComponent, this.pTable, this.x, this.y);
        popup.show();
        shown = true;
        this.invocationTime = System.currentTimeMillis();
    }

    public static boolean isShown() {
        return shown;
    }

    static void hidePopup() {
        if (ButtonPopupSwitcher.isShown()) {
            currentSwitcher.hideCurrentPopup();
        }
    }

    private synchronized void hideCurrentPopup() {
        this.pTable.removeMouseListener(this);
        this.pTable.removeMouseMotionListener(this);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.invokingComponent != null) {
            this.invokingComponent.removeMouseListener(this);
            this.invokingComponent.removeMouseMotionListener(this);
            this.invokingComponent = null;
        }
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
            popup = null;
            shown = false;
            currentSwitcher = null;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        e.consume();
        this.changeSelection(e);
        this.isDragging = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        long time;
        if (e.getSource() == this.invokingComponent && (time = System.currentTimeMillis()) - this.invocationTime > 500L && this.isDragging) {
            this.mouseClicked(e);
        }
        this.isDragging = false;
        e.consume();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        SwitcherTableItem item;
        Point p = e.getPoint();
        p = SwingUtilities.convertPoint((Component)e.getSource(), p, this.pTable);
        if (this.pTable.contains(p) && (item = this.pTable.getSelectedItem()) != null) {
            item.activate();
            this.hideCurrentPopup();
        }
        this.isDragging = false;
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseDragged(e);
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.pTable.clearSelection();
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.changeSelection(e);
        e.consume();
    }

    private void changeSelection(MouseEvent e) {
        Point p = e.getPoint();
        if (e.getSource() != this) {
            p = SwingUtilities.convertPoint((Component)e.getSource(), p, this.pTable);
        }
        if (this.pTable.contains(p)) {
            int row = this.pTable.rowAtPoint(p);
            int col = this.pTable.columnAtPoint(p);
            this.pTable.changeSelection(row, col, false, false);
        } else {
            this.pTable.clearSelection();
        }
    }

    private boolean onSwitcherTable(MouseEvent e) {
        Point p = e.getPoint();
        if (!(e.getSource() instanceof Component)) {
            return false;
        }
        p = SwingUtilities.convertPoint((Component)e.getSource(), p, this.pTable);
        return this.pTable.contains(p);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getSource() == this) {
            return;
        }
        if (event instanceof MouseEvent) {
            if (event.getID() == 502) {
                long time = System.currentTimeMillis();
                if (time - this.invocationTime > 500L && !this.onSwitcherTable((MouseEvent)event) && event.getSource() != this.invokingComponent) {
                    this.hideCurrentPopup();
                }
            } else if (event.getID() == 501 && !this.onSwitcherTable((MouseEvent)event) && event.getSource() != this.invokingComponent) {
                this.hideCurrentPopup();
            }
        } else if (event instanceof KeyEvent && event.getID() == 401) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.hideCurrentPopup();
        }
    }

    private class PopupHider
    implements Runnable {
        private Popup toHide;

        public PopupHider(Popup popup) {
            this.toHide = popup;
        }

        @Override
        public void run() {
            this.toHide.hide();
            this.toHide = null;
        }
    }
}

