/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.modules.profiler.selector.spi.nodes.ConstructorsNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.InnerClassesNode;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;

public abstract class ClassNode
extends ContainerNode {
    private boolean anonymous;
    public static final Comparator COMPARATOR = new Comparator<ClassNode>(){

        @Override
        public int compare(ClassNode o1, ClassNode o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };

    public ClassNode(String className, String displayName, Icon icon, boolean isAnonymous, ContainerNode parent) {
        super(className, displayName, icon, parent);
        this.anonymous = isAnonymous;
    }

    public ClassNode(String className, String displayName, boolean isAnonymous, ContainerNode parent) {
        super(className, displayName, (Icon)IconResource.CLASS_ICON, parent);
        this.anonymous = isAnonymous;
    }

    @Override
    protected final SelectorChildren getChildren() {
        return new ClassChildren();
    }

    public final boolean isAnonymous() {
        return this.anonymous;
    }

    protected abstract ConstructorsNode getConstructorsNode();

    protected abstract MethodsNode getMethodsNode();

    protected abstract InnerClassesNode getInnerClassesNode();

    private static class ClassChildren
    extends SelectorChildren<ClassNode> {
        private ClassChildren() {
        }

        @Override
        protected List<SelectorNode> prepareChildren(ClassNode parent) {
            ArrayList<SelectorNode> contents = new ArrayList<SelectorNode>();
            ContainerNode content = null;
            if (!parent.isAnonymous() && (content = parent.getConstructorsNode()) != null && !content.isLeaf()) {
                contents.add(content);
            }
            if ((content = parent.getMethodsNode()) != null && !content.isLeaf()) {
                contents.add(content);
            }
            if ((content = parent.getInnerClassesNode()) != null && !content.isLeaf()) {
                contents.add(content);
            }
            return contents;
        }
    }
}

