/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.navigation.ClassMemberFilters;
import org.netbeans.modules.csl.navigation.ElementNode;
import org.netbeans.modules.csl.navigation.ElementScanningTask;
import org.netbeans.modules.csl.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.csl.navigation.actions.SortActionSupport;
import org.netbeans.modules.csl.navigation.base.FiltersManager;
import org.netbeans.modules.csl.navigation.base.TapPanel;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassMemberPanelUI
extends JPanel
implements ExplorerManager.Provider,
FiltersManager.FilterChangeListener {
    private ExplorerManager manager = new ExplorerManager();
    private MyBeanTreeView elementView;
    private TapPanel filtersPanel;
    private JLabel filtersLbl;
    private Lookup lookup = null;
    private ClassMemberFilters filters;
    private Action[] actions;

    public ClassMemberPanelUI(Language language) {
        StructureScanner scanner;
        StructureScanner.Configuration configuration;
        this.initComponents();
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.filtersPanel = new TapPanel();
        this.filtersLbl = new JLabel(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"LBL_Filter"));
        this.filtersLbl.setBorder(new EmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(this.filtersLbl);
        this.filtersPanel.setOrientation(2);
        KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String keyText = Utilities.keyToString((KeyStroke)toggleKey);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"TIP_TapPanel", (Object)keyText));
        this.filters = new ClassMemberFilters(this);
        this.filters.getInstance().hookChangeListener(this);
        this.filtersPanel.add(this.filters.getComponent());
        this.actions = new Action[]{new SortActionSupport.SortByNameAction(this.filters), new SortActionSupport.SortBySourceAction(this.filters), null, new FilterSubmenuAction(this.filters.getInstance())};
        boolean includeFilters = true;
        if (language != null && language.getStructure() != null && (configuration = (scanner = language.getStructure()).getConfiguration()) != null && !(includeFilters = configuration.isFilterable())) {
            this.filters.disableFiltering = true;
        }
        if (includeFilters) {
            this.add((Component)this.filtersPanel, "South");
        }
        this.manager.setRootContext(ElementNode.getWaitNode());
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return result;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ElementScanningTask getTask() {
        return new ElementScanningTask(this);
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassMemberPanelUI.this.elementView.setRootVisible(true);
                ClassMemberPanelUI.this.manager.setRootContext(ElementNode.getWaitNode());
            }
        });
    }

    public void selectElementNode(final ParserResult info, final int offset) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementNode root = ClassMemberPanelUI.this.getRootNode();
                if (root == null) {
                    return;
                }
                ElementNode node = root.getMimeRootNodeForOffset(info, offset);
                Node[] selectedNodes = ClassMemberPanelUI.this.manager.getSelectedNodes();
                if (selectedNodes == null || selectedNodes.length != 1 || selectedNodes[0] != node) {
                    try {
                        ClassMemberPanelUI.this.manager.setSelectedNodes(new Node[]{node == null ? ClassMemberPanelUI.this.getRootNode() : node});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        Exceptions.printStackTrace((Throwable)propertyVetoException);
                    }
                }
            }
        });
    }

    public void refresh(final StructureItem description, final FileObject fileObject) {
        final ElementNode rootNode = this.getRootNode();
        if (rootNode != null && rootNode.getFileObject().equals(fileObject)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    long startTime = System.currentTimeMillis();
                    rootNode.updateRecursively(description);
                    long endTime = System.currentTimeMillis();
                    Logger.getLogger("TIMER").log(Level.FINE, "Navigator Merge", new Object[]{fileObject, endTime - startTime});
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StructureScanner scanner;
                    StructureScanner.Configuration configuration;
                    long startTime = System.currentTimeMillis();
                    ClassMemberPanelUI.this.elementView.setRootVisible(false);
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(false);
                    ClassMemberPanelUI.this.manager.setRootContext((Node)new ElementNode(description, ClassMemberPanelUI.this, fileObject));
                    boolean expand = true;
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(fileObject.getMIMEType());
                    if (language != null && language.getStructure() != null && (configuration = (scanner = language.getStructure()).getConfiguration()) != null) {
                        boolean bl = expand = configuration.getExpandDepth() != 0;
                    }
                    if (expand) {
                        boolean scrollOnExpand = ClassMemberPanelUI.this.elementView.getScrollOnExpand();
                        ClassMemberPanelUI.this.elementView.setScrollOnExpand(false);
                        ClassMemberPanelUI.this.elementView.expandAll();
                        ClassMemberPanelUI.this.elementView.setScrollOnExpand(scrollOnExpand);
                    } else {
                        Node[] nodes;
                        for (Node node : nodes = ClassMemberPanelUI.this.manager.getRootContext().getChildren().getNodes()) {
                            ClassMemberPanelUI.this.elementView.expandNode(node);
                        }
                    }
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(true);
                    long endTime = System.currentTimeMillis();
                    Logger.getLogger("TIMER").log(Level.FINE, "Navigator Initialization", new Object[]{fileObject, endTime - startTime});
                }
            });
        }
    }

    public void sort() {
        this.getRootNode().refreshRecursively();
    }

    public ClassMemberFilters getFilters() {
        return this.filters;
    }

    public void expandNode(Node n) {
        this.elementView.expandNode(n);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        return this.getRootNode().getFileObject();
    }

    @Override
    public void filterStateChanged(ChangeEvent e) {
        ElementNode root = this.getRootNode();
        if (root != null) {
            root.refreshRecursively();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private ElementNode getRootNode() {
        Node n = this.manager.getRootContext();
        if (n instanceof ElementNode) {
            return (ElementNode)n;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        MyBeanTreeView btv = new MyBeanTreeView();
        return btv;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private static class MyBeanTreeView
    extends BeanTreeView {
        private MyBeanTreeView() {
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean scroll) {
            this.tree.setScrollsOnExpand(scroll);
        }
    }
}

