/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.TestHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizerHandler;

public class RspecHandlerFactory
implements TestHandlerFactory {
    @Override
    public boolean printSummary() {
        return false;
    }

    @Override
    public List<TestRecognizerHandler> createHandlers() {
        ArrayList<TestRecognizerHandler> result = new ArrayList<TestRecognizerHandler>();
        result.add(new SuiteStartingHandler());
        result.add(new SuiteStartedHandler());
        result.add(new SuiteFinishedHandler());
        result.add(new TestStartedHandler());
        result.add(new TestFailedHandler());
        result.add(new TestPendingHandler());
        result.add(new TestFinishedHandler());
        result.add(new StackTraceFilterHandler());
        return result;
    }

    static class StackTraceFilterHandler
    extends TestRecognizerHandler {
        public StackTraceFilterHandler() {
            super(".*nb_rspec_mediator.rb.*");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
        }
    }

    static class SuiteStartingHandler
    extends TestRecognizerHandler {
        private boolean firstSuite = true;

        public SuiteStartingHandler() {
            super(".*%RSPEC_SUITE_STARTING%\\s(.+)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            if (this.firstSuite) {
                this.firstSuite = false;
                manager.testStarted(session);
            }
            String suiteName = this.matcher.group(1);
            session.addSuite(new TestSuite(suiteName));
            manager.displaySuiteRunning(session, suiteName);
        }
    }

    static class SuiteStartedHandler
    extends TestRecognizerHandler {
        public SuiteStartedHandler() {
            super(".*%RSPEC_SUITE_STARTED%\\s.*");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
        }
    }

    static class SuiteFinishedHandler
    extends TestRecognizerHandler {
        public SuiteFinishedHandler() {
            super(".*%RSPEC_SUITE_FINISHED%\\s(.+)\\stime=(.+)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            manager.displayReport(session, session.getReport((long)SuiteFinishedHandler.toMillis(this.matcher.group(2))));
        }
    }

    static class TestPendingHandler
    extends TestRecognizerHandler {
        public TestPendingHandler() {
            super(".*%RSPEC_TEST_PENDING%\\sfile=(.*)\\sdescription=(.*)\\stime=(.+)\\smessage=(.*)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.RSPEC.name(), session);
            testcase.setTimeMillis((long)TestPendingHandler.toMillis(this.matcher.group(3)));
            testcase.setClassName(session.getCurrentSuite().getName());
            String location = this.matcher.group(1);
            if (location != null && !"".equals(location)) {
                testcase.setLocation(this.matcher.group(1));
            }
            testcase.setTrouble(new Trouble(false));
            testcase.getTrouble().setStackTrace(new String[]{this.matcher.group(4)});
            testcase.setStatus(Status.PENDING);
            session.addTestCase(testcase);
        }
    }

    static class TestFinishedHandler
    extends TestRecognizerHandler {
        public TestFinishedHandler() {
            super(".*%RSPEC_TEST_FINISHED%\\sfile=(.*)\\sdescription=(.*)\\stime=(.+)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.RSPEC.name(), session);
            testcase.setTimeMillis((long)TestFinishedHandler.toMillis(this.matcher.group(3)));
            testcase.setClassName(session.getCurrentSuite().getName());
            String location = this.matcher.group(1);
            if (location != null && !"".equals(location)) {
                testcase.setLocation(this.matcher.group(1));
            }
            session.addTestCase(testcase);
        }
    }

    static class TestStartedHandler
    extends TestRecognizerHandler {
        public TestStartedHandler() {
            super(".*%RSPEC_TEST_STARTED%\\s(.*)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
        }
    }

    static class TestFailedHandler
    extends TestRecognizerHandler {
        public TestFailedHandler() {
            super(".*%RSPEC_TEST_FAILED%\\sfile=(.*)\\sdescription=(.*)\\stime=(\\d+\\.\\d+)\\smessage=(.*)\\slocation=(.*)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.RSPEC.name(), session);
            String location = this.matcher.group(1);
            String failureLocation = this.matcher.group(5);
            if (!TestFailedHandler.isEmpty(location)) {
                testcase.setLocation(location);
            } else if (!TestFailedHandler.isEmpty(failureLocation)) {
                testcase.setLocation(failureLocation);
            }
            testcase.setTimeMillis((long)TestFailedHandler.toMillis(this.matcher.group(3)));
            testcase.setClassName(this.matcher.group(2));
            testcase.setTrouble(new Trouble(false));
            testcase.getTrouble().setComparisonFailure(TestFailedHandler.getComparisonFailure(this.matcher.group(4)));
            testcase.getTrouble().setStackTrace(this.filterStackTrace(this.matcher.group(4), this.matcher.group(5)));
            session.addTestCase(testcase);
            for (String line : testcase.getTrouble().getStackTrace()) {
                manager.displayOutput(session, line, false);
            }
            testcase.addOutputLines(this.getRecognizedOutput());
        }

        @Override
        List<String> getRecognizedOutput() {
            ArrayList<String> result = new ArrayList<String>(2);
            result.add(this.matcher.group(3));
            result.add(this.matcher.group(4));
            return result;
        }

        private String[] filterStackTrace(String ... stackTrace) {
            ArrayList<String> result = new ArrayList<String>();
            for (String location : stackTrace) {
                if (TestRunnerUtilities.filterOutFromStacktrace(location)) continue;
                result.add(location);
            }
            return result.toArray(new String[result.size()]);
        }
    }
}

