/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public final class IncludeDirEntry {
    private static final int MANAGER_DEFAULT_CAPACITY;
    private static final int MANAGER_DEFAULT_SLICED_NUMBER;
    private static final IncludeDirStorage storage;
    private final File file;
    private final boolean exists;
    private final boolean isFramework;
    private final CharSequence asCharSeq;

    private IncludeDirEntry(File file, boolean exists, boolean framework, CharSequence asCharSeq) {
        this.file = file;
        this.exists = exists;
        this.isFramework = framework;
        this.asCharSeq = asCharSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncludeDirEntry get(String dir) {
        Map delegate;
        CharSequence key = FilePathCache.getManager().getString((CharSequence)dir);
        Map map = delegate = IncludeDirEntry.storage.getDelegate(key);
        synchronized (map) {
            IncludeDirEntry out = (IncludeDirEntry)delegate.get(key);
            if (out == null) {
                File file = new File(dir);
                String asString = file.getAbsolutePath();
                boolean framework = asString.endsWith("/Frameworks");
                CharSequence asCharSeq = FilePathCache.getManager().getString((CharSequence)asString);
                boolean exists = CndFileUtils.isExistingDirectory((File)file, (String)asString);
                out = new IncludeDirEntry(file, exists, framework, asCharSeq);
                delegate.put(key, out);
            }
            return out;
        }
    }

    public CharSequence getAsSharedCharSequence() {
        return this.asCharSeq;
    }

    public boolean isFramework() {
        return this.isFramework;
    }

    public boolean isExistingDirectory() {
        return this.exists;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return (this.exists ? "" : "NOT EXISTING ") + this.asCharSeq;
    }

    public String getAsString() {
        return this.file.getPath();
    }

    static void disposeCache() {
        storage.dispose();
    }

    static {
        int nrProc = CndUtils.getConcurrencyLevel();
        if (nrProc <= 4) {
            MANAGER_DEFAULT_SLICED_NUMBER = 32;
            MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            MANAGER_DEFAULT_SLICED_NUMBER = 128;
            MANAGER_DEFAULT_CAPACITY = 128;
        }
        storage = new IncludeDirStorage(MANAGER_DEFAULT_SLICED_NUMBER, MANAGER_DEFAULT_CAPACITY);
    }

    private static final class IncludeDirStorage {
        private final WeakHashMap<CharSequence, IncludeDirEntry>[] instances;
        private final int segmentMask;

        private IncludeDirStorage(int sliceNumber, int initialCapacity) {
            int ssize;
            for (ssize = 1; ssize < sliceNumber; ssize <<= 1) {
            }
            this.segmentMask = ssize - 1;
            WeakHashMap[] ar = new WeakHashMap[ssize];
            for (int i = 0; i < ar.length; ++i) {
                ar[i] = new WeakHashMap(initialCapacity);
            }
            this.instances = ar;
        }

        private Map<CharSequence, IncludeDirEntry> getDelegate(CharSequence key) {
            int index = key.hashCode() & this.segmentMask;
            return this.instances[index];
        }

        public final IncludeDirEntry getSharedUID(CharSequence key) {
            return this.getDelegate(key).get(key);
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i].size() <= 0) continue;
                if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                    System.out.println("Include Dir Cache " + this.instances[i].size());
                    HashMap<Class, Integer> keyClasses = new HashMap<Class, Integer>();
                    for (CharSequence charSequence : this.instances[i].keySet()) {
                        if (charSequence == null) continue;
                        this.incCounter(keyClasses, charSequence);
                    }
                    for (Map.Entry entry : keyClasses.entrySet()) {
                        System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                    }
                }
                this.instances[i].clear();
            }
        }

        private void incCounter(Map<Class, Integer> uidClasses, Object o) {
            Integer num = uidClasses.get(o.getClass());
            num = num != null ? Integer.valueOf(num + 1) : Integer.valueOf(1);
            uidClasses.put(o.getClass(), num);
        }
    }
}

