/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

public class InstrumentationFilter
implements Cloneable {
    public static final int INSTR_FILTER_NONE = 0;
    public static final int INSTR_FILTER_EXCLUSIVE = 10;
    public static final int INSTR_FILTER_INCLUSIVE = 20;
    private static InstrumentationFilter defaultInstance;
    private String[] instrFilterStrings;
    private int instrFilterType;

    public InstrumentationFilter() {
        this.clearFilter();
    }

    public static InstrumentationFilter getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new InstrumentationFilter();
        }
        return defaultInstance;
    }

    public void setFilterStrings(String flatFilterString) {
        flatFilterString = flatFilterString.replace(',', ' ');
        flatFilterString = flatFilterString.replace('.', '/');
        this.setSlashedFilterStrings(flatFilterString.trim().split(" +"));
    }

    public String[] getFilterStrings() {
        return this.instrFilterStrings;
    }

    public void setFilterType(int filterType) {
        this.instrFilterType = filterType;
    }

    public int getFilterType() {
        return this.instrFilterType;
    }

    public void setSlashedFilterStrings(String[] slashedFilterStrings) {
        this.instrFilterStrings = slashedFilterStrings;
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            String instrFilterString = this.instrFilterStrings[i];
            if (!instrFilterString.endsWith("*")) continue;
            this.instrFilterStrings[i] = instrFilterString.substring(0, instrFilterString.length() - 1);
        }
    }

    public void clearFilter() {
        this.instrFilterType = 0;
        this.instrFilterStrings = new String[0];
    }

    public Object clone() throws CloneNotSupportedException {
        InstrumentationFilter clone = (InstrumentationFilter)super.clone();
        clone.instrFilterStrings = new String[this.instrFilterStrings.length];
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            clone.instrFilterStrings[i] = this.instrFilterStrings[i];
        }
        return clone;
    }

    public String debug() {
        StringBuffer filterStringsBuffer = new StringBuffer();
        switch (this.instrFilterType) {
            case 0: {
                filterStringsBuffer.append("  Filter type: None\n");
                break;
            }
            case 10: {
                filterStringsBuffer.append("  Filter type: Exclusive\n");
                break;
            }
            case 20: {
                filterStringsBuffer.append("  Filter type: Inclusive\n");
            }
        }
        filterStringsBuffer.append("  Filter value: ");
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            filterStringsBuffer.append(this.instrFilterStrings[i]);
            filterStringsBuffer.append(" ");
        }
        filterStringsBuffer.append("\n");
        return filterStringsBuffer.toString();
    }

    public void debugDump() {
        System.err.println("----------------------------------");
        System.err.println("Instrumentation filter debug dump:");
        switch (this.instrFilterType) {
            case 0: {
                System.err.println("  Filter type: None");
                break;
            }
            case 10: {
                System.err.println("  Filter type: Exclusive");
                break;
            }
            case 20: {
                System.err.println("  Filter type: Inclusive");
            }
        }
        StringBuffer filterStringsBuffer = new StringBuffer();
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            filterStringsBuffer.append(this.instrFilterStrings[i]);
            filterStringsBuffer.append(" ");
        }
        System.err.println("  Filter strings: " + filterStringsBuffer.toString());
    }

    public boolean passesFilter(String string) {
        boolean filterInclusive;
        if (this.instrFilterType == 0) {
            return true;
        }
        if (this.instrFilterStrings.length == 0) {
            return true;
        }
        boolean bl = filterInclusive = this.instrFilterType == 20;
        if (filterInclusive) {
            for (int i = 0; i < this.instrFilterStrings.length; ++i) {
                if (!InstrumentationFilter.matches(string, this.instrFilterStrings[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.instrFilterStrings.length; ++i) {
                if (!InstrumentationFilter.matches(string, this.instrFilterStrings[i])) continue;
                return false;
            }
        }
        return !filterInclusive;
    }

    private static boolean matches(String string, String filter) {
        return string.startsWith(filter);
    }
}

