/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.refactoring.ruby.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.ruby.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyStructureAnalyzer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    private static final Logger LOG = Logger.getLogger(RefactoringActionsProvider.class.getName());
    private static boolean isFindUsages;

    public void doRename(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        UserTask task = RefactoringActionsProvider.isFromEditor(ec) ? new TextComponentTask(ec){

            @Override
            protected RefactoringUI createRefactoringUI(RubyElementCtx selectedElement, int startOffset, int endOffset, ParserResult parserResult) {
                return new RenameRefactoringUI(selectedElement, parserResult);
            }
        } : new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<RubyElementCtx> handles) {
                String newName = RefactoringActionsProvider.getName(dictionary);
                if (newName != null) {
                    if (this.pkg[0] != null) {
                        return new RenameRefactoringUI(this.pkg[0], newName);
                    }
                    return new RenameRefactoringUI(selectedElements[0], newName, handles == null || handles.isEmpty() ? null : handles.iterator().next(), this.cinfo == null ? null : (ParserResult)this.cinfo.get());
                }
                if (this.pkg[0] != null) {
                    return new RenameRefactoringUI(this.pkg[0]);
                }
                return new RenameRefactoringUI(selectedElements[0], handles == null || handles.isEmpty() ? null : handles.iterator().next(), this.cinfo == null ? null : (ParserResult)this.cinfo.get());
            }
        };
        task.run();
    }

    public boolean canRename(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        if (this.isOutsideRuby(lookup, fo)) {
            return false;
        }
        return RetoucheUtils.isRefactorable(fo);
    }

    public boolean canCopy(Lookup lookup) {
        return false;
    }

    private boolean isOutsideRuby(Lookup lookup, FileObject fo) {
        EditorCookie ec;
        if (RubyUtils.isRhtmlOrYamlFile((FileObject)fo) && RefactoringActionsProvider.isFromEditor(ec = (EditorCookie)lookup.lookup(EditorCookie.class))) {
            JEditorPane textC = ec.getOpenedPanes()[0];
            Document d = textC.getDocument();
            if (!(d instanceof BaseDocument)) {
                return true;
            }
            int caret = textC.getCaretPosition();
            if (LexUtilities.getToken((BaseDocument)((BaseDocument)d), (int)caret) == null) {
                return true;
            }
        }
        return false;
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        if (this.isOutsideRuby(lookup, fo)) {
            return false;
        }
        return dob != null && RubyUtils.canContainRuby((FileObject)fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        UserTask task = RefactoringActionsProvider.isFromEditor(ec) ? new TextComponentTask(ec){

            @Override
            protected RefactoringUI createRefactoringUI(RubyElementCtx selectedElement, int startOffset, int endOffset, ParserResult parserResult) {
                return new WhereUsedQueryUI(selectedElement, parserResult);
            }
        } : new NodeToElementTask(lookup.lookupAll(Node.class)){

            @Override
            protected RefactoringUI createRefactoringUI(RubyElementCtx selectedElement, ParserResult parserResult) {
                return new WhereUsedQueryUI(selectedElement, parserResult);
            }
        };
        try {
            isFindUsages = true;
            task.run();
        }
        finally {
            isFindUsages = false;
        }
    }

    public boolean canDelete(Lookup lookup) {
        return false;
    }

    static String getName(Dictionary dict) {
        if (dict == null) {
            return null;
        }
        return (String)dict.get("name");
    }

    public boolean canMove(Lookup lookup) {
        return false;
    }

    public void doMove(Lookup lookup) {
    }

    static boolean isFromEditor(EditorCookie ec) {
        return ec != null && ec.getOpenedPanes() != null;
    }

    public static abstract class NodeToFileObjectTask
    extends UserTask
    implements Runnable {
        private final Collection<? extends Node> nodes;
        public final NonRecursiveFolder[] pkg;
        public WeakReference<ParserResult> cinfo;
        Collection<RubyElementCtx> handles = new ArrayList<RubyElementCtx>();

        public NodeToFileObjectTask(Collection<? extends Node> nodes) {
            assert (nodes != null);
            this.nodes = nodes;
            this.pkg = new NonRecursiveFolder[nodes.size()];
        }

        public void cancel() {
        }

        public void run(ResultIterator ri) throws ParseException {
            if (ri.getSnapshot().getMimeType().equals("text/x-ruby")) {
                RubyStructureAnalyzer.AnalysisResult ar;
                List els;
                RubyParseResult parserResult = AstUtilities.getParseResult((Parser.Result)ri.getParserResult());
                org.jrubyparser.ast.Node root = AstUtilities.getRoot((Parser.Result)parserResult);
                if (root != null && parserResult != null && (els = (ar = parserResult.getStructure()).getElements()).size() > 0) {
                    AstElement element = (AstElement)els.get(0);
                    org.jrubyparser.ast.Node node = element.getNode();
                    RubyElementCtx representedObject = new RubyElementCtx(root, node, (Element)element, RubyUtils.getFileObject((Parser.Result)parserResult), (ParserResult)parserResult);
                    representedObject.setNames(element.getFqn(), element.getName());
                    this.handles.add(representedObject);
                }
                this.cinfo = new WeakReference<RubyParseResult>(parserResult);
            }
        }

        @Override
        public void run() {
            FileObject[] fobs = new FileObject[this.nodes.size()];
            int i = 0;
            for (Node node : this.nodes) {
                DataObject dob = (DataObject)node.getCookie(DataObject.class);
                if (dob == null) continue;
                fobs[i] = dob.getPrimaryFile();
                Source source = Source.create((FileObject)fobs[i]);
                try {
                    ParserManager.parse(Collections.singleton(source), (UserTask)this);
                }
                catch (ParseException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
                this.pkg[i++] = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(fobs, this.handles));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1, Collection<RubyElementCtx> var2);
    }

    public static abstract class NodeToElementTask
    extends UserTask
    implements Runnable {
        private final Node node;
        private RefactoringUI ui;

        public NodeToElementTask(Collection<? extends Node> nodes) {
            assert (nodes.size() == 1);
            this.node = nodes.iterator().next();
        }

        public void run(ResultIterator ri) throws ParseException {
            if (ri.getSnapshot().getMimeType().equals("text/x-ruby")) {
                RubyParseResult parserResult = AstUtilities.getParseResult((Parser.Result)ri.getParserResult());
                org.jrubyparser.ast.Node root = AstUtilities.getRoot((Parser.Result)parserResult);
                if (root != null) {
                    AstElement element = AstElement.create((ParserResult)parserResult, (org.jrubyparser.ast.Node)root);
                    RubyElementCtx fileCtx = new RubyElementCtx(root, root, (Element)element, RubyUtils.getFileObject((Parser.Result)parserResult), (ParserResult)parserResult);
                    this.ui = this.createRefactoringUI(fileCtx, (ParserResult)parserResult);
                }
            } else {
                for (Embedding e : ri.getEmbeddings()) {
                    this.run(ri.getResultIterator(e));
                }
            }
        }

        @Override
        public final void run() {
            try {
                DataObject o = (DataObject)this.node.getCookie(DataObject.class);
                Source source = Source.create((FileObject)o.getPrimaryFile());
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
                return;
            }
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui);
            } else {
                String key = "ERR_CannotRenameLoc";
                if (isFindUsages) {
                    key = "ERR_CannotFindUsages";
                }
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)key));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(RubyElementCtx var1, ParserResult var2);
    }

    public static abstract class TextComponentTask
    extends UserTask
    implements Runnable {
        private final JTextComponent textC;
        private final int caret;
        private final int start;
        private final int end;
        private RefactoringUI ui;

        public TextComponentTask(EditorCookie ec) {
            this.textC = ec.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public void run(ResultIterator ri) throws Exception {
            if (ri.getSnapshot().getMimeType().equals("text/x-ruby")) {
                RubyParseResult parserResult = AstUtilities.getParseResult((Parser.Result)ri.getParserResult());
                org.jrubyparser.ast.Node root = AstUtilities.getRoot((Parser.Result)parserResult);
                if (root != null) {
                    RubyElementCtx ctx = new RubyElementCtx((ParserResult)parserResult, this.caret);
                    if (ctx.getSimpleName() != null) {
                        this.ui = this.createRefactoringUI(ctx, this.start, this.end, (ParserResult)parserResult);
                    }
                } else {
                    System.out.println("FAILURE - can't refactor uncompileable sources");
                }
            } else {
                for (Embedding e : ri.getEmbeddings()) {
                    this.run(ri.getResultIterator(e));
                }
            }
        }

        @Override
        public final void run() {
            try {
                Source source = Source.create((Document)this.textC.getDocument());
                ParserManager.parse(Collections.singleton(source), (UserTask)this);
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
                return;
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)activetc);
            } else {
                String key = "ERR_CannotRenameLoc";
                if (isFindUsages) {
                    key = "ERR_CannotFindUsages";
                }
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)key));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(RubyElementCtx var1, int var2, int var3, ParserResult var4);
    }
}

