/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.actions.GrailsCommandAction;
import org.netbeans.modules.groovy.grailsproject.actions.ManagePluginsAction;
import org.netbeans.modules.groovy.grailsproject.actions.ResolvePluginsAction;
import org.netbeans.modules.groovy.grailsproject.ui.TreeRootNode;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class GrailsLogicalViewProvider
implements LogicalViewProvider {
    private final GrailsProject project;
    GrailsLogicalViewRootNode rootNode = null;

    public GrailsLogicalViewProvider(GrailsProject grailsProject) {
        this.project = grailsProject;
    }

    public Node createLogicalView() {
        if (this.rootNode == null) {
            this.rootNode = new GrailsLogicalViewRootNode();
        }
        return this.rootNode;
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            for (Node node2 : node.getChildren().getNodes(true)) {
                Node node3 = TreeRootNode.findPath(node2, object);
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    private final class GrailsLogicalViewRootNode
    extends AbstractNode {
        public GrailsLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)GrailsLogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-groovy-grailsproject/Nodes"), Lookups.singleton((Object)GrailsLogicalViewProvider.this.project));
            String string = "";
            if (!Utilities.isWindows()) {
                string = File.separator;
            }
            this.setShortDescription("Grails Project in " + string + GrailsLogicalViewProvider.this.project.getProjectDirectory().getPath());
        }

        public Image getIcon(int n) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/groovy/grails/resources/GrailsIcon16x16.png");
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            return GrailsLogicalViewProvider.this.project.getProjectDirectory().getName();
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        private Action[] getAdditionalActions() {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage(GrailsLogicalViewProvider.class, (String)"LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"compile", (String)NbBundle.getMessage(GrailsLogicalViewProvider.class, (String)"LBL_Compile_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage(GrailsLogicalViewProvider.class, (String)"LBL_CleanAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"upgrade", (String)NbBundle.getMessage(GrailsLogicalViewProvider.class, (String)"LBL_Upgrade_Name"), null));
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(GrailsCommandAction.class));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"grails-shell", (String)NbBundle.getMessage(GrailsLogicalViewProvider.class, (String)"LBL_ShellAction_Name"), null));
            arrayList.add(new ManagePluginsAction(GrailsLogicalViewProvider.this.project));
            arrayList.add(null);
            arrayList.add(new ResolvePluginsAction(GrailsLogicalViewProvider.this.project));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage(GrailsLogicalViewProvider.class, (String)"LBL_RunAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)NbBundle.getMessage(GrailsLogicalViewProvider.class, (String)"LBL_DebugAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)NbBundle.getMessage(GrailsLogicalViewProvider.class, (String)"LBL_TestAction_Name"), null));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }
    }
}

