/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.GrailsSources;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPluginSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class SourceRoots {
    private final FileObject projectRoot;
    private final GrailsProject project;

    public SourceRoots(GrailsProject grailsProject, FileObject fileObject) {
        this.projectRoot = fileObject;
        this.project = grailsProject;
    }

    public FileObject[] getRoots() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        this.addGrailsSourceRoots(this.projectRoot, arrayList);
        if (this.project != null) {
            GrailsPluginSupport grailsPluginSupport = GrailsPluginSupport.forProject(this.project);
            if (grailsPluginSupport != null) {
                arrayList.addAll(this.addPluginRoots(this.project.getBuildConfig().getProjectPluginsDir(), grailsPluginSupport.getProjectPluginFilter()));
            }
            arrayList.addAll(this.addPluginRoots(this.project.getBuildConfig().getGlobalPluginsDir(), null));
            for (GrailsPlugin grailsPlugin : this.project.getBuildConfig().getLocalPlugins()) {
                FileObject fileObject;
                if (grailsPlugin.getPath() == null || (fileObject = FileUtil.toFileObject((File)grailsPlugin.getPath())) == null) continue;
                this.addGrailsSourceRoots(fileObject, arrayList);
            }
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    public List<URL> getRootURLs() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            for (FileObject fileObject : this.getRoots()) {
                arrayList.add(FileUtil.toFile((FileObject)fileObject).toURI().toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        return arrayList;
    }

    private List<FileObject> addPluginRoots(File file, GrailsPluginSupport.FolderFilter folderFilter) {
        FileObject fileObject;
        FileObject fileObject2 = fileObject = file == null ? null : FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            Enumeration enumeration = fileObject.getFolders(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject3 = (FileObject)enumeration.nextElement();
                if (folderFilter != null && !folderFilter.accept(fileObject3.getNameExt())) continue;
                this.addGrailsSourceRoots(fileObject3, arrayList);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private void addGrailsSourceRoots(FileObject fileObject, List<FileObject> list) {
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_CONF, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_CONTROLLERS, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_DOMAIN, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_SERVICES, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_TAGLIB, list);
        SourceRoots.addRoot(fileObject, SourceCategory.GRAILSAPP_UTILS, list);
        SourceRoots.addRoot(fileObject, SourceCategory.SCRIPTS, list);
        SourceRoots.addRoot(fileObject, SourceCategory.SRC_GROOVY, list);
        SourceRoots.addRoot(fileObject, SourceCategory.SRC_JAVA, list);
        SourceRoots.addRoot(fileObject, SourceCategory.SRC_GWT, list);
        SourceRoots.addRoot(fileObject, SourceCategory.TEST_INTEGRATION, list);
        SourceRoots.addRoot(fileObject, SourceCategory.TEST_UNIT, list);
        File file = this.project == null ? null : this.project.getBuildConfig().getProjectPluginsDir();
        FileObject fileObject2 = file == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        File file2 = this.project == null ? null : this.project.getBuildConfig().getGlobalPluginsDir();
        FileObject fileObject3 = file2 == null ? null : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2));
        for (FileObject fileObject4 : fileObject.getChildren()) {
            if (!fileObject4.isFolder() || !VisibilityQuery.getDefault().isVisible(fileObject4) || GrailsSources.KNOWN_FOLDERS.contains(fileObject4.getName()) || fileObject4 == fileObject2 || fileObject4 == fileObject3) continue;
            list.add(fileObject4);
        }
        SourceRoots.addUnknownRoots(GrailsSources.KNOWN_FOLDERS_IN_GRAILS_APP, fileObject, list, "grails-app");
        SourceRoots.addUnknownRoots(GrailsSources.KNOWN_OR_IGNORED_FOLDERS_IN_TEST, fileObject, list, "test");
    }

    private static void addUnknownRoots(Collection<String> collection, FileObject fileObject, List<FileObject> list, String string) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            for (FileObject fileObject3 : fileObject2.getChildren()) {
                if (!fileObject3.isFolder() || !VisibilityQuery.getDefault().isVisible(fileObject3) || collection.contains(fileObject3.getName())) continue;
                list.add(fileObject3);
            }
        }
    }

    private static void addRoot(FileObject fileObject, SourceCategory sourceCategory, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(sourceCategory.getRelativePath());
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }
}

