/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.netbeans.modules.php.symfony.SymfonyPhpFrameworkProvider;
import org.netbeans.modules.php.symfony.SymfonyScript;
import org.netbeans.modules.php.symfony.ui.wizards.NewProjectConfigurationPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SymfonyPhpModuleExtender
extends PhpModuleExtender {
    private NewProjectConfigurationPanel panel = null;

    public Set<FileObject> extend(PhpModule phpModule) throws PhpModuleExtender.ExtendingException {
        FileObject index;
        FileObject config;
        SymfonyScript symfonyScript = null;
        try {
            symfonyScript = SymfonyScript.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        assert (symfonyScript.isValid()) : "Symfony script has to be valid!";
        if (!symfonyScript.initProject(phpModule, this.getPanel().getProjectParams())) {
            Logger.getLogger(SymfonyPhpModuleExtender.class.getName()).log(Level.INFO, "Framework Symfony not found in newly created project {0}", phpModule.getDisplayName());
            throw new PhpModuleExtender.ExtendingException(NbBundle.getMessage(SymfonyPhpModuleExtender.class, (String)"MSG_NotExtended"));
        }
        for (Pair<String, String[]> app : this.getPanel().getApps()) {
            symfonyScript.initApp(phpModule, (String)app.first, (String[])app.second);
        }
        SymfonyPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule).refreshFrameworkCommandsLater(null);
        HashSet<FileObject> files = new HashSet<FileObject>();
        FileObject databases = SymfonyPhpFrameworkProvider.locate(phpModule, "config/databases.yml", true);
        if (databases != null) {
            files.add(databases);
        }
        if ((config = SymfonyPhpFrameworkProvider.locate(phpModule, "config/ProjectConfiguration.class.php", true)) != null) {
            files.add(config);
        }
        if (files.isEmpty() && (index = SymfonyPhpFrameworkProvider.locate(phpModule, "web/index.php", true)) != null) {
            files.add(index);
        }
        return files;
    }

    public void addChangeListener(ChangeListener listener) {
        this.getPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getPanel().removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        try {
            PhpInterpreter.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            return ex.getLocalizedMessage();
        }
        try {
            SymfonyScript.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            return NbBundle.getMessage(SymfonyPhpModuleExtender.class, (String)"MSG_CannotExtend", (Object)ex.getMessage());
        }
        return this.getPanel().getErrorMessage();
    }

    public String getWarningMessage() {
        return this.getPanel().getWarningMessage();
    }

    private synchronized NewProjectConfigurationPanel getPanel() {
        if (this.panel == null) {
            this.panel = new NewProjectConfigurationPanel();
        }
        return this.panel;
    }
}

