/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.modules.editor.indent.TaskHandler;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;

public final class IndentImpl {
    private static final Logger LOG = Logger.getLogger(IndentImpl.class.getName());
    private final Document doc;
    private Indent indent;
    private Reformat reformat;
    private TaskHandler indentHandler;
    private TaskHandler reformatHandler;
    private Formatter defaultFormatter;
    private Thread lockThread;
    private int lockExtraDepth;

    public static IndentImpl get(Document doc) {
        IndentImpl indentImpl = (IndentImpl)doc.getProperty(IndentImpl.class);
        if (indentImpl == null) {
            indentImpl = new IndentImpl(doc);
            doc.putProperty(IndentImpl.class, indentImpl);
        }
        indentImpl.refresh();
        return indentImpl;
    }

    public IndentImpl(Document doc) {
        this.doc = doc;
    }

    public Document document() {
        return this.doc;
    }

    public Indent getIndent() {
        return this.indent;
    }

    public void setIndent(Indent indent) {
        this.indent = indent;
    }

    public Reformat getReformat() {
        return this.reformat;
    }

    public void setReformat(Reformat reformat) {
        this.reformat = reformat;
    }

    void setDefaultFormatter(Formatter defaultFormatter) {
        this.defaultFormatter = defaultFormatter;
    }

    void refresh() {
        if (this.defaultFormatter == null && this.doc instanceof BaseDocument) {
            this.defaultFormatter = ((BaseDocument)this.doc).getLegacyFormatter();
        }
    }

    public synchronized void indentLock() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("indentLock() on " + this);
        }
        Thread currentThread = Thread.currentThread();
        while (this.lockThread != null) {
            if (currentThread == this.lockThread) {
                ++this.lockExtraDepth;
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new Error("Interrupted at acquiring indent-lock");
            }
        }
        this.lockThread = currentThread;
        TaskHandler handler = new TaskHandler(true, this.doc);
        if (handler.collectTasks()) {
            handler.lock();
        }
        this.indentHandler = handler;
    }

    public synchronized void indentUnlock() {
        Thread currentThread;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("indentUnlock() on " + this);
        }
        if ((currentThread = Thread.currentThread()) != this.lockThread) {
            throw new IllegalStateException("Invalid indentUnlock(): current-thread=" + currentThread + ", lockThread=" + this.lockThread + ", lockExtraDepth=" + this.lockExtraDepth);
        }
        if (this.lockExtraDepth == 0) {
            this.indentHandler.unlock();
            this.indentHandler = null;
            this.lockThread = null;
            this.notifyAll();
        } else {
            --this.lockExtraDepth;
        }
    }

    public TaskHandler indentHandler() {
        return this.indentHandler;
    }

    public synchronized void reformatLock() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("reformatLock() on " + this);
        }
        if (this.reformatHandler != null) {
            throw new IllegalStateException("Already locked");
        }
        TaskHandler handler = new TaskHandler(false, this.doc);
        if (handler.collectTasks()) {
            handler.lock();
        }
        this.reformatHandler = handler;
    }

    public synchronized void reformatUnlock() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("reformatUnlock() on " + this);
        }
        if (this.reformatHandler == null) {
            throw new IllegalStateException("Already unlocked");
        }
        this.reformatHandler.unlock();
        this.reformatHandler = null;
    }

    public TaskHandler reformatHandler() {
        return this.reformatHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reindent(int startOffset, int endOffset, int caretOffset, boolean indentNewLine) throws BadLocationException {
        if (startOffset > endOffset) {
            throw new IllegalArgumentException("startOffset=" + startOffset + " > endOffset=" + endOffset);
        }
        boolean runUnlocked = false;
        if (this.indentHandler == null) {
            LOG.log(Level.SEVERE, null, new Exception("Not locked. Use Indent.lock()."));
            runUnlocked = true;
            this.indentHandler = new TaskHandler(true, this.doc);
        }
        try {
            if (runUnlocked) {
                this.indentHandler.collectTasks();
            }
            this.indentHandler.setCaretOffset(caretOffset);
            Element lineRootElem = IndentImpl.lineRootElement(this.doc);
            boolean done = false;
            if (this.indentHandler.hasItems()) {
                if (indentNewLine) {
                    this.doc.insertString(startOffset, "\n", null);
                    ++startOffset;
                    ++endOffset;
                    if (this.indentHandler.caretOffset() == 0) {
                        this.indentHandler.setCaretOffset(1);
                    }
                }
                int startLineIndex = lineRootElem.getElementIndex(startOffset);
                Element lineElem = lineRootElem.getElement(startLineIndex);
                int startLineOffset = lineElem.getStartOffset();
                if (endOffset > lineElem.getEndOffset()) {
                    int endLineIndex = lineRootElem.getElementIndex(endOffset);
                    lineElem = lineRootElem.getElement(endLineIndex);
                    if (endLineIndex > 0 && lineElem.getStartOffset() == endOffset) {
                        lineElem = lineRootElem.getElement(--endLineIndex);
                    }
                }
                this.indentHandler.setGlobalBounds(this.doc.createPosition(startLineOffset), this.doc.createPosition(lineElem.getEndOffset() - 1));
                this.indentHandler.runTasks();
                done = true;
            }
            if (!done && this.doc instanceof BaseDocument && this.defaultFormatter != null) {
                if (indentNewLine) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Defaulting reindent() to indentNewLine() in legacy formatter " + this.defaultFormatter + '\n');
                    }
                    int newCaretOffset = this.defaultFormatter.indentNewLine(this.doc, caretOffset);
                    this.indentHandler.setCaretOffset(newCaretOffset);
                } else {
                    Element lineElem;
                    int startLineIndex;
                    Position endPos = this.doc.createPosition(endOffset);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Defaulting reindent() to indentLine() in legacy formatter " + this.defaultFormatter + '\n');
                    }
                    while ((startLineIndex = lineRootElem.getElementIndex(startOffset = this.defaultFormatter.indentLine(this.doc, startOffset)) + 1) < lineRootElem.getElementCount() && (startOffset = (lineElem = lineRootElem.getElement(startLineIndex)).getStartOffset()) < endPos.getOffset()) {
                    }
                }
            }
            int n = this.indentHandler.caretOffset();
            return n;
        }
        finally {
            if (runUnlocked) {
                this.indentHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reformat(int startOffset, int endOffset) throws BadLocationException {
        if (startOffset > endOffset) {
            throw new IllegalArgumentException("startOffset=" + startOffset + " > endOffset=" + endOffset);
        }
        boolean runUnlocked = false;
        if (this.reformatHandler == null) {
            LOG.log(Level.SEVERE, "Not locked. Use Reformat.lock().", new Exception());
            runUnlocked = true;
            this.reformatHandler = new TaskHandler(false, this.doc);
        }
        try {
            if (runUnlocked) {
                this.reformatHandler.collectTasks();
            }
            boolean done = false;
            if (this.reformatHandler.hasItems()) {
                this.reformatHandler.setGlobalBounds(this.doc.createPosition(startOffset), this.doc.createPosition(endOffset));
                this.reformatHandler.runTasks();
                done = true;
            }
            if (!done && this.doc instanceof BaseDocument && this.defaultFormatter != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Defaulting reformat() to reformat() in legacy formatter " + this.defaultFormatter + '\n');
                }
                BaseDocument bdoc = (BaseDocument)this.doc;
                this.defaultFormatter.reformat(bdoc, startOffset, endOffset);
            }
        }
        finally {
            if (runUnlocked) {
                this.reformatHandler = null;
            }
        }
    }

    public static Element lineRootElement(Document doc) {
        return doc instanceof StyledDocument ? ((StyledDocument)doc).getParagraphElement(0).getParentElement() : doc.getDefaultRootElement();
    }

    public static void checkOffsetInDocument(Document doc, int offset) throws BadLocationException {
        if (offset < 0) {
            throw new BadLocationException("offset=" + offset + " < 0", offset);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("offset=" + offset + " > doc.getLength()=" + doc.getLength(), offset);
        }
    }
}

