/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractComponentCollection {
    protected PlexusContainer container;
    protected String role;
    protected List roleHints;
    protected ClassRealm realm;
    protected String hostComponent;
    protected Logger logger;
    private ClassRealm[] realms;
    private int lastRealmCount = -1;
    private int lastComponentCount = -1;
    private Map componentDescriptorMap;

    public AbstractComponentCollection(PlexusContainer container, ClassRealm realm, String role, List roleHints, String hostComponent) {
        this.container = container;
        this.realm = realm;
        this.role = role;
        this.roleHints = roleHints;
        this.hostComponent = hostComponent;
        this.logger = container.getLoggerManager().getLoggerForComponent(role);
    }

    protected ClassRealm[] getLookupRealms() {
        ArrayList allRealms = new ArrayList(this.realm.getWorld().getRealms());
        if (this.realmsHaveChanged()) {
            ArrayList<ClassRealm> lookupRealms = new ArrayList<ClassRealm>();
            lookupRealms.add(this.realm);
            int lastSize = 0;
            while (lookupRealms.size() > lastSize) {
                lastSize = lookupRealms.size();
                for (ClassRealm r : allRealms) {
                    if (r.getParentRealm() == null || !lookupRealms.contains(r.getParentRealm()) || lookupRealms.contains(r)) continue;
                    lookupRealms.add(r);
                }
            }
            this.realms = lookupRealms.toArray(new ClassRealm[0]);
        }
        return this.realms;
    }

    protected Map getLookupRealmMap() {
        ClassRealm[] realms = this.getLookupRealms();
        HashMap<String, ClassRealm> realmMap = new HashMap<String, ClassRealm>();
        int i = 0;
        while (i < realms.length) {
            realmMap.put(realms[i].getId(), realms[i]);
            ++i;
        }
        return realmMap;
    }

    private boolean realmsHaveChanged() {
        return this.realms == null || this.realm.getWorld().getRealms().size() != this.lastRealmCount;
    }

    protected Map getComponentDescriptorMap() {
        this.checkUpdate();
        return this.componentDescriptorMap;
    }

    protected boolean checkUpdate() {
        if (this.componentDescriptorMap != null && !this.realmsHaveChanged()) {
            return false;
        }
        ClassRealm[] lookupRealms = this.getLookupRealms();
        Map[] componentMaps = new Map[lookupRealms.length];
        int count = 0;
        int i = 0;
        while (i < lookupRealms.length) {
            ClassRealm r = lookupRealms[i];
            componentMaps[i] = this.container.getComponentDescriptorMap(this.role, r);
            if (this.roleHints != null && !this.roleHints.isEmpty()) {
                Iterator it = componentMaps[i].keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (this.roleHints.contains(key)) continue;
                    it.remove();
                }
            }
            count += componentMaps[i].size();
            ++i;
        }
        if (count != this.lastComponentCount) {
            WeakHashMap newComponentDescriptors = new WeakHashMap();
            int i2 = 0;
            while (i2 < componentMaps.length) {
                newComponentDescriptors.putAll(componentMaps[i2]);
                ++i2;
            }
            this.componentDescriptorMap = newComponentDescriptors;
            this.lastComponentCount = count;
            return true;
        }
        return false;
    }

    protected Object lookup(String role, String roleHint, ClassRealm realm) {
        try {
            return this.container.lookup(role, roleHint, realm);
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Failed to lookup a member of active collection with role: " + role + " and role-hint: " + roleHint + "\nin realm: " + realm, e);
            return null;
        }
    }

    public void clear() {
        this.releaseAllCallback();
        this.componentDescriptorMap.clear();
        this.componentDescriptorMap = null;
        this.lastComponentCount = -1;
        this.realms = null;
        this.lastRealmCount = -1;
    }

    protected abstract void releaseAllCallback();
}

