/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.validation;

import java.util.List;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.validation.SettingsValidationResult;
import org.apache.maven.settings.validation.SettingsValidator;

public class DefaultSettingsValidator
implements SettingsValidator {
    public SettingsValidationResult validate(Settings model) {
        SettingsValidationResult result = new SettingsValidationResult();
        List profiles = model.getProfiles();
        if (profiles != null) {
            for (Profile prof : profiles) {
                this.validateRepositories(result, prof.getRepositories(), "repositories.repository");
                this.validateRepositories(result, prof.getPluginRepositories(), "pluginRepositories.pluginRepository");
            }
        }
        return result;
    }

    private void validateRepositories(SettingsValidationResult result, List repositories, String prefix) {
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(String.valueOf(prefix) + ".id", result, repository.getId());
            this.validateStringNotEmpty(String.valueOf(prefix) + ".url", result, repository.getUrl());
        }
    }

    private boolean validateStringNotEmpty(String fieldName, SettingsValidationResult result, String string) {
        return this.validateStringNotEmpty(fieldName, result, string, null);
    }

    private boolean validateStringNotEmpty(String fieldName, SettingsValidationResult result, String string, String sourceHint) {
        if (!this.validateNotNull(fieldName, result, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        if (sourceHint != null) {
            result.addMessage("'" + fieldName + "' is missing for " + sourceHint);
        } else {
            result.addMessage("'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateNotNull(String fieldName, SettingsValidationResult result, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        if (sourceHint != null) {
            result.addMessage("'" + fieldName + "' is missing for " + sourceHint);
        } else {
            result.addMessage("'" + fieldName + "' is missing.");
        }
        return false;
    }
}

