/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import hidden.org.codehaus.plexus.util.dag.CycleDetectedException;
import hidden.org.codehaus.plexus.util.dag.DAG;
import hidden.org.codehaus.plexus.util.dag.TopologicalSorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.aspect.ProjectCollisionReporterAspect;

public class ProjectSorter {
    private final DAG dag;
    private final List sortedProjects;
    private MavenProject topLevelProject;

    public ProjectSorter(List projects) throws CycleDetectedException, DuplicateProjectException {
        List list = projects;
        try {
            String id2;
            this.dag = new DAG();
            HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
            for (MavenProject project : projects) {
                id2 = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
                if (this.dag.getVertex(id2) != null) {
                    MavenProject conflictingProject = (MavenProject)projectMap.get(id2);
                    throw new DuplicateProjectException(id2, conflictingProject.getFile(), project.getFile(), "Project '" + id2 + "' is duplicated in the reactor");
                }
                this.dag.addVertex(id2);
                projectMap.put(id2, project);
            }
            for (MavenProject project : projects) {
                List reportPlugins;
                List buildPlugins;
                String parentId;
                id2 = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
                for (Dependency dependency : project.getDependencies()) {
                    String dependencyId = ArtifactUtils.versionlessKey(dependency.getGroupId(), dependency.getArtifactId());
                    if (this.dag.getVertex(dependencyId) == null) continue;
                    project.addProjectReference((MavenProject)projectMap.get(dependencyId));
                    this.dag.addEdge(id2, dependencyId);
                }
                MavenProject parent = project.getParent();
                if (parent != null && this.dag.getVertex(parentId = ArtifactUtils.versionlessKey(parent.getGroupId(), parent.getArtifactId())) != null) {
                    if (this.dag.hasEdge(parentId, id2)) {
                        this.dag.removeEdge(parentId, id2);
                    }
                    this.dag.addEdge(id2, parentId);
                }
                if ((buildPlugins = project.getBuildPlugins()) != null) {
                    for (Plugin plugin : buildPlugins) {
                        String pluginId = ArtifactUtils.versionlessKey(plugin.getGroupId(), plugin.getArtifactId());
                        if (this.dag.getVertex(pluginId) == null || pluginId.equals(id2)) continue;
                        this.addEdgeWithParentCheck(projectMap, pluginId, project, id2);
                    }
                }
                if ((reportPlugins = project.getReportPlugins()) != null) {
                    for (ReportPlugin plugin : reportPlugins) {
                        String pluginId = ArtifactUtils.versionlessKey(plugin.getGroupId(), plugin.getArtifactId());
                        if (this.dag.getVertex(pluginId) == null || pluginId.equals(id2)) continue;
                        this.addEdgeWithParentCheck(projectMap, pluginId, project, id2);
                    }
                }
                for (Extension extension : project.getBuildExtensions()) {
                    String extensionId = ArtifactUtils.versionlessKey(extension.getGroupId(), extension.getArtifactId());
                    if (this.dag.getVertex(extensionId) == null) continue;
                    this.addEdgeWithParentCheck(projectMap, extensionId, project, id2);
                }
            }
            ArrayList sortedProjects = new ArrayList();
            for (String id2 : TopologicalSorter.sort(this.dag)) {
                sortedProjects.add(projectMap.get(id2));
            }
            this.sortedProjects = Collections.unmodifiableList(sortedProjects);
            return;
        }
        catch (DuplicateProjectException duplicateProjectException) {
            ProjectCollisionReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProjectCollisionReporterAspect$1$47c02023(list, duplicateProjectException);
            throw duplicateProjectException;
        }
    }

    private void addEdgeWithParentCheck(Map projectMap, String projectRefId, MavenProject project, String id) throws CycleDetectedException {
        MavenProject extProject = (MavenProject)projectMap.get(projectRefId);
        if (extProject == null) {
            return;
        }
        project.addProjectReference(extProject);
        MavenProject extParent = extProject.getParent();
        if (extParent != null) {
            String parentId = ArtifactUtils.versionlessKey(extParent.getGroupId(), extParent.getArtifactId());
            if (!this.dag.hasEdge(projectRefId, id) || !parentId.equals(id)) {
                this.dag.addEdge(id, projectRefId);
            }
        }
    }

    public MavenProject getTopLevelProject() {
        if (this.topLevelProject == null) {
            Iterator i = this.sortedProjects.iterator();
            while (i.hasNext() && this.topLevelProject == null) {
                MavenProject project = (MavenProject)i.next();
                if (!project.isExecutionRoot()) continue;
                this.topLevelProject = project;
            }
        }
        return this.topLevelProject;
    }

    public List getSortedProjects() {
        return this.sortedProjects;
    }

    public boolean hasMultipleProjects() {
        return this.sortedProjects.size() > 1;
    }

    public List getDependents(String id) {
        return this.dag.getParentLabels(id);
    }
}

