/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class EditList {
    private BaseDocument doc;
    private List<Edit> edits;
    private boolean formatAll;
    private List<DelegatedPosition> positions = new ArrayList<DelegatedPosition>();

    public EditList(BaseDocument doc) {
        this.doc = doc;
        this.edits = new ArrayList<Edit>();
    }

    public String toString() {
        return "EditList(" + this.edits + ")";
    }

    public Position createPosition(int offset) {
        return this.createPosition(offset, Position.Bias.Forward);
    }

    public Position createPosition(int offset, Position.Bias bias) {
        DelegatedPosition pos = new DelegatedPosition(offset, bias);
        this.positions.add(pos);
        return pos;
    }

    public EditList replace(int offset, int removeLen, String insertText, boolean format, int offsetOrdinal) {
        this.edits.add(new Edit(offset, removeLen, insertText, format, offsetOrdinal));
        return this;
    }

    public void applyToDocument(BaseDocument otherDoc) {
        EditList newList = new EditList(otherDoc);
        newList.formatAll = this.formatAll;
        newList.edits = this.edits;
        newList.apply();
    }

    public void setFormatAll(boolean formatAll) {
        this.formatAll = formatAll;
    }

    public void apply() {
        if (this.edits.size() == 0) {
            return;
        }
        Collections.sort(this.edits);
        Collections.reverse(this.edits);
        this.doc.runAtomic(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    try {
                        int lastOffset = ((Edit)((EditList)EditList.this).edits.get((int)0)).offset;
                        Position lastPos = EditList.this.doc.createPosition(lastOffset, Position.Bias.Forward);
                        for (Edit edit : EditList.this.edits) {
                            if (edit.removeLen > 0) {
                                EditList.this.doc.remove(edit.offset, edit.removeLen);
                            }
                            if (edit.getInsertText() == null) continue;
                            EditList.this.doc.insertString(edit.offset, edit.insertText, null);
                            int end = edit.offset + edit.insertText.length();
                            for (int i = 0; i < EditList.this.positions.size(); ++i) {
                                DelegatedPosition pos = (DelegatedPosition)EditList.this.positions.get(i);
                                int positionOffset = pos.originalOffset;
                                if (edit.getOffset() > positionOffset || end < positionOffset) continue;
                                pos.delegate = EditList.this.doc.createPosition(positionOffset, pos.bias);
                            }
                            if (!edit.format) continue;
                            Formatter f = EditList.this.doc.getFormatter();
                            try {
                                f.reformatLock();
                                f.reformat(EditList.this.doc, edit.offset, end);
                            }
                            finally {
                                f.reformatUnlock();
                            }
                        }
                        if (!EditList.this.formatAll) break block11;
                        int firstOffset = ((Edit)((EditList)EditList.this).edits.get((int)(((EditList)EditList.this).edits.size() - 1))).offset;
                        lastOffset = lastPos.getOffset();
                        Formatter f = EditList.this.doc.getFormatter();
                        try {
                            f.reformatLock();
                            f.reformat(EditList.this.doc, firstOffset, lastOffset);
                        }
                        finally {
                            f.reformatUnlock();
                        }
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                    }
                }
            }
        });
    }

    public OffsetRange getRange() {
        int minOffset;
        if (this.edits.size() == 0) {
            return OffsetRange.NONE;
        }
        int maxOffset = minOffset = this.edits.get((int)0).offset;
        for (Edit edit : this.edits) {
            if (edit.offset < minOffset) {
                minOffset = edit.offset;
            }
            if (edit.offset <= maxOffset) continue;
            maxOffset = edit.offset;
        }
        return new OffsetRange(minOffset, maxOffset);
    }

    public int firstLine(BaseDocument doc) {
        OffsetRange range = this.getRange();
        if (range == OffsetRange.NONE) {
            return -1;
        }
        return NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)range.getStart());
    }

    private class DelegatedPosition
    implements Position {
        private int originalOffset;
        private Position delegate;
        private Position.Bias bias;

        private DelegatedPosition(int offset, Position.Bias bias) {
            this.originalOffset = offset;
            this.bias = bias;
        }

        @Override
        public int getOffset() {
            if (this.delegate != null) {
                return this.delegate.getOffset();
            }
            return -1;
        }
    }

    private static class Edit
    implements Comparable<Edit> {
        int offset;
        int removeLen;
        String insertText;
        boolean format;
        int offsetOrdinal;

        private Edit(int offset, int removeLen, String insertText, boolean format) {
            this.offset = offset;
            this.removeLen = removeLen;
            this.insertText = insertText;
            this.format = format;
        }

        private Edit(int offset, int removeLen, String insertText, boolean format, int offsetOrdinal) {
            this(offset, removeLen, insertText, format);
            this.offsetOrdinal = offsetOrdinal;
        }

        @Override
        public int compareTo(Edit other) {
            if (this.offset == other.offset) {
                return other.offsetOrdinal - this.offsetOrdinal;
            }
            return this.offset - other.offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getRemoveLen() {
            return this.removeLen;
        }

        public String getInsertText() {
            return this.insertText;
        }

        public String toString() {
            return "Edit(pos=" + this.offset + ",delete=" + this.removeLen + ",insert=" + this.insertText + ")";
        }
    }
}

