/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring.api;

import org.netbeans.modules.csl.api.OffsetRange;

public class Entry {
    private String name;
    private OffsetRange astRange;
    private OffsetRange documentRange;
    private OffsetRange bodyRange;
    private OffsetRange documentBodyRange;
    private boolean isVirtual;
    private CharSequence elementText;
    private CharSequence elementLineText;
    private int lineOffset;

    public Entry(String name, OffsetRange astRange, OffsetRange documentRange, OffsetRange bodyRange, OffsetRange documentBodyRange, int lineOffset, CharSequence elementText, CharSequence elementLineText, boolean isVirtual) {
        this.name = name;
        this.astRange = astRange;
        this.documentRange = documentRange;
        this.isVirtual = isVirtual;
        this.elementText = elementText;
        this.elementLineText = elementLineText;
        this.lineOffset = lineOffset;
        this.bodyRange = bodyRange;
        this.documentBodyRange = documentBodyRange;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean isValidInSourceDocument() {
        return this.documentRange != null;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public CharSequence getText() {
        return this.elementText;
    }

    public CharSequence getLineText() {
        return this.elementLineText;
    }

    public String getName() {
        return this.name;
    }

    public OffsetRange getDocumentRange() {
        return this.documentRange;
    }

    public OffsetRange getRange() {
        return this.astRange;
    }

    public OffsetRange getBodyRange() {
        return this.bodyRange;
    }

    public OffsetRange getDocumentBodyRange() {
        return this.documentBodyRange;
    }

    public String toString() {
        return "Entry[" + (!this.isValidInSourceDocument() ? "INVALID! " : "") + this.getName() + "; " + this.getRange().getStart() + " - " + this.getRange().getEnd() + "]";
    }
}

