/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.wizards.PanelSupportedFrameworks;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSupportedFrameworksVisual
extends JPanel
implements HelpCtx.Provider,
TableModelListener,
ListSelectionListener,
ChangeListener {
    public static final int ALL_FRAMEWORKS = 0;
    public static final int USED_FRAMEWORKS = 1;
    public static final int UNUSED_FRAMEWORKS = 2;
    private List ignoredFrameworks;
    private Map<WebFrameworkProvider, WebModuleExtender> extenders = new IdentityHashMap<WebFrameworkProvider, WebModuleExtender>();
    private FrameworksTableModel model;
    private PanelSupportedFrameworks panel;
    private ExtenderController controller;
    private JLabel jLabel1;
    private JLabel jLabelConfig;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableFrameworks;

    public PanelSupportedFrameworksVisual(PanelSupportedFrameworks panelSupportedFrameworks, ExtenderController extenderController, WebProject webProject, int n, List list) {
        this.panel = panelSupportedFrameworks;
        this.controller = extenderController;
        this.ignoredFrameworks = list;
        this.initComponents();
        this.model = new FrameworksTableModel();
        this.jTableFrameworks.setModel(this.model);
        this.createFrameworksList(webProject, n);
        FrameworksTableCellRenderer frameworksTableCellRenderer = new FrameworksTableCellRenderer();
        frameworksTableCellRenderer.setBooleanRenderer(this.jTableFrameworks.getDefaultRenderer(Boolean.class));
        this.jTableFrameworks.setDefaultRenderer(WebFrameworkProvider.class, frameworksTableCellRenderer);
        this.jTableFrameworks.setDefaultRenderer(Boolean.class, frameworksTableCellRenderer);
        this.initTableVisualProperties(this.jTableFrameworks);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"ACS_NWP2_Frameworks_A11YDesc"));
        this.setName(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"LBL_NWP2_Frameworks"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"TXT_NewWebApp"));
    }

    private void initTableVisualProperties(JTable jTable) {
        jTable.getModel().addTableModelListener(this);
        jTable.setRowSelectionAllowed(true);
        jTable.getSelectionModel().addListSelectionListener(this);
        jTable.getSelectionModel().setSelectionMode(0);
        jTable.setTableHeader(null);
        jTable.setRowHeight(this.jTableFrameworks.getRowHeight() + 4);
        jTable.setIntercellSpacing(new Dimension(0, 0));
        jTable.getParent().setBackground(jTable.getBackground());
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private void createFrameworksList(WebProject webProject, int n) {
        block4: {
            List list;
            block5: {
                block3: {
                    list = WebFrameworks.getFrameworks();
                    if (webProject != null && n != 0) break block3;
                    for (int i = 0; i < list.size(); ++i) {
                        this.addFrameworkToModel((WebFrameworkProvider)list.get(i));
                    }
                    break block4;
                }
                if (n != 1) break block5;
                for (int i = 0; i < list.size(); ++i) {
                    WebFrameworkProvider webFrameworkProvider = (WebFrameworkProvider)list.get(i);
                    if (!webFrameworkProvider.isInWebModule(webProject.getAPIWebModule())) continue;
                    this.addFrameworkToModel(webFrameworkProvider);
                }
                break block4;
            }
            if (n != 2) break block4;
            for (int i = 0; i < list.size(); ++i) {
                WebFrameworkProvider webFrameworkProvider = (WebFrameworkProvider)list.get(i);
                if (webFrameworkProvider.isInWebModule(webProject.getAPIWebModule())) continue;
                this.addFrameworkToModel(webFrameworkProvider);
            }
        }
    }

    private void addFrameworkToModel(WebFrameworkProvider webFrameworkProvider) {
        FrameworksTableModel frameworksTableModel = (FrameworksTableModel)this.jTableFrameworks.getModel();
        if (this.ignoredFrameworks == null || !this.ignoredFrameworks.contains(webFrameworkProvider)) {
            frameworksTableModel.addItem(new FrameworkModelItem(webFrameworkProvider));
        }
    }

    private void createExtenders() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem frameworkModelItem = this.model.getItem(i);
            WebFrameworkProvider webFrameworkProvider = frameworkModelItem.getFramework();
            WebModuleExtender webModuleExtender = webFrameworkProvider.createWebModuleExtender(null, this.controller);
            if (webModuleExtender == null) continue;
            webModuleExtender.addChangeListener((ChangeListener)this);
            this.extenders.put(webFrameworkProvider, webModuleExtender);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableFrameworks = new JTable();
        this.jSeparator1 = new JSeparator();
        this.jLabelConfig = new JLabel();
        this.jPanelConfig = new JPanel();
        this.setPreferredSize(new Dimension(500, 340));
        this.setRequestFocusEnabled(false);
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"MNE_Frameworks").charAt(0));
        this.jLabel1.setLabelFor(this.jTableFrameworks);
        this.jLabel1.setText(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"LBL_NWP2_Select_Frameworks"));
        this.jScrollPane1.setMinimumSize(new Dimension(22, 70));
        this.jScrollPane1.setOpaque(false);
        this.jScrollPane1.setPreferredSize(new Dimension(453, 70));
        this.jTableFrameworks.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableFrameworks.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jTableFrameworks);
        this.jLabelConfig.setLabelFor(this.jPanelConfig);
        this.jPanelConfig.setLayout(new GridBagLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1, -1, 500, Short.MAX_VALUE).add(2, (Component)this.jLabelConfig, -1, 500, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 500, Short.MAX_VALUE).add((Component)this.jPanelConfig, -1, 500, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 500, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 99, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jSeparator1, -2, 2, -2).add(18, 18, 18).add((Component)this.jLabelConfig, -2, 21, -2).addPreferredGap(0).add((Component)this.jPanelConfig, -1, 196, Short.MAX_VALUE)));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"ACS_LBL_NWP2_FrameworksTable_A11YDesc"));
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        this.setErrorMessage(wizardDescriptor, null);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String string;
            if (!this.model.getItem(i).isSelected().booleanValue()) continue;
            FrameworkModelItem frameworkModelItem = this.model.getItem(i);
            WebModuleExtender webModuleExtender = this.extenders.get(frameworkModelItem.getFramework());
            if (webModuleExtender != null && !webModuleExtender.isValid()) {
                string = (String)this.controller.getProperties().getProperty("WizardPanel_infoMessage");
                if (this.controller.getErrorMessage() == null && string != null) {
                    this.setInfoMessage(wizardDescriptor, string);
                } else {
                    this.setErrorMessage(wizardDescriptor, this.controller.getErrorMessage());
                }
                return false;
            }
            if (webModuleExtender == null || !webModuleExtender.isValid()) continue;
            string = (String)this.controller.getProperties().getProperty("WizardPanel_infoMessage");
            if (this.controller.getErrorMessage() != null || string == null) continue;
            this.setInfoMessage(wizardDescriptor, string);
        }
        return true;
    }

    private void setErrorMessage(WizardDescriptor wizardDescriptor, String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    private void setInfoMessage(WizardDescriptor wizardDescriptor, String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)string);
    }

    void read(WizardDescriptor wizardDescriptor) {
        ExtenderController.Properties properties = this.controller.getProperties();
        properties.setProperty("name", (Object)((String)wizardDescriptor.getProperty("name")));
        properties.setProperty("j2eeLevel", (Object)((Profile)wizardDescriptor.getProperty("j2eeLevel")).toPropertiesString());
        properties.setProperty("serverInstanceID", (Object)((String)wizardDescriptor.getProperty("serverInstanceID")));
        properties.setProperty("setSourceLevel", (Object)((String)wizardDescriptor.getProperty("setSourceLevel")));
        if (this.extenders.size() == 0) {
            this.createExtenders();
        }
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem frameworkModelItem = this.model.getItem(i);
            WebModuleExtender webModuleExtender = this.extenders.get(frameworkModelItem.getFramework());
            if (webModuleExtender == null) continue;
            webModuleExtender.update();
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("extenders", (Object)this.getSelectedExtenders());
        wizardDescriptor.putProperty("frameworkNames", this.getSelectedFrameworkNames());
    }

    public List getSelectedExtenders() {
        LinkedList<WebModuleExtender> linkedList = new LinkedList<WebModuleExtender>();
        FrameworksTableModel frameworksTableModel = (FrameworksTableModel)this.jTableFrameworks.getModel();
        for (int i = 0; i < frameworksTableModel.getRowCount(); ++i) {
            WebModuleExtender webModuleExtender;
            FrameworkModelItem frameworkModelItem = frameworksTableModel.getItem(i);
            if (!frameworkModelItem.isSelected().booleanValue() || (webModuleExtender = this.extenders.get(frameworkModelItem.getFramework())) == null) continue;
            linkedList.add(webModuleExtender);
        }
        return linkedList;
    }

    private List<String> getSelectedFrameworkNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        FrameworksTableModel frameworksTableModel = (FrameworksTableModel)this.jTableFrameworks.getModel();
        for (int i = 0; i < frameworksTableModel.getRowCount(); ++i) {
            String string;
            FrameworkModelItem frameworkModelItem = frameworksTableModel.getItem(i);
            if (!frameworkModelItem.isSelected().booleanValue() || (string = frameworkModelItem.getFramework().getName()) == null) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    public Component[] getConfigComponents() {
        return new Component[]{this.jSeparator1, this.jLabelConfig, this.jPanelConfig};
    }

    public HelpCtx getHelpCtx() {
        if (this.jPanelConfig.getComponentCount() > 0) {
            for (int i = 0; i < this.jPanelConfig.getComponentCount(); ++i) {
                if (!(this.jPanelConfig.getComponent(i) instanceof HelpCtx.Provider)) continue;
                return ((HelpCtx.Provider)this.jPanelConfig.getComponent(i)).getHelpCtx();
            }
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        FrameworksTableModel frameworksTableModel = (FrameworksTableModel)this.jTableFrameworks.getModel();
        if (this.jTableFrameworks.getSelectedRow() == -1) {
            return;
        }
        FrameworkModelItem frameworkModelItem = frameworksTableModel.getItem(this.jTableFrameworks.getSelectedRow());
        WebFrameworkProvider webFrameworkProvider = frameworkModelItem.getFramework();
        this.setConfigPanel(webFrameworkProvider, frameworkModelItem);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        FrameworksTableModel frameworksTableModel = (FrameworksTableModel)this.jTableFrameworks.getModel();
        if (this.jTableFrameworks.getSelectedRow() == -1) {
            return;
        }
        FrameworkModelItem frameworkModelItem = frameworksTableModel.getItem(this.jTableFrameworks.getSelectedRow());
        WebFrameworkProvider webFrameworkProvider = frameworkModelItem.getFramework();
        this.setConfigPanel(webFrameworkProvider, frameworkModelItem);
    }

    private void setConfigPanel(WebFrameworkProvider webFrameworkProvider, FrameworkModelItem frameworkModelItem) {
        if (this.extenders.get(webFrameworkProvider) != null) {
            String string = MessageFormat.format(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"LBL_NWP2_ConfigureFramework"), webFrameworkProvider.getName());
            this.jLabelConfig.setText(string);
            this.jPanelConfig.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            JComponent jComponent = this.extenders.get(webFrameworkProvider).getComponent();
            this.jPanelConfig.add((Component)jComponent, gridBagConstraints);
            this.jLabelConfig.setEnabled(frameworkModelItem.isSelected());
            this.enableComponents(jComponent, frameworkModelItem.isSelected());
            this.extenders.get(webFrameworkProvider).update();
            this.jPanelConfig.revalidate();
            this.jPanelConfig.repaint();
        } else {
            this.jLabelConfig.setText("");
            this.jPanelConfig.removeAll();
            this.jPanelConfig.repaint();
            this.jPanelConfig.revalidate();
        }
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    private void enableComponents(Container container, boolean bl) {
        container.setEnabled(bl);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                this.enableComponents((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    private final class FrameworkModelItem {
        private WebFrameworkProvider framework;
        private Boolean selected;

        public FrameworkModelItem(WebFrameworkProvider webFrameworkProvider) {
            this.setFramework(webFrameworkProvider);
            this.setSelected(Boolean.FALSE);
        }

        public WebFrameworkProvider getFramework() {
            return this.framework;
        }

        public void setFramework(WebFrameworkProvider webFrameworkProvider) {
            this.framework = webFrameworkProvider;
        }

        public Boolean isSelected() {
            return this.selected;
        }

        public void setSelected(Boolean bl) {
            this.selected = bl;
        }
    }

    public static final class FrameworksTableModel
    extends AbstractTableModel {
        private DefaultListModel model = new DefaultListModel();

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return WebFrameworkProvider.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            FrameworkModelItem frameworkModelItem = this.getItem(n);
            switch (n2) {
                case 0: {
                    return frameworkModelItem.isSelected();
                }
                case 1: {
                    return frameworkModelItem.getFramework();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            FrameworkModelItem frameworkModelItem = this.getItem(n);
            switch (n2) {
                case 0: {
                    frameworkModelItem.setSelected((Boolean)object);
                    break;
                }
                case 1: {
                    frameworkModelItem.setFramework((WebFrameworkProvider)object);
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        private FrameworkModelItem getItem(int n) {
            return (FrameworkModelItem)this.model.get(n);
        }

        public void addItem(FrameworkModelItem frameworkModelItem) {
            this.model.addElement(frameworkModelItem);
        }
    }

    public static class FrameworksTableCellRenderer
    extends DefaultTableCellRenderer {
        private TableCellRenderer booleanRenderer;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof WebFrameworkProvider) {
                WebFrameworkProvider webFrameworkProvider = (WebFrameworkProvider)object;
                Component component = super.getTableCellRendererComponent(jTable, webFrameworkProvider.getName(), bl, false, n, n2);
                if (component instanceof JComponent) {
                    ((JComponent)component).setOpaque(bl);
                }
                return component;
            }
            if (object instanceof Boolean && this.booleanRenderer != null) {
                return this.booleanRenderer.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }

        public void setBooleanRenderer(TableCellRenderer tableCellRenderer) {
            this.booleanRenderer = tableCellRenderer;
        }
    }
}

