/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.HtmlDataNode;
import org.netbeans.modules.html.HtmlEditorSupport;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.UserCancelException;
import org.xml.sax.InputSource;

public class HtmlDataObject
extends MultiDataObject
implements CookieSet.Factory {
    public static final String PROP_ENCODING = "Content-Encoding";
    public static final String DEFAULT_ENCODING = new InputStreamReader(System.in).getEncoding();
    static final long serialVersionUID = 8354927561693097159L;
    private static final String CHARSET_DECL = "CHARSET=";
    private HtmlEditorSupport htmlEditorSupport;

    public HtmlDataObject(FileObject pf, UniFileLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        CookieSet set = this.getCookieSet();
        set.add(HtmlEditorSupport.class, (CookieSet.Factory)this);
        set.add(ViewSupport.class, (CookieSet.Factory)this);
        set.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                HtmlEditorSupport es = (HtmlEditorSupport)HtmlDataObject.this.getCookie(HtmlEditorSupport.class);
                try {
                    es.updateEncoding();
                    es.saveAs(folder, fileName);
                }
                catch (UserCancelException e) {
                    // empty catch block
                }
            }
        }});
        FileEncodingQueryImplementation feq = new FileEncodingQueryImplementation(){

            public Charset getEncoding(FileObject file) {
                assert (file != null);
                assert (file.equals(HtmlDataObject.this.getPrimaryFile()));
                String charsetName = HtmlDataObject.this.getFileEncoding();
                if (charsetName == null) {
                    return null;
                }
                try {
                    return Charset.forName(charsetName);
                }
                catch (IllegalCharsetNameException ichse) {
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
                return null;
            }
        };
        set.assign(FileEncodingQueryImplementation.class, (Object[])new FileEncodingQueryImplementation[]{feq});
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        set.add((Node.Cookie)new ValidateXMLSupport(in));
        set.add((Node.Cookie)new CheckXMLSupport(in));
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    protected Node createNodeDelegate() {
        HtmlDataNode n = new HtmlDataNode((DataObject)this, Children.LEAF);
        n.setIconBaseWithExtension("org/netbeans/modules/html/htmlObject.png");
        return n;
    }

    public Node.Cookie createCookie(Class klass) {
        if (klass.isAssignableFrom(HtmlEditorSupport.class)) {
            return this.getHtmlEditorSupport();
        }
        if (klass.isAssignableFrom(ViewSupport.class)) {
            return new ViewSupport(this.getPrimaryEntry());
        }
        return null;
    }

    private synchronized HtmlEditorSupport getHtmlEditorSupport() {
        if (this.htmlEditorSupport == null) {
            this.htmlEditorSupport = new HtmlEditorSupport(this);
        }
        return this.htmlEditorSupport;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFileEncoding() {
        String encoding = null;
        InputStream is = null;
        try {
            is = this.getPrimaryFile().getInputStream();
            byte[] arr = new byte[4096];
            int len = is.read(arr);
            int n = len = len >= 0 ? len : 0;
            if (len > 1) {
                int mark = (arr[0] & 0xFF) * 256 + (arr[1] & 0xFF);
                if (mark == 65279) {
                    encoding = "UTF-16";
                } else if (mark == 65534) {
                    encoding = "UTF-16LE";
                }
            }
            String[] encodings = new String[]{encoding != null ? encoding : DEFAULT_ENCODING, "UTF-16LE", "UTF-16BE"};
            int i = 0;
            while ((encoding = HtmlDataObject.findEncoding(this.makeString(arr, 0, len, encodings[i++]))) == null && i < encodings.length) {
            }
        }
        catch (IOException ex) {
            Logger.getLogger("global").log(Level.WARNING, null, ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.WARNING, null, ex);
            }
        }
        if (encoding != null) {
            encoding = encoding.trim();
        }
        return encoding;
    }

    private String makeString(byte[] arr, int offset, int len, String encoding) throws UnsupportedEncodingException {
        return new String(arr, 0, len, encoding).toUpperCase();
    }

    static String findEncoding(String txt) {
        int[] offsets = HtmlDataObject.findEncodingOffsets(txt);
        if (offsets.length == 3) {
            String encoding = txt.substring(offsets[0] + offsets[1], offsets[0] + offsets[2]);
            return encoding;
        }
        return null;
    }

    private static int[] findEncodingOffsets(String txt) {
        int[] rslt = new int[]{};
        TokenHierarchy hi = TokenHierarchy.create((CharSequence)txt, (Language)HTMLTokenId.language());
        TokenSequence ts = hi.tokenSequence();
        ts.moveStart();
        while (ts.moveNext()) {
            Token token = ts.token();
            if (token.id() != HTMLTokenId.VALUE) continue;
            String tokenImage = ((Object)token.text()).toString();
            int charsetOffset = tokenImage.indexOf(CHARSET_DECL);
            charsetOffset = charsetOffset == -1 ? tokenImage.indexOf(CHARSET_DECL.toLowerCase()) : charsetOffset;
            int charsetEndOffset = charsetOffset + CHARSET_DECL.length();
            if (charsetOffset == -1) continue;
            int endOffset = tokenImage.indexOf(34, charsetEndOffset);
            if (endOffset == -1) {
                endOffset = tokenImage.indexOf(39, charsetEndOffset);
            }
            if (endOffset == -1) {
                endOffset = tokenImage.indexOf(59, charsetEndOffset);
            }
            if (endOffset == -1) {
                return rslt;
            }
            rslt = new int[]{token.offset(hi), charsetEndOffset, endOffset};
        }
        return rslt;
    }

    static final class ViewSupport
    implements ViewCookie {
        private MultiDataObject.Entry primary;

        public ViewSupport(MultiDataObject.Entry primary) {
            this.primary = primary;
        }

        public void view() {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(this.primary.getFile().getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
    }
}

