/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.tools.impl.DataRowConsumer;
import org.netbeans.modules.dlight.tools.impl.LLDataCollectorConfigurationAccessor;
import org.netbeans.modules.dlight.tools.impl.LinuxProcfsSupport;
import org.netbeans.modules.dlight.tools.impl.ProcDataProvider;
import org.netbeans.modules.dlight.util.DLightMath;

public class ProcDataProviderLinux
implements ProcDataProvider.Engine {
    private static final List<String> COLNAMES = Collections.unmodifiableList(Arrays.asList(ProcDataProviderConfiguration.USR_TIME.getColumnName(), ProcDataProviderConfiguration.SYS_TIME.getColumnName(), ProcDataProviderConfiguration.THREADS.getColumnName()));
    private static final BigInteger PERCENT = BigInteger.valueOf(100L);
    private final DataRowConsumer consumer;
    private final ServiceInfoDataStorage serviceInfoStorage;
    private final boolean decreaseThreads;
    private LinuxProcfsSupport.CpuStat prevCpuStat;
    private LinuxProcfsSupport.CpuStat currCpuStat;
    private LinuxProcfsSupport.ProcessStat prevProcessStat;
    private LinuxProcfsSupport.ProcessStat currProcessStat;

    public ProcDataProviderLinux(DataRowConsumer consumer, ServiceInfoDataStorage serviceInfoStorage) {
        this.consumer = consumer;
        this.serviceInfoStorage = serviceInfoStorage;
        String[] idps = this.serviceInfoStorage == null || serviceInfoStorage.getValue("service.storage.idp.names") == null ? null : serviceInfoStorage.getValue("service.storage.idp.names").split(":");
        List idpsList = idps == null ? null : Arrays.asList(idps);
        this.decreaseThreads = idpsList == null ? false : idpsList.contains(LLDataCollectorConfigurationAccessor.getDefault().getName());
    }

    @Override
    public String getCommand(int pid) {
        return "while head -n1 /proc/stat && head -n1 /proc/" + pid + "/stat; do sleep 1; done";
    }

    public void processLine(String line) {
        try {
            if (line.startsWith("cpu")) {
                this.prevCpuStat = this.currCpuStat;
                this.currCpuStat = LinuxProcfsSupport.parseCpuStat(line);
            } else {
                this.prevProcessStat = this.currProcessStat;
                this.currProcessStat = LinuxProcfsSupport.parseProcessStat(line);
                if (this.prevProcessStat != null) {
                    BigInteger cpuTicks = this.currCpuStat.all().subtract(this.prevCpuStat.all());
                    BigInteger usrTicks = ProcDataProviderLinux.usrTicks(this.currProcessStat).subtract(ProcDataProviderLinux.usrTicks(this.prevProcessStat));
                    BigInteger sysTicks = ProcDataProviderLinux.sysTicks(this.currProcessStat).subtract(ProcDataProviderLinux.sysTicks(this.prevProcessStat));
                    long threads = this.currProcessStat.num_threads();
                    if (this.decreaseThreads) {
                        --threads;
                    }
                    float[] times = DLightMath.ensureSumLessOrEqual((float)100.0f, (float[])new float[]{ProcDataProviderLinux.percent(usrTicks, cpuTicks), ProcDataProviderLinux.percent(sysTicks, cpuTicks)});
                    DataRow row = new DataRow(COLNAMES, Arrays.asList(Float.valueOf(times[0]), Float.valueOf(times[1]), threads));
                    this.consumer.consume(row);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void reset() {
        this.currCpuStat = null;
        this.prevCpuStat = null;
        this.currProcessStat = null;
        this.prevProcessStat = null;
    }

    public void close() {
    }

    private static float percent(BigInteger value, BigInteger total) {
        if (BigInteger.ZERO.compareTo(total) < 0) {
            if (value.compareTo(BigInteger.ZERO) <= 0) {
                return 0.0f;
            }
            return value.multiply(PERCENT).divide(total).floatValue();
        }
        return 0.0f;
    }

    private static BigInteger usrTicks(LinuxProcfsSupport.ProcessStat proc) {
        BigInteger result = proc.utime().add(proc.cutime());
        if (proc.guest_time() != null) {
            result = result.add(proc.guest_time());
        }
        if (proc.cguest_time() != null) {
            result = result.add(proc.cguest_time());
        }
        return result;
    }

    private static BigInteger sysTicks(LinuxProcfsSupport.ProcessStat proc) {
        BigInteger result = proc.stime().add(proc.cstime());
        if (proc.delayacct_blkio_ticks() != null) {
            result = result.add(proc.delayacct_blkio_ticks());
        }
        return result;
    }
}

