/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueAccessor;
import org.netbeans.modules.bugtracking.ui.search.FindSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.RepositoryComboRenderer;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class IssueTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static Set<IssueTopComponent> openIssues = new HashSet<IssueTopComponent>();
    private Issue issue;
    private RequestProcessor rp = new RequestProcessor("Bugtracking issue", 1, true);
    private RequestProcessor.Task prepareTask;
    private RepositoryComboSupport rs;
    private Node[] context;
    private BugtrackingController controller;
    private JLabel findIssuesLabel;
    private JPanel issuePanel;
    private JPanel jPanel1;
    private LinkButton newButton;
    private JLabel preparingLabel;
    private JLabel repoLabel;
    private JPanel repoPanel;
    private JComboBox repositoryComboBox;

    public IssueTopComponent() {
        BugtrackingConnector[] connectors;
        this.initComponents();
        for (BugtrackingConnector c : connectors = BugtrackingManager.getInstance().getConnectors()) {
            c.addPropertyChangeListener(this);
        }
        this.preparingLabel.setVisible(false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssueTopComponent.this.onNewClick();
            }
        });
        JComponent findBar = FindSupport.create(this).getFindBar();
        findBar.setVisible(false);
        this.issuePanel.add((Component)findBar, "Last");
    }

    public Issue getIssue() {
        return this.issue;
    }

    public void initNewIssue(Repository toSelect, Node[] context) {
        this.initNewIssue(toSelect, false, context);
    }

    public void initNewIssue(Repository defaultRepository, boolean suggestedSelectionOnly, Node[] context) {
        BugtrackingUtil.logBugtrackingUsage(defaultRepository, "ISSUE_EDIT");
        this.context = context;
        Font f = new JLabel().getFont();
        int s = f.getSize();
        this.findIssuesLabel.setFont(this.repoLabel.getFont().deriveFont((float)s * 1.7f));
        if (defaultRepository != null && !suggestedSelectionOnly) {
            DefaultComboBoxModel<Repository> repoModel = new DefaultComboBoxModel<Repository>();
            repoModel.addElement(defaultRepository);
            this.repositoryComboBox.setModel(repoModel);
            this.repositoryComboBox.setRenderer(new RepositoryComboRenderer());
            this.repositoryComboBox.setSelectedItem(defaultRepository);
            this.repositoryComboBox.setEnabled(false);
            this.newButton.setEnabled(false);
            this.onRepoSelected();
        } else {
            this.rs = defaultRepository == null ? RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, false) : RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, defaultRepository);
        }
        this.repositoryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    IssueTopComponent.this.onRepoSelected();
                }
            }
        });
        this.setNameAndTooltip();
    }

    public void initNoIssue(final String issueId) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IssueTopComponent.this.preparingLabel.setVisible(true);
                IssueTopComponent.this.repoPanel.setVisible(false);
                if (issueId != null) {
                    String desc = NbBundle.getMessage(IssueTopComponent.class, (String)"LBL_OPENING_ISSUE", (Object[])new Object[]{issueId});
                    IssueTopComponent.this.preparingLabel.setText(desc);
                    IssueTopComponent.this.setName(NbBundle.getMessage(IssueTopComponent.class, (String)"LBL_LOADING_ISSUE", (Object[])new Object[]{issueId}));
                    IssueTopComponent.this.setToolTipText(desc);
                } else {
                    IssueTopComponent.this.setNameAndTooltip();
                }
            }
        });
    }

    public void setIssue(Issue issue) {
        assert (this.issue == null);
        BugtrackingUtil.logBugtrackingUsage(issue.getRepository(), "ISSUE_EDIT");
        this.issue = issue;
        this.preparingLabel.setVisible(false);
        this.issuePanel.add((Component)issue.getController().getComponent(), "Center");
        this.repoPanel.setVisible(false);
        this.setNameAndTooltip();
        issue.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.repoPanel = new JPanel();
        this.repositoryComboBox = new JComboBox();
        this.findIssuesLabel = new JLabel();
        this.repoLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.newButton = new LinkButton();
        this.issuePanel = new JPanel();
        this.preparingLabel = new JLabel();
        this.repoPanel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        Mnemonics.setLocalizedText((JLabel)this.findIssuesLabel, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.findIssuesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.repoLabel, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.repoLabel.text"));
        this.repoLabel.setFocusCycleRoot(true);
        this.jPanel1.setOpaque(false);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 64, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 8, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.newButton.text"));
        GroupLayout repoPanelLayout = new GroupLayout((Container)this.repoPanel);
        this.repoPanel.setLayout((LayoutManager)repoPanelLayout);
        repoPanelLayout.setHorizontalGroup((GroupLayout.Group)repoPanelLayout.createParallelGroup(1).add((GroupLayout.Group)repoPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)repoPanelLayout.createParallelGroup(1).add((GroupLayout.Group)repoPanelLayout.createSequentialGroup().add((Component)this.repoLabel).addPreferredGap(0).add((Component)this.repositoryComboBox, -2, 225, -2).addPreferredGap(0).add((Component)this.newButton, -2, -1, -2)).add((Component)this.findIssuesLabel)).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        repoPanelLayout.setVerticalGroup((GroupLayout.Group)repoPanelLayout.createParallelGroup(1).add((GroupLayout.Group)repoPanelLayout.createSequentialGroup().add(50, 50, 50).add((Component)this.jPanel1, -2, -1, -2)).add((GroupLayout.Group)repoPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.findIssuesLabel).addPreferredGap(0).add((GroupLayout.Group)repoPanelLayout.createParallelGroup(3).add((Component)this.repoLabel).add((Component)this.repositoryComboBox, -2, -1, -2).add((Component)this.newButton, -2, -1, -2))));
        this.issuePanel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.issuePanel.setLayout(new BorderLayout());
        this.preparingLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.preparingLabel, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.preparingLabel.text"));
        this.issuePanel.add((Component)this.preparingLabel, "Center");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.repoPanel, -1, -1, Short.MAX_VALUE).add((Component)this.issuePanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.repoPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.issuePanel, -1, -1, Short.MAX_VALUE)));
    }

    private void onNewClick() {
        Repository repo = BugtrackingUtil.createRepository();
        if (repo != null) {
            this.repositoryComboBox.addItem(repo);
            this.repositoryComboBox.setSelectedItem(repo);
        }
    }

    private void onRepoSelected() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        Cancellable c = new Cancellable(){

            public boolean cancel() {
                if (IssueTopComponent.this.prepareTask != null) {
                    IssueTopComponent.this.prepareTask.cancel();
                }
                return true;
            }
        };
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(IssueTopComponent.class, (String)"CTL_PreparingIssue"), (Cancellable)c);
        this.prepareTask = this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    handle.start();
                    IssueTopComponent.this.preparingLabel.setVisible(true);
                    Repository repo = IssueTopComponent.this.getRepository();
                    if (repo == null) {
                        return;
                    }
                    if (IssueTopComponent.this.issue != null) {
                        if (IssueTopComponent.this.controller != null) {
                            IssueTopComponent.this.issuePanel.remove(IssueTopComponent.this.controller.getComponent());
                        }
                        IssueTopComponent.this.issue.removePropertyChangeListener(IssueTopComponent.this);
                    }
                    IssueTopComponent.this.issue = repo.createIssue();
                    if (IssueTopComponent.this.issue == null) {
                        return;
                    }
                    IssueAccessor.getInstance().setSelection(IssueTopComponent.this.issue, IssueTopComponent.this.context);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IssueTopComponent.this.controller = IssueTopComponent.this.issue.getController();
                            IssueTopComponent.this.issuePanel.add((Component)IssueTopComponent.this.controller.getComponent(), "Center");
                            IssueTopComponent.this.issue.addPropertyChangeListener(IssueTopComponent.this);
                            IssueTopComponent.this.revalidate();
                            IssueTopComponent.this.repaint();
                            IssueTopComponent.this.focusFirstEnabledComponent();
                        }
                    });
                }
                finally {
                    IssueTopComponent.this.preparingLabel.setVisible(false);
                    handle.finish();
                    IssueTopComponent.this.prepareTask = null;
                }
            }
        });
    }

    private Repository getRepository() {
        Object item = this.repositoryComboBox.getSelectedItem();
        if (item == null || !(item instanceof Repository)) {
            return null;
        }
        return (Repository)item;
    }

    private void focusFirstEnabledComponent() {
        this.repositoryComboBox.requestFocusInWindow();
        if (!this.repositoryComboBox.isEnabled()) {
            this.newButton.requestFocusInWindow();
            if (!this.newButton.isEnabled()) {
                this.newButton.transferFocus();
            }
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        openIssues.add(this);
        if (this.issue != null) {
            this.issue.getController().opened();
        }
        BugtrackingManager.LOG.log(Level.FINE, "IssueTopComponent Opened {0}", this.issue != null ? this.issue.getID() : "null");
    }

    public void componentClosed() {
        openIssues.remove(this);
        if (this.issue != null) {
            this.issue.removePropertyChangeListener(this);
            this.issue.getController().closed();
        }
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        BugtrackingManager.LOG.log(Level.FINE, "IssueTopComponent Closed {0}", this.issue != null ? this.issue.getID() : "null");
    }

    public static synchronized IssueTopComponent find(Issue issue) {
        return IssueTopComponent.find(issue, true);
    }

    public static synchronized IssueTopComponent find(Issue issue, boolean forceCreate) {
        for (IssueTopComponent tc : openIssues) {
            if (!issue.equals(tc.getIssue())) continue;
            return tc;
        }
        if (!forceCreate) {
            return null;
        }
        IssueTopComponent tc = new IssueTopComponent();
        tc.setIssue(issue);
        return tc;
    }

    public static synchronized IssueTopComponent find(String issueId) {
        assert (issueId != null);
        for (IssueTopComponent tc : openIssues) {
            Issue i = tc.getIssue();
            if (i == null || !issueId.equals(i.getID())) continue;
            return tc;
        }
        IssueTopComponent tc = new IssueTopComponent();
        return tc;
    }

    private void setNameAndTooltip() throws MissingResourceException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (IssueTopComponent.this.issue != null) {
                    IssueTopComponent.this.setName(IssueTopComponent.this.issue.getShortenedDisplayName());
                    IssueTopComponent.this.setToolTipText(IssueTopComponent.this.issue.getTooltip());
                } else {
                    IssueTopComponent.this.setName(NbBundle.getMessage(IssueTopComponent.class, (String)"CTL_IssueTopComponent"));
                    IssueTopComponent.this.setToolTipText(NbBundle.getMessage(IssueTopComponent.class, (String)"CTL_IssueTopComponent"));
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("issue.data_changed")) {
            this.repoPanel.setVisible(false);
            this.setNameAndTooltip();
        } else if (evt.getPropertyName().equals("bugtracking.repositories.changed")) {
            if (!this.repositoryComboBox.isEnabled()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (IssueTopComponent.this.rs != null) {
                        IssueTopComponent.this.rs.refreshRepositoryModel();
                    }
                }
            });
        }
    }

    public boolean requestFocusInWindow() {
        if (this.issue == null) {
            return this.repositoryComboBox.requestFocusInWindow();
        }
        return this.issue.getController().getComponent().requestFocusInWindow();
    }
}

