/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.util.Collection;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryConnector {
    private static final long REPOSITORY_CONFIGURATION_UPDATE_INTERVAL = 86400000L;

    public abstract boolean canCreateNewTask(TaskRepository var1);

    public abstract boolean canCreateTaskFromKey(TaskRepository var1);

    public boolean canQuery(TaskRepository repository) {
        return true;
    }

    public boolean canSynchronizeTask(TaskRepository taskRepository, ITask task) {
        return true;
    }

    public boolean canDeleteTask(TaskRepository repository, ITask task) {
        return false;
    }

    public abstract String getConnectorKind();

    public abstract String getLabel();

    public abstract String getRepositoryUrlFromTaskUrl(String var1);

    public String getShortLabel() {
        String label = this.getLabel();
        if (label == null) {
            return null;
        }
        int i = label.indexOf("(");
        if (i != -1) {
            return label.substring(0, i).trim();
        }
        i = label.indexOf(" ");
        if (i != -1) {
            return label.substring(0, i).trim();
        }
        return label;
    }

    public AbstractTaskAttachmentHandler getTaskAttachmentHandler() {
        return null;
    }

    public abstract TaskData getTaskData(TaskRepository var1, String var2, IProgressMonitor var3) throws CoreException;

    public AbstractTaskDataHandler getTaskDataHandler() {
        return null;
    }

    public abstract String getTaskIdFromTaskUrl(String var1);

    public String getTaskIdPrefix() {
        return "task";
    }

    public String[] getTaskIdsFromComment(TaskRepository repository, String comment) {
        return null;
    }

    public ITaskMapping getTaskMapping(TaskData taskData) {
        return new TaskMapper(taskData);
    }

    public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
        return null;
    }

    public abstract String getTaskUrl(String var1, String var2);

    public abstract boolean hasTaskChanged(TaskRepository var1, ITask var2, TaskData var3);

    public boolean hasLocalCompletionState(TaskRepository taskRepository, ITask task) {
        return false;
    }

    public boolean hasRepositoryDueDate(TaskRepository taskRepository, ITask task, TaskData taskData) {
        return false;
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        Date configDate = repository.getConfigurationDate();
        if (configDate != null) {
            return new Date().getTime() - configDate.getTime() > 86400000L;
        }
        return true;
    }

    public boolean isUserManaged() {
        return true;
    }

    public abstract IStatus performQuery(TaskRepository var1, IRepositoryQuery var2, TaskDataCollector var3, ISynchronizationSession var4, IProgressMonitor var5);

    public IStatus deleteTask(TaskRepository repository, ITask task, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void postSynchronization(ISynchronizationSession event, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
        }
        finally {
            monitor.done();
        }
    }

    public void preSynchronization(ISynchronizationSession event, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
        }
        finally {
            monitor.done();
        }
    }

    public abstract void updateRepositoryConfiguration(TaskRepository var1, IProgressMonitor var2) throws CoreException;

    public void updateRepositoryConfiguration(TaskRepository taskRepository, ITask task, IProgressMonitor monitor) throws CoreException {
        this.updateRepositoryConfiguration(taskRepository, monitor);
    }

    public abstract void updateTaskFromTaskData(TaskRepository var1, ITask var2, TaskData var3);
}

