/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.api.J2SERunConfigProvider;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.modules.java.j2seproject.ui.customizer.MainClassChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private J2SEProject project;
    private JTextField[] data;
    private JLabel[] dataLabels;
    private String[] keys;
    private Map<String, Map<String, String>> configs;
    J2SEProjectProperties uiProperties;
    private J2SERunConfigProvider compProvider;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel configPanel;
    private JSeparator configSep;
    private JPanel extPanel;
    private JButton jButtonMainClass;
    private JButton jButtonWorkingDirectoryBrowse;
    private JLabel jLabelArgs;
    private JLabel jLabelMainClass;
    private JLabel jLabelVMOptions;
    private JLabel jLabelVMOptionsExample;
    private JLabel jLabelWorkingDirectory;
    private JTextField jTextFieldArgs;
    private JTextField jTextFieldMainClass;
    private JTextField jTextVMOptions;
    private JTextField jTextWorkingDirectory;
    private JPanel mainPanel;

    public CustomizerRun(J2SEProjectProperties j2SEProjectProperties) {
        this.uiProperties = j2SEProjectProperties;
        this.initComponents();
        this.project = j2SEProjectProperties.getProject();
        this.compProvider = (J2SERunConfigProvider)Lookup.getDefault().lookup(J2SERunConfigProvider.class);
        this.initExtPanel(this.project);
        this.configs = j2SEProjectProperties.RUN_CONFIGS;
        this.data = new JTextField[]{this.jTextFieldMainClass, this.jTextFieldArgs, this.jTextVMOptions, this.jTextWorkingDirectory};
        this.dataLabels = new JLabel[]{this.jLabelMainClass, this.jLabelArgs, this.jLabelVMOptions, this.jLabelWorkingDirectory};
        this.keys = new String[]{"main.class", "application.args", "run.jvmargs", "work.dir"};
        assert (this.data.length == this.keys.length);
        this.configChanged(j2SEProjectProperties.activeConfig);
        this.configCombo.setRenderer(new ConfigListCellRenderer());
        for (int i = 0; i < this.data.length; ++i) {
            final JTextField jTextField = this.data[i];
            final String string = this.keys[i];
            final JLabel jLabel = this.dataLabels[i];
            jTextField.getDocument().addDocumentListener(new DocumentListener(){
                Font basefont;
                Font boldfont;
                {
                    this.basefont = jLabel.getFont();
                    this.boldfont = this.basefont.deriveFont(1);
                    this.updateFont();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changed();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changed();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }

                void changed() {
                    String string3;
                    String string2 = (String)CustomizerRun.this.configCombo.getSelectedItem();
                    if (string2.length() == 0) {
                        string2 = null;
                    }
                    if ((string3 = jTextField.getText()) != null && string2 != null && string3.equals(((Map)CustomizerRun.this.configs.get(null)).get(string))) {
                        string3 = null;
                    }
                    ((Map)CustomizerRun.this.configs.get(string2)).put(string, string3);
                    this.updateFont();
                }

                void updateFont() {
                    String string4 = jTextField.getText();
                    String string2 = (String)CustomizerRun.this.configCombo.getSelectedItem();
                    if (string2.length() == 0) {
                        string2 = null;
                    }
                    String string3 = (String)((Map)CustomizerRun.this.configs.get(null)).get(string);
                    jLabel.setFont(string2 != null && !Utilities.compareObjects((Object)(string4 != null ? string4 : ""), (Object)(string3 != null ? string3 : "")) ? this.boldfont : this.basefont);
                }
            });
        }
        this.jButtonMainClass.addActionListener(new MainClassListener(this.project.getSourceRoots(), this.jTextFieldMainClass));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void initComponents() {
        this.configSep = new JSeparator();
        this.configPanel = new JPanel();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.mainPanel = new JPanel();
        this.jLabelMainClass = new JLabel();
        this.jTextFieldMainClass = new JTextField();
        this.jButtonMainClass = new JButton();
        this.jLabelArgs = new JLabel();
        this.jTextFieldArgs = new JTextField();
        this.jLabelWorkingDirectory = new JLabel();
        this.jTextWorkingDirectory = new JTextField();
        this.jButtonWorkingDirectoryBrowse = new JButton();
        this.jLabelVMOptions = new JLabel();
        this.jTextVMOptions = new JTextField();
        this.jLabelVMOptionsExample = new JLabel();
        this.extPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.configSep, gridBagConstraints);
        this.configPanel.setLayout(new GridBagLayout());
        this.configLabel.setLabelFor(this.configCombo);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.configPanel.add((Component)this.configLabel, gridBagConstraints);
        this.configLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizerRun_Cfg"));
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew"));
        this.configNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configNewActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configNew, gridBagConstraints);
        this.configNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizerRun_NewCfg"));
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDelete"));
        this.configDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configDelActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configDel, gridBagConstraints);
        this.configDel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_CustomizerRun_DeleteCfg"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.configPanel, gridBagConstraints);
        this.mainPanel.setLayout(new GridBagLayout());
        this.jLabelMainClass.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.jLabelMainClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.mainPanel.add((Component)this.jTextFieldMainClass, gridBagConstraints);
        this.jTextFieldMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldMainClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.mainPanel.add((Component)this.jButtonMainClass, gridBagConstraints);
        this.jButtonMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jButtonMainClass"));
        this.jLabelArgs.setLabelFor(this.jTextFieldArgs);
        Mnemonics.setLocalizedText((JLabel)this.jLabelArgs, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.mainPanel.add((Component)this.jLabelArgs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.mainPanel.add((Component)this.jTextFieldArgs, gridBagConstraints);
        this.jTextFieldArgs.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldArgs"));
        this.jLabelWorkingDirectory.setLabelFor(this.jTextWorkingDirectory);
        Mnemonics.setLocalizedText((JLabel)this.jLabelWorkingDirectory, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.jLabelWorkingDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.mainPanel.add((Component)this.jTextWorkingDirectory, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/java/j2seproject/ui/customizer/Bundle");
        this.jTextWorkingDirectory.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizeRun_Run_Working_Directory "));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWorkingDirectoryBrowse, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse"));
        this.jButtonWorkingDirectoryBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.jButtonWorkingDirectoryBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.mainPanel.add((Component)this.jButtonWorkingDirectoryBrowse, gridBagConstraints);
        this.jButtonWorkingDirectoryBrowse.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizeRun_Run_Working_Directory_Browse"));
        this.jLabelVMOptions.setLabelFor(this.jTextVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptions, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.jLabelVMOptions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.mainPanel.add((Component)this.jTextVMOptions, gridBagConstraints);
        this.jTextVMOptions.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizeRun_Run_VM_Options"));
        this.jLabelVMOptionsExample.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptionsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.mainPanel.add((Component)this.jLabelVMOptionsExample, gridBagConstraints);
        this.jLabelVMOptionsExample.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_CustomizeRun_Run_VM_Options_Example"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.extPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.extPanel, gridBagConstraints);
    }

    private void initExtPanel(Project project) {
        J2SERunConfigProvider.ConfigChangeListener configChangeListener;
        JComponent jComponent;
        if (this.compProvider != null && (jComponent = this.compProvider.createComponent(project, configChangeListener = new J2SERunConfigProvider.ConfigChangeListener(){

            @Override
            public void propertiesChanged(Map<String, String> map) {
                Map map2 = (Map)CustomizerRun.this.configs.get(CustomizerRun.this.uiProperties.activeConfig);
                map2.putAll(map);
            }
        })) != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.extPanel.add((Component)jComponent, gridBagConstraints);
        }
    }

    private void configDelActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.configCombo.getSelectedItem();
        assert (string != null);
        this.configs.put(string, null);
        this.configChanged(null);
        this.uiProperties.activeConfig = null;
    }

    private void configNewActionPerformed(ActionEvent actionEvent) {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.prompt"), NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String string = inputLine.getInputText();
        String string2 = string.replaceAll("[^a-zA-Z0-9_.-]", "_");
        if (string2.trim().length() == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.empty", (Object)string2), 2));
            return;
        }
        if (this.configs.get(string2) != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.duplicate", (Object)string2), 2));
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!string.equals(string2)) {
            hashMap.put("$label", string);
        }
        this.configs.put(string2, hashMap);
        this.configChanged(string2);
        this.uiProperties.activeConfig = string2;
    }

    private void configComboActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.configCombo.getSelectedItem();
        if (string.length() == 0) {
            string = null;
        }
        this.configChanged(string);
        this.uiProperties.activeConfig = string;
    }

    private void jButtonWorkingDirectoryBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        String string = this.jTextWorkingDirectory.getText();
        if (string.equals("")) {
            string = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath();
        }
        jFileChooser.setSelectedFile(new File(string));
        jFileChooser.setDialogTitle(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse_Title"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextWorkingDirectory.setText(file.getAbsolutePath());
        }
    }

    private void configChanged(String string) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("");
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String string, String string2) {
                return this.coll.compare(this.label(string), this.label(string2));
            }

            private String label(String string) {
                Map map = (Map)CustomizerRun.this.configs.get(string);
                String string2 = (String)map.get("$label");
                return string2 != null ? string2 : string;
            }
        });
        for (Map.Entry<String, Map<String, String>> object2 : this.configs.entrySet()) {
            String string2 = object2.getKey();
            if (string2 == null || object2.getValue() == null) continue;
            treeSet.add(string2);
        }
        for (String string3 : treeSet) {
            defaultComboBoxModel.addElement(string3);
        }
        this.configCombo.setModel(defaultComboBoxModel);
        this.configCombo.setSelectedItem(string != null ? string : "");
        Map<String, String> map = this.configs.get(string);
        Map<String, String> map2 = this.configs.get(null);
        if (map != null) {
            if (this.compProvider != null) {
                this.compProvider.configUpdated(map);
            }
            for (int i = 0; i < this.data.length; ++i) {
                String string4 = (String)map.get(this.keys[i]);
                if (string4 == null) {
                    string4 = map2.get(this.keys[i]);
                }
                this.data[i].setText(string4);
            }
        }
        this.configDel.setEnabled(string != null);
    }

    private final class ConfigListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ConfigListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            this.setName("ComboBox.listRenderer");
            String string2 = (String)object;
            if (string2 == null) {
                string = null;
            } else if (string2.length() > 0) {
                Map map = (Map)CustomizerRun.this.configs.get(string2);
                String string3 = string = map != null ? (String)map.get("$label") : null;
                if (string == null) {
                    string = string2;
                }
            } else {
                string = NbBundle.getBundle((String)"org.netbeans.modules.java.j2seproject.Bundle").getString("J2SEConfigurationProvider.default.label");
            }
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private class MainClassListener
    implements ActionListener {
        private final JButton okButton;
        private SourceRoots sourceRoots;
        private JTextField mainClassTextField;

        MainClassListener(SourceRoots sourceRoots, JTextField jTextField) {
            this.sourceRoots = sourceRoots;
            this.mainClassTextField = jTextField;
            this.okButton = new JButton(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ChooseMainClass_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final MainClassChooser mainClassChooser = new MainClassChooser(this.sourceRoots.getRoots());
            Object[] objectArray = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            mainClassChooser.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                        MainClassListener.this.okButton.doClick();
                    } else {
                        MainClassListener.this.okButton.setEnabled(mainClassChooser.getSelectedMainClass() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mainClassChooser, NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_Title"), true, objectArray, objectArray[0], 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == objectArray[0]) {
                this.mainClassTextField.setText(mainClassChooser.getSelectedMainClass());
            }
            dialog.dispose();
        }
    }
}

