/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class J2SESources
implements Sources,
PropertyChangeListener,
ChangeListener {
    private static final String BUILD_DIR_PROP = "${build.dir}";
    private static final String DIST_DIR_PROP = "${dist.dir}";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private boolean dirty;
    private final Map<String, SourceGroup[]> cachedGroups = new ConcurrentHashMap<String, SourceGroup[]>();
    private long eventId;
    private Sources delegate;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private SourceGroupModifierImplementation sgmi;
    private final FireAction fireTask = new FireAction();

    J2SESources(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testRoots) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = testRoots;
        this.sourceRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.testRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.delegate = this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String type) {
        SourceGroup[] _cachedGroups = this.cachedGroups.get(type);
        if (_cachedGroups != null) {
            return _cachedGroups;
        }
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                FileObject libLoc;
                long myEventId;
                Sources _delegate;
                J2SESources j2SESources = J2SESources.this;
                synchronized (j2SESources) {
                    if (J2SESources.this.dirty) {
                        J2SESources.this.delegate.removeChangeListener((ChangeListener)J2SESources.this);
                        J2SESources.this.delegate = J2SESources.this.initSources();
                        J2SESources.this.delegate.addChangeListener((ChangeListener)J2SESources.this);
                        J2SESources.this.dirty = false;
                    }
                    _delegate = J2SESources.this.delegate;
                    myEventId = ++J2SESources.this.eventId;
                }
                SourceGroup[] groups = _delegate.getSourceGroups(type);
                if (type.equals("generic") && (libLoc = J2SESources.this.getSharedLibraryFolderLocation()) != null) {
                    SourceGroup[] grps = new SourceGroup[groups.length + 1];
                    System.arraycopy(groups, 0, grps, 0, groups.length);
                    grps[grps.length - 1] = GenericSources.group(null, (FileObject)libLoc, (String)"sharedlibraries", (String)NbBundle.getMessage(J2SESources.class, (String)"LibrarySourceGroup_DisplayName"), null, null);
                    groups = grps;
                }
                J2SESources j2SESources2 = J2SESources.this;
                synchronized (j2SESources2) {
                    if (myEventId == J2SESources.this.eventId) {
                        J2SESources.this.cachedGroups.put(type, groups);
                    }
                }
                return groups;
            }
        });
    }

    private FileObject getSharedLibraryFolderLocation() {
        String libLoc = this.helper.getLibrariesLocation();
        if (libLoc != null) {
            FileObject libLocFO;
            String libLocEval = this.evaluator.evaluate(libLoc);
            File file = null;
            if (libLocEval != null) {
                file = this.helper.resolveFile(libLocEval);
            }
            if ((libLocFO = FileUtil.toFileObject(file)) != null) {
                FileObject libLocParent = libLocFO.getParent();
                return libLocParent;
            }
        }
        return null;
    }

    SourceGroupModifierImplementation getSourceGroupModifierImplementation() {
        return this.sgmi;
    }

    private Sources initSources() {
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        this.register(sourcesHelper, this.sourceRoots, "main");
        this.register(sourcesHelper, this.testRoots, "test");
        sourcesHelper.addNonSourceRoot(BUILD_DIR_PROP);
        sourcesHelper.addNonSourceRoot(DIST_DIR_PROP);
        sourcesHelper.registerExternalRoots(0, false);
        this.sgmi = sourcesHelper.createSourceGroupModifierImplementation();
        return sourcesHelper.createSources();
    }

    private void register(SourcesHelper sourcesHelper, SourceRoots roots, String hint) {
        String[] propNames = roots.getRootProperties();
        String[] rootNames = roots.getRootNames();
        for (int i = 0; i < propNames.length; ++i) {
            String prop = propNames[i];
            String displayName = roots.getRootDisplayName(rootNames[i], prop);
            String loc = "${" + prop + "}";
            String includes = "${includes}";
            String excludes = "${excludes}";
            sourcesHelper.sourceRoot(loc).includes(includes).excludes(excludes).hint(hint).displayName(displayName).add().type("java").add();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        J2SESources j2SESources = this;
        synchronized (j2SESources) {
            this.cachedGroups.clear();
            this.dirty = true;
        }
        ProjectManager.mutex().postReadRequest((Runnable)this.fireTask.activate());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (SourceRoots.PROP_ROOTS.equals(propName) || "build.dir".equals(propName) || "dist.dir".equals(propName)) {
            this.fireChange();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireChange();
    }

    private class FireAction
    implements Runnable {
        private AtomicBoolean fire = new AtomicBoolean();

        private FireAction() {
        }

        @Override
        public void run() {
            if (this.fire.getAndSet(false)) {
                J2SESources.this.changeSupport.fireChange();
            }
        }

        FireAction activate() {
            this.fire.set(true);
            return this;
        }
    }
}

