/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class RubyUtils {
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    private static final String CONTROLLER_SUFFIX = "Controller";
    private static final String HELPER_SUFFIX = "Helper";
    private static final String CONTROLLER_FILE_SUFFIX = "_controller.rb";
    private static final Logger LOGGER = Logger.getLogger(RubyUtils.class.getName());
    public static final String[] RUBY_KEYWORDS = new String[]{"alias", "and", "BEGIN", "begin", "break", "case", "class", "def", "defined?", "do", "else", "elsif", "END", "end", "ensure", "false", "for", "if", "in", "module", "next", "nil", "not", "or", "redo", "rescue", "retry", "return", "self", "super", "then", "true", "undef", "unless", "until", "when", "while", "yield"};
    public static final String[] RUBY_VIEW_EXTS;
    private static final String[] ACTIONMAILER_VIEW_EXTS;
    private static final Pattern RAILS_VERSION_PATTERN;

    private RubyUtils() {
    }

    public static boolean isRubyFile(FileObject f) {
        return RUBY_MIME_TYPE.equals(f.getMIMEType());
    }

    public static boolean isMarkabyFile(FileObject fileObject) {
        return "mab".equals(fileObject.getExt());
    }

    public static boolean isRhtmlFile(FileObject f) {
        return "application/x-httpd-eruby".equals(f.getMIMEType());
    }

    public static boolean isRubyDocument(Document doc) {
        String mimeType = (String)doc.getProperty("mimeType");
        return RUBY_MIME_TYPE.equals(mimeType);
    }

    public static boolean isRhtmlDocument(Document doc) {
        String mimeType = (String)doc.getProperty("mimeType");
        return "application/x-httpd-eruby".equals(mimeType);
    }

    public static boolean isYamlDocument(Document doc) {
        String mimeType = (String)doc.getProperty("mimeType");
        return "text/x-yaml".equals(mimeType);
    }

    public static boolean isYamlFile(FileObject f) {
        return "text/x-yaml".equals(f.getMIMEType());
    }

    public static boolean isRhtmlOrYamlFile(FileObject f) {
        String mimeType = f.getMIMEType();
        return "text/x-yaml".equals(mimeType) || "application/x-httpd-eruby".equals(mimeType);
    }

    public static boolean canContainRuby(FileObject f) {
        String mimeType = f.getMIMEType();
        return RUBY_MIME_TYPE.equals(mimeType) || "text/x-yaml".equals(mimeType) || "application/x-httpd-eruby".equals(mimeType);
    }

    public static String camelToUnderlinedName(String name) {
        StringBuilder sb = new StringBuilder();
        boolean lastWasUnderline = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean isCaps = Character.isUpperCase(c);
            if (isCaps) {
                if (i > 0 && !lastWasUnderline) {
                    sb.append('_');
                    lastWasUnderline = true;
                }
                c = Character.toLowerCase(c);
            }
            sb.append(c);
            lastWasUnderline = c == '_';
        }
        return sb.toString();
    }

    public static boolean isOperator(String name) {
        if (name.length() == 0) {
            return false;
        }
        switch (name.charAt(0)) {
            case '+': {
                return name.equals("+") || name.equals("+@");
            }
            case '-': {
                return name.equals("-") || name.equals("-@");
            }
            case '*': {
                return name.equals("*") || name.equals("**");
            }
            case '<': {
                return name.equals("<") || name.equals("<<") || name.equals("<=") || name.equals("<=>");
            }
            case '>': {
                return name.equals(">") || name.equals(">>") || name.equals(">=");
            }
            case '=': {
                return name.equals("=") || name.equals("==") || name.equals("===") || name.equals("=~");
            }
            case '!': {
                return name.equals("!=") || name.equals("!~");
            }
            case '&': {
                return name.equals("&") || name.equals("&&");
            }
            case '|': {
                return name.equals("|") || name.equals("||");
            }
            case '[': {
                return name.equals("[]") || name.equals("[]=");
            }
            case '%': {
                return name.equals("%");
            }
            case '/': {
                return name.equals("/");
            }
            case '~': {
                return name.equals("~");
            }
            case '^': {
                return name.equals("^");
            }
            case '`': {
                return name.equals("`");
            }
        }
        return false;
    }

    public static boolean isSafeIdentifierName(String name, int fromIndex) {
        char c;
        int i;
        int nameLength = name.length();
        if ("".equals(name.substring(fromIndex).trim())) {
            return false;
        }
        for (i = fromIndex; i < nameLength && ((c = name.charAt(i)) == '$' || c == '@' || c == ':'); ++i) {
            if (i > 0 && c != '@') {
                return false;
            }
            if (i > 1) {
                return false;
            }
            if (i + 1 != nameLength) continue;
            return false;
        }
        if (Character.isDigit(name.charAt(i))) {
            return false;
        }
        while (i < name.length()) {
            c = name.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c == '_' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '?' || c == '=' || c == '!')) {
                return RubyUtils.isOperator(name);
            }
            ++i;
        }
        return true;
    }

    public static String getIdentifierWarning(String name, int fromIndex) {
        if (RubyUtils.isSafeIdentifierName(name, fromIndex)) {
            return null;
        }
        return NbBundle.getMessage(RubyUtils.class, (String)"UnsafeIdentifierName");
    }

    public static String underlinedNameToCamel(String name) {
        StringBuilder sb = new StringBuilder();
        boolean upperCaseNext = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                upperCaseNext = true;
                continue;
            }
            if (c == '/') {
                upperCaseNext = true;
                sb.append("::");
                continue;
            }
            if (upperCaseNext) {
                c = Character.toUpperCase(c);
                upperCaseNext = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isValidConstantFQN(String name) {
        String[] mods;
        if (name.trim().length() == 0) {
            return false;
        }
        for (String mod : mods = name.split("::")) {
            if (RubyUtils.isValidConstantName(mod)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidConstantName(String name) {
        if (RubyUtils.isRubyKeyword(name)) {
            return false;
        }
        if (name.trim().length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!RubyUtils.isStrictIdentifierChar(c)) {
                return false;
            }
            if (c != '!' && c != '=' && c != '?') continue;
            return false;
        }
        return true;
    }

    static String[] parseConstantName(String mayBeFqn) {
        String module;
        String constant;
        int lastColon2 = mayBeFqn.lastIndexOf("::");
        if (lastColon2 != -1) {
            constant = mayBeFqn.substring(lastColon2 + 2);
            module = mayBeFqn.substring(0, lastColon2);
        } else {
            constant = mayBeFqn;
            module = "Kernel";
        }
        return new String[]{module, constant};
    }

    static List<String> getParentModules(String fqn) {
        int lastColon2 = fqn.lastIndexOf("::");
        if (lastColon2 == -1) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        while (lastColon2 > 0) {
            String parent = fqn.substring(0, lastColon2);
            result.add(parent);
            lastColon2 = parent.lastIndexOf("::");
        }
        return result;
    }

    public static boolean isValidRubyLocalVarName(String name) {
        if (RubyUtils.isRubyKeyword(name)) {
            return false;
        }
        if (name.trim().length() == 0) {
            return false;
        }
        if (Character.isUpperCase(name.charAt(0)) || Character.isWhitespace(name.charAt(0))) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            if (!Character.isWhitespace(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidRubyMethodName(String name) {
        if (RubyUtils.isRubyKeyword(name)) {
            return false;
        }
        if (name.trim().length() == 0) {
            return false;
        }
        if (RubyUtils.isOperator(name)) {
            return true;
        }
        if (Character.isUpperCase(name.charAt(0)) || Character.isWhitespace(name.charAt(0))) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return i == name.length() - 1 && (c == '!' || c == '=' || c == '?');
        }
        return true;
    }

    public static boolean isValidRubyIdentifier(String name) {
        if (RubyUtils.isRubyKeyword(name)) {
            return false;
        }
        if (name.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isWhitespace(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isRubyKeyword(String name) {
        return Arrays.binarySearch(RUBY_KEYWORDS, name) >= 0;
    }

    public static String getLineCommentPrefix() {
        return "#";
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$' || c == '@' || c == '&' || c == ':' || c == '!' || c == '?' || c == '=';
    }

    public static boolean isStrictIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '!' || c == '?' || c == '=';
    }

    public static String getControllerClass(FileObject controllerFile) {
        Project p = FileOwnerQuery.getOwner((FileObject)controllerFile);
        FileObject controllers = p.getProjectDirectory().getFileObject("app/controllers");
        if (controllers != null) {
            String relative = controllerFile.getName();
            for (FileObject f = controllerFile.getParent(); f != controllers && f != null; f = f.getParent()) {
                relative = f.getName() + "/" + relative;
            }
            return RubyUtils.underlinedNameToCamel(relative);
        }
        return null;
    }

    public static List<String> getControllerNames(FileObject fileInProject, boolean lowercase) {
        Project p = FileOwnerQuery.getOwner((FileObject)fileInProject);
        FileObject controllers = p.getProjectDirectory().getFileObject("app/controllers");
        if (controllers != null) {
            ArrayList<String> names = new ArrayList<String>();
            RubyUtils.addControllerNames(controllers, names, lowercase);
            return names;
        }
        return Collections.emptyList();
    }

    private static void addControllerNames(FileObject file, List<String> names, boolean lowercase) {
        String filename = file.getNameExt();
        if (filename.endsWith(CONTROLLER_FILE_SUFFIX)) {
            String name = filename.substring(0, filename.length() - CONTROLLER_FILE_SUFFIX.length());
            if (!lowercase) {
                name = RubyUtils.underlinedNameToCamel(name);
            }
            names.add(name);
        }
        for (FileObject child : file.getChildren()) {
            RubyUtils.addControllerNames(child, names, lowercase);
        }
    }

    public static String getControllerName(FileObject file) {
        String controllerName;
        String fileSuffix = "_controller";
        String parentAppDir = "controllers";
        String path = controllerName = file.getName().substring(0, file.getName().length() - fileSuffix.length());
        for (FileObject app = file.getParent(); app != null; app = app.getParent()) {
            if (app.getName().equals(parentAppDir) && (app.getParent() == null || app.getParent().getName().equals("app"))) {
                app = app.getParent();
                break;
            }
            path = app.getNameExt() + "/" + path;
        }
        return path;
    }

    public static FileObject getRailsViewFor(FileObject file, String methodName, String fileSuffix, String parentAppDir, boolean strict) {
        FileObject viewFile = null;
        try {
            FileObject app;
            String controllerName;
            String path = controllerName = file.getName().substring(0, file.getName().length() - fileSuffix.length());
            for (app = file.getParent(); app != null; app = app.getParent()) {
                if (app.getName().equals(parentAppDir) && (app.getParent() == null || app.getParent().getName().equals("app"))) {
                    app = app.getParent();
                    break;
                }
                path = app.getNameExt() + "/" + path;
            }
            if (app == null) {
                return null;
            }
            FileObject viewsFolder = app.getFileObject("views/" + path);
            if (viewsFolder == null) {
                return null;
            }
            if (methodName != null) {
                String ext;
                ArrayList<String> viewExts = new ArrayList<String>();
                viewExts.addAll(Arrays.asList(RUBY_VIEW_EXTS));
                viewExts.addAll(Arrays.asList(ACTIONMAILER_VIEW_EXTS));
                Iterator i$ = viewExts.iterator();
                while (i$.hasNext() && (viewFile = viewsFolder.getFileObject(methodName, ext = (String)i$.next())) == null) {
                }
                if (viewFile == null && strict) {
                    return null;
                }
            }
            if (viewFile == null && fileSuffix.length() > 0 && (viewFile = viewsFolder.getFileObject("index.rhtml")) == null) {
                block4: for (FileObject child : viewsFolder.getChildren()) {
                    String ext = child.getExt();
                    for (String e : RUBY_VIEW_EXTS) {
                        if (!ext.equalsIgnoreCase(e)) continue;
                        viewFile = child;
                        continue block4;
                    }
                }
            }
            if (viewFile == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (viewFile == null) {
            return null;
        }
        return viewFile;
    }

    public static FileObject getRailsControllerFor(FileObject file) {
        FileObject app;
        if (file.getParent() == null) {
            return null;
        }
        FileObject result = null;
        file = file.getParent();
        String fileName = file.getName();
        String path = "";
        if (!fileName.startsWith("_")) {
            path = fileName;
        }
        for (app = file.getParent(); app != null; app = app.getParent()) {
            if (app.getName().equals("views") && (app.getParent() == null || app.getParent().getName().equals("app"))) {
                app = app.getParent();
                break;
            }
            path = app.getNameExt() + "/" + path;
        }
        if (app == null) {
            return null;
        }
        result = app.getFileObject("controllers/" + path + CONTROLLER_FILE_SUFFIX);
        if (result == null) {
            result = app.getFileObject("models/" + path + ".rb");
        }
        return result;
    }

    static String join(String[] arr, String separator) {
        return RubyUtils.join(Arrays.asList(arr), separator);
    }

    static String join(Iterable<? extends String> iterable, String separator) {
        return RubyUtils.join(iterable, separator, separator);
    }

    static String join(Iterable<? extends String> iterable, String separator, String lastSeparator) {
        Iterator<? extends String> it = iterable.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuffer buf = new StringBuffer(60);
        buf.append(it.next());
        while (it.hasNext()) {
            String next = it.next();
            if (it.hasNext()) {
                buf.append(separator);
            } else {
                buf.append(lastSeparator);
            }
            buf.append(next);
        }
        return buf.toString();
    }

    public static BaseDocument getDocument(Parser.Result result) {
        return RubyUtils.getDocument(result, false);
    }

    public static BaseDocument getDocument(Parser.Result result, boolean forceOpen) {
        return (BaseDocument)result.getSnapshot().getSource().getDocument(forceOpen);
    }

    public static FileObject getFileObject(Parser.Result result) {
        return result.getSnapshot().getSource().getFileObject();
    }

    static boolean isRubyStubsURL(String url) {
        return url != null && url.indexOf("rubystubs") != -1;
    }

    static boolean isPlatformFile(FileObject fileObject) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (owner == null) {
            return true;
        }
        RubyPlatformProvider platformProvider = (RubyPlatformProvider)owner.getLookup().lookup(RubyPlatformProvider.class);
        return platformProvider == null;
    }

    static boolean isRails23OrHigher(String path) {
        Matcher m = RAILS_VERSION_PATTERN.matcher(path);
        if (!m.matches()) {
            return false;
        }
        String[] version = m.group(2).split("\\.");
        int major = Integer.parseInt(version[0]);
        int minor = Integer.parseInt(version[1]);
        if (major == 2) {
            return minor >= 3;
        }
        return major > 2;
    }

    static FileObject getFileObject(Document doc) {
        Object sdp = doc.getProperty("stream");
        if (sdp instanceof FileObject) {
            return (FileObject)sdp;
        }
        if (sdp instanceof DataObject) {
            return ((DataObject)sdp).getPrimaryFile();
        }
        return null;
    }

    static boolean isRailsController(FileObject fo) {
        boolean endsWithController = fo.getName().endsWith("_controller");
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return endsWithController;
        }
        FileObject controllerDir = owner.getProjectDirectory().getFileObject("app/controllers");
        if (controllerDir == null) {
            return endsWithController;
        }
        return FileUtil.isParentOf((FileObject)controllerDir, (FileObject)fo) && endsWithController;
    }

    static boolean isRailsProject(FileObject fo) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return false;
        }
        FileObject app = owner.getProjectDirectory().getFileObject("app");
        FileObject config = owner.getProjectDirectory().getFileObject("config");
        FileObject db = owner.getProjectDirectory().getFileObject("db");
        return app != null && config != null && db != null;
    }

    static FileObject getAppDir(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        return project.getProjectDirectory().getFileObject("app/");
    }

    static String helperName(String controllerName) {
        return RubyUtils.baseName(controllerName) + HELPER_SUFFIX;
    }

    static String controllerName(String baseName) {
        return RubyUtils.baseName(baseName) + CONTROLLER_SUFFIX;
    }

    static String baseName(String controllerName) {
        if (controllerName.endsWith(CONTROLLER_SUFFIX)) {
            return controllerName.substring(0, controllerName.length() - CONTROLLER_SUFFIX.length());
        }
        return controllerName;
    }

    static String[] addToArray(String[] array, String ... toAdd) {
        int i;
        if (toAdd == null || toAdd.length == 0) {
            return array;
        }
        String[] result = new String[array.length + toAdd.length];
        for (i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        for (i = array.length; i < array.length + toAdd.length; ++i) {
            result[i] = toAdd[i - array.length];
        }
        return result;
    }

    static {
        Arrays.sort(RUBY_KEYWORDS);
        RUBY_VIEW_EXTS = new String[]{"rhtml", "erb", "dryml", "mab", "rjs", "haml", "rxml", "dryml", "html.erb"};
        ACTIONMAILER_VIEW_EXTS = new String[]{"text.rhtml", "html.erb", "html.rhtml", "text.html.rhtml", "text.html.erb"};
        RAILS_VERSION_PATTERN = Pattern.compile(".*/(action|active){1}.+-(\\d+\\.\\d+\\.?\\d*).+");
    }
}

