/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.Ruby18Parser;
import org.jrubyparser.parser.Ruby19Parser;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.ruby.AstNodeAdapter;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class RubyParser
extends Parser {
    private RubyParseResult lastResult;

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        Context context = new Context(snapshot, event);
        final ArrayList errors = new ArrayList();
        context.errorHandler = new ParseErrorHandler(){

            @Override
            public void error(Error error) {
                errors.add(error);
            }
        };
        this.lastResult = this.parseBuffer(context, Sanitize.NONE);
        this.lastResult.setErrors(errors);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private static String asString(CharSequence sequence) {
        if (sequence instanceof String) {
            return (String)sequence;
        }
        return ((Object)sequence).toString();
    }

    private boolean sanitizeSource(Context context, Sanitize sanitizing) {
        if (sanitizing == Sanitize.MISSING_END) {
            context.sanitizedSource = context.source + ";end";
            int start = context.source.length();
            context.sanitizedRange = new OffsetRange(start, start + 4);
            context.sanitizedContents = "";
            return true;
        }
        int offset = context.caretOffset;
        if (sanitizing == Sanitize.ERROR_DOT || sanitizing == Sanitize.ERROR_LINE) {
            offset = context.errorOffset;
        }
        if (offset == -1) {
            return false;
        }
        String doc = context.source;
        if (offset > doc.length()) {
            return false;
        }
        if (sanitizing == Sanitize.BLOCK_START) {
            try {
                int start = GsfUtilities.getRowFirstNonWhite((CharSequence)doc, (int)offset);
                if (start != -1 && start + 2 < doc.length() && doc.regionMatches(start, "if", 0, 2)) {
                    char c = '\u0000';
                    if (start + 2 < doc.length()) {
                        c = doc.charAt(start + 2);
                    }
                    if (!Character.isLetter(c)) {
                        int removeStart = start;
                        int removeEnd = removeStart + 2;
                        StringBuilder sb = new StringBuilder(doc.length());
                        sb.append(doc.substring(0, removeStart));
                        for (int i = removeStart; i < removeEnd; ++i) {
                            sb.append(' ');
                        }
                        if (removeEnd < doc.length()) {
                            sb.append(doc.substring(removeEnd, doc.length()));
                        }
                        assert (sb.length() == doc.length());
                        context.sanitizedRange = new OffsetRange(removeStart, removeEnd);
                        context.sanitizedSource = sb.toString();
                        context.sanitizedContents = doc.substring(removeStart, removeEnd);
                        return true;
                    }
                }
                return false;
            }
            catch (BadLocationException ble) {
                return false;
            }
        }
        try {
            if ((GsfUtilities.isRowEmpty((CharSequence)doc, (int)offset) || GsfUtilities.isRowWhite((CharSequence)doc, (int)offset)) && (offset = GsfUtilities.getRowStart((CharSequence)doc, (int)offset) - 1) < 0) {
                offset = 0;
            }
            if (!GsfUtilities.isRowEmpty((CharSequence)doc, (int)offset) && !GsfUtilities.isRowWhite((CharSequence)doc, (int)offset)) {
                if (sanitizing == Sanitize.EDITED_LINE || sanitizing == Sanitize.ERROR_LINE) {
                    int lineEnd = GsfUtilities.getRowLastNonWhite((CharSequence)doc, (int)offset);
                    if (lineEnd != -1) {
                        StringBuilder sb = new StringBuilder(doc.length());
                        int lineStart = GsfUtilities.getRowStart((CharSequence)doc, (int)offset);
                        int rest = lineStart + 1;
                        sb.append(doc.substring(0, lineStart));
                        sb.append('#');
                        if (rest < doc.length()) {
                            sb.append(doc.substring(rest, doc.length()));
                        }
                        assert (sb.length() == doc.length());
                        context.sanitizedRange = new OffsetRange(lineStart, lineEnd);
                        context.sanitizedSource = sb.toString();
                        context.sanitizedContents = doc.substring(lineStart, lineEnd);
                        return true;
                    }
                } else {
                    int lineEnd;
                    assert (sanitizing == Sanitize.ERROR_DOT || sanitizing == Sanitize.EDITED_DOT);
                    int lineStart = GsfUtilities.getRowStart((CharSequence)doc, (int)offset);
                    for (lineEnd = offset - 1; lineEnd >= lineStart && lineEnd < doc.length() && Character.isWhitespace(doc.charAt(lineEnd)); --lineEnd) {
                    }
                    if (lineEnd > lineStart) {
                        StringBuilder sb = new StringBuilder(doc.length());
                        String line = doc.substring(lineStart, lineEnd + 1);
                        int removeChars = 0;
                        int removeEnd = lineEnd + 1;
                        if (line.endsWith(".") || line.endsWith("(")) {
                            removeChars = 1;
                        } else if (line.endsWith(",")) {
                            removeChars = 1;
                        } else if (line.endsWith(",:")) {
                            removeChars = 2;
                        } else if (line.endsWith(", :")) {
                            removeChars = 3;
                        } else if (line.endsWith(", ")) {
                            removeChars = 2;
                        } else if (line.endsWith("=> :")) {
                            removeChars = 4;
                        } else if (line.endsWith("=>:")) {
                            removeChars = 3;
                        } else if (line.endsWith("=>")) {
                            removeChars = 2;
                        } else if (line.endsWith("::")) {
                            removeChars = 2;
                        } else if (line.endsWith(":")) {
                            removeChars = 1;
                        } else if (line.endsWith("@@")) {
                            removeChars = 2;
                        } else if (line.endsWith("@") || line.endsWith("$")) {
                            removeChars = 1;
                        } else if (line.endsWith(",)")) {
                            removeChars = 1;
                            --removeEnd;
                        } else if (line.endsWith(", )")) {
                            removeChars = 1;
                            removeEnd -= 2;
                        }
                        if (removeChars == 0) {
                            return false;
                        }
                        int removeStart = removeEnd - removeChars;
                        sb.append(doc.substring(0, removeStart));
                        for (int i = 0; i < removeChars; ++i) {
                            sb.append(' ');
                        }
                        if (removeEnd < doc.length()) {
                            sb.append(doc.substring(removeEnd, doc.length()));
                        }
                        assert (sb.length() == doc.length());
                        context.sanitizedRange = new OffsetRange(removeStart, removeEnd);
                        context.sanitizedSource = sb.toString();
                        context.sanitizedContents = doc.substring(removeStart, removeEnd);
                        return true;
                    }
                }
            }
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return false;
    }

    private RubyParseResult sanitize(Context context, Sanitize sanitizing) {
        switch (sanitizing) {
            case NEVER: {
                return this.createParseResult(context.snapshot, null);
            }
            case NONE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_DOT);
                }
            }
            case EDITED_DOT: {
                if (context.errorOffset != -1 && context.errorOffset != context.caretOffset) {
                    return this.parseBuffer(context, Sanitize.ERROR_DOT);
                }
            }
            case ERROR_DOT: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.BLOCK_START);
                }
            }
            case BLOCK_START: {
                if (context.errorOffset != -1) {
                    return this.parseBuffer(context, Sanitize.ERROR_LINE);
                }
            }
            case ERROR_LINE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_LINE);
                }
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.MISSING_END);
            }
        }
        return this.createParseResult(context.snapshot, null);
    }

    protected void notifyError(Context context, IRubyWarnings.ID id, Severity severity, String description, int offset, Sanitize sanitizing, Object[] data) {
        char upcasedChar;
        char firstChar;
        if (description.startsWith(", ")) {
            description = description.substring(2);
        }
        if (description.startsWith("unexpected k")) {
            description = "Unexpected keyword " + description.substring(12);
        }
        if (description.startsWith("syntax error, expecting\t")) {
            int start = description.indexOf(" but found ");
            assert (start != -1);
            int end = description.indexOf("instead", start += 11);
            assert (end != -1);
            String found = description.substring(start, end);
            description = NbBundle.getMessage(RubyParser.class, (String)"UnexpectedError", (Object)found);
        }
        if (description.length() > 0 && (firstChar = description.charAt(0)) != (upcasedChar = Character.toUpperCase(firstChar))) {
            description = upcasedChar + description.substring(1);
        }
        RubyError error = new RubyError(description, id, context.snapshot.getSource().getFileObject(), offset, offset, severity, data);
        context.errorHandler.error((Error)error);
        if (sanitizing == Sanitize.NONE) {
            context.errorOffset = offset;
        }
    }

    protected RubyParseResult parseBuffer(final Context context, final Sanitize sanitizing) {
        org.jrubyparser.parser.ParserResult result;
        String source;
        block11: {
            boolean sanitizedSource = false;
            source = context.source;
            if (sanitizing != Sanitize.NONE && sanitizing != Sanitize.NEVER) {
                boolean ok = this.sanitizeSource(context, sanitizing);
                if (ok) {
                    assert (context.sanitizedSource != null);
                    sanitizedSource = true;
                    source = context.sanitizedSource;
                } else {
                    return this.sanitize(context, sanitizing);
                }
            }
            result = null;
            final boolean ignoreErrors = sanitizedSource;
            try {
                IRubyWarnings warnings = new IRubyWarnings(){

                    public boolean isVerbose() {
                        return false;
                    }

                    public void warn(IRubyWarnings.ID id, SourcePosition position, String message, Object ... data) {
                        if (!ignoreErrors) {
                            RubyParser.this.notifyError(context, id, Severity.WARNING, message, position.getStartOffset(), sanitizing, data);
                        }
                    }

                    public void warn(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
                        if (!ignoreErrors) {
                            RubyParser.this.notifyError(context, id, Severity.WARNING, message, -1, sanitizing, data);
                        }
                    }

                    public void warn(IRubyWarnings.ID id, String message, Object ... data) {
                        if (!ignoreErrors) {
                            RubyParser.this.notifyError(context, id, Severity.WARNING, message, -1, sanitizing, data);
                        }
                    }

                    public void warning(IRubyWarnings.ID id, String message, Object ... data) {
                        if (!ignoreErrors) {
                            RubyParser.this.notifyError(context, id, Severity.WARNING, message, -1, sanitizing, data);
                        }
                    }

                    public void warning(IRubyWarnings.ID id, SourcePosition position, String message, Object ... data) {
                        if (!ignoreErrors) {
                            RubyParser.this.notifyError(context, id, Severity.WARNING, message, position.getStartOffset(), sanitizing, data);
                        }
                    }

                    public void warning(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
                        if (!ignoreErrors) {
                            RubyParser.this.notifyError(context, id, Severity.WARNING, message, -1, sanitizing, data);
                        }
                    }
                };
                org.jrubyparser.parser.RubyParser parser = RubyParser.getParserFor(context);
                parser.setWarnings(warnings);
                if (sanitizing == Sanitize.NONE) {
                    context.errorOffset = -1;
                }
                String fileName = "";
                FileObject fo = context.snapshot.getSource().getFileObject();
                if (fo != null) {
                    fileName = fo.getNameExt();
                }
                ParserConfiguration configuration = new ParserConfiguration();
                LexerSource lexerSource = LexerSource.getSource((String)fileName, (Reader)new StringReader(source), (ParserConfiguration)configuration);
                result = parser.parse(configuration, lexerSource);
            }
            catch (SyntaxException e) {
                int offset = e.getPosition().getStartOffset();
                if (offset >= source.length() && (offset = source.length() - 1) < 0) {
                    offset = 0;
                }
                if (ignoreErrors) break block11;
                this.notifyError(context, IRubyWarnings.ID.SYNTAX_ERROR, Severity.ERROR, e.getMessage(), offset, sanitizing, new Object[]{e.getPid(), e});
            }
        }
        Node root = result != null ? result.getAST() : null;
        RootNode realRoot = null;
        if (root instanceof RootNode) {
            realRoot = (RootNode)root;
            root = realRoot.getBodyNode();
        }
        if (root != null) {
            context.sanitized = sanitizing;
            AstNodeAdapter ast = new AstNodeAdapter(null, root);
            RubyParseResult r = this.createParseResult(context.snapshot, root);
            r.setSanitized(context.sanitized, context.sanitizedRange, context.sanitizedContents);
            r.setSource(source);
            return r;
        }
        return this.sanitize(context, sanitizing);
    }

    private static org.jrubyparser.parser.RubyParser getParserFor(Context context) {
        FileObject fo = context.snapshot.getSource().getFileObject();
        if (fo == null) {
            return new Ruby18Parser();
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return new Ruby18Parser();
        }
        RubyPlatform platform = RubyPlatform.platformFor((Project)owner);
        if (platform == null) {
            return new Ruby18Parser();
        }
        if (platform.isJRuby()) {
            return RubyParser.getParserForJRuby(owner);
        }
        if (platform.is19()) {
            return new Ruby19Parser();
        }
        return new Ruby18Parser();
    }

    private static org.jrubyparser.parser.RubyParser getParserForJRuby(Project project) {
        String jvmArgs;
        PropertyEvaluator evaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
        if (evaluator != null && (jvmArgs = evaluator.getProperty("jvm.args")) != null) {
            return jvmArgs.contains("jruby.compat.version=RUBY1_9") ? new Ruby19Parser() : new Ruby18Parser();
        }
        return new Ruby18Parser();
    }

    protected RubyParseResult createParseResult(Snapshot snapshots, Node rootNode) {
        return new RubyParseResult(this, snapshots, rootNode);
    }

    public static RubyElement resolveHandle(ParserResult info, ElementHandle handle) {
        if (handle instanceof AstElement) {
            AstElement element = (AstElement)handle;
            ParserResult oldInfo = element.getInfo();
            if (oldInfo == info) {
                return element;
            }
            Node oldNode = element.getNode();
            Node oldRoot = AstUtilities.getRoot((Parser.Result)oldInfo);
            Node newRoot = AstUtilities.getRoot((Parser.Result)info);
            if (newRoot == null) {
                return null;
            }
            Node newNode = RubyParser.find(oldRoot, oldNode, newRoot);
            if (newNode != null) {
                AstElement co = AstElement.create(info, newNode);
                return co;
            }
        } else if (handle instanceof RubyElement) {
            return (RubyElement)handle;
        }
        return null;
    }

    private static Node find(Node oldRoot, Node oldObject, Node newRoot) {
        List oldChildren = oldRoot.childNodes();
        List newChildren = newRoot.childNodes();
        Iterator itOld = oldChildren.iterator();
        Iterator itNew = newChildren.iterator();
        while (itOld.hasNext()) {
            if (!itNew.hasNext()) {
                return null;
            }
            Node o = (Node)itOld.next();
            Node n = (Node)itNew.next();
            if (o == oldObject) {
                return n;
            }
            Node match = RubyParser.find(o, oldObject, n);
            if (match == null) continue;
            return match;
        }
        if (itNew.hasNext()) {
            return null;
        }
        return null;
    }

    public static class RubyError
    implements Error.Badging {
        private final String displayName;
        private final IRubyWarnings.ID id;
        private final FileObject file;
        private final int startPosition;
        private final int endPosition;
        private final Severity severity;
        private final Object[] parameters;

        public RubyError(String displayName, IRubyWarnings.ID id, FileObject file, int startPosition, int endPosition, Severity severity, Object[] parameters) {
            this.displayName = displayName;
            this.id = id;
            this.file = file;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.severity = severity;
            this.parameters = parameters;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public FileObject getFile() {
            return this.file;
        }

        public String getKey() {
            return this.id != null ? this.id.name() : "";
        }

        public IRubyWarnings.ID getId() {
            return this.id;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String toString() {
            return "RubyError:" + this.displayName;
        }

        public String getDescription() {
            return null;
        }

        public boolean isLineError() {
            return true;
        }

        public boolean showExplorerBadge() {
            return !RubyUtils.isRhtmlFile(this.file);
        }
    }

    private static interface ParseErrorHandler {
        public void error(Error var1);
    }

    public static class Context {
        private final Snapshot snapshot;
        private final SourceModificationEvent event;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;
        private ParseErrorHandler errorHandler;

        public Context(Snapshot snapshot, SourceModificationEvent event) {
            this.snapshot = snapshot;
            this.event = event;
            this.source = RubyParser.asString(snapshot.getText());
            this.caretOffset = GsfUtilities.getLastKnownCaretOffset((Snapshot)snapshot, (EventObject)event);
        }

        public String toString() {
            return "RubyParser.Context(" + this.snapshot.getSource().getFileObject() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        public Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }
    }

    public static enum Sanitize {
        NEVER,
        NONE,
        EDITED_DOT,
        ERROR_DOT,
        BLOCK_START,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_END;

    }

    private static final class Factory
    extends ParserFactory {
        private Factory() {
        }

        public Parser createParser(Collection<Snapshot> snapshots) {
            return new RubyParser();
        }
    }
}

