/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.FindersHelper;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.elements.IndexedMethod;

final class RubyDynamicFindersCompleter {
    private final CompletionRequest request;
    private final int anchor;
    private final List<? super CompletionProposal> proposals;

    private RubyDynamicFindersCompleter(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor) {
        this.request = request;
        this.anchor = anchor;
        this.proposals = proposals;
    }

    static Set<IndexedMethod> proposeDynamicMethods(Set<IndexedMethod> methods, List<? super CompletionProposal> proposals, CompletionRequest request, int anchor) {
        RubyDynamicFindersCompleter completer = new RubyDynamicFindersCompleter(proposals, request, anchor);
        return completer.filterAndHandleDynamicMethods(methods);
    }

    private Set<IndexedMethod> filterAndHandleDynamicMethods(Set<IndexedMethod> methods) {
        HashSet<IndexedMethod> result = new HashSet<IndexedMethod>(methods);
        HashSet<IndexedMethod> finders = new HashSet<IndexedMethod>();
        for (IndexedMethod indexedMethod : methods) {
            if (IndexedMethod.MethodType.DYNAMIC_FINDER != indexedMethod.getMethodType()) continue;
            finders.add(indexedMethod);
            result.remove(indexedMethod);
        }
        this.proposeDynamicMethods(finders);
        return result;
    }

    private void proposeDynamicMethods(Set<IndexedMethod> finders) {
        HashMap<String, IndexedMethod> virtualMethods = new HashMap<String, IndexedMethod>();
        Iterator<IndexedMethod> it = finders.iterator();
        while (it.hasNext()) {
            IndexedMethod method = it.next();
            String name = method.getName();
            int nextAnd = FindersHelper.nextAttributeLocation(name, this.request.prefix.length());
            if (nextAnd != -1) {
                String key = FindersHelper.subToNextAttribute(name, nextAnd);
                if (virtualMethods.get(key) == null) {
                    virtualMethods.put(key, method);
                    RubyCompletionItem.VirtualFinderMethodItem methodItem = new RubyCompletionItem.VirtualFinderMethodItem(method, this.anchor, this.request, key);
                    methodItem.setSmart(method.isSmart());
                    this.proposals.add((CompletionProposal)methodItem);
                }
                it.remove();
                continue;
            }
            RubyCompletionItem.FinderMethodItem methodItem = new RubyCompletionItem.FinderMethodItem(method, this.anchor, this.request);
            methodItem.setSmart(method.isSmart());
            this.proposals.add((CompletionProposal)methodItem);
        }
    }
}

